/*
 * Decompiled with CFR 0.152.
 */
package scouter.repack.net.bytebuddy.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import scouter.repack.net.bytebuddy.description.enumeration.EnumerationDescription;
import scouter.repack.net.bytebuddy.description.field.FieldDescription;
import scouter.repack.net.bytebuddy.description.field.FieldList;
import scouter.repack.net.bytebuddy.description.method.MethodDescription;
import scouter.repack.net.bytebuddy.description.method.ParameterDescription;
import scouter.repack.net.bytebuddy.description.method.ParameterList;
import scouter.repack.net.bytebuddy.description.type.TypeDescription;
import scouter.repack.net.bytebuddy.description.type.TypeList;
import scouter.repack.net.bytebuddy.dynamic.scaffold.FieldLocator;
import scouter.repack.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import scouter.repack.net.bytebuddy.implementation.Implementation;
import scouter.repack.net.bytebuddy.implementation.LoadedTypeInitializer;
import scouter.repack.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import scouter.repack.net.bytebuddy.implementation.bytecode.Removal;
import scouter.repack.net.bytebuddy.implementation.bytecode.StackManipulation;
import scouter.repack.net.bytebuddy.implementation.bytecode.assign.Assigner;
import scouter.repack.net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import scouter.repack.net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import scouter.repack.net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import scouter.repack.net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import scouter.repack.net.bytebuddy.implementation.bytecode.constant.LongConstant;
import scouter.repack.net.bytebuddy.implementation.bytecode.constant.NullConstant;
import scouter.repack.net.bytebuddy.implementation.bytecode.constant.TextConstant;
import scouter.repack.net.bytebuddy.implementation.bytecode.member.FieldAccess;
import scouter.repack.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import scouter.repack.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import scouter.repack.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import scouter.repack.net.bytebuddy.jar.asm.MethodVisitor;
import scouter.repack.net.bytebuddy.jar.asm.Type;
import scouter.repack.net.bytebuddy.matcher.ElementMatchers;
import scouter.repack.net.bytebuddy.utility.CompoundList;
import scouter.repack.net.bytebuddy.utility.JavaConstant;
import scouter.repack.net.bytebuddy.utility.JavaType;
import scouter.repack.net.bytebuddy.utility.RandomString;

public class InvokeDynamic
implements Implementation.Composable {
    protected final MethodDescription.InDefinedShape bootstrapMethod;
    protected final List<?> handleArguments;
    protected final InvocationProvider invocationProvider;
    protected final TerminationHandler terminationHandler;
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected InvokeDynamic(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing) {
        this.bootstrapMethod = bootstrapMethod;
        this.handleArguments = handleArguments;
        this.invocationProvider = invocationProvider;
        this.terminationHandler = terminationHandler;
        this.assigner = assigner;
        this.typing = typing;
    }

    public static WithImplicitTarget bootstrap(Method method, Object ... rawArgument) {
        return InvokeDynamic.bootstrap((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(method), rawArgument);
    }

    public static WithImplicitTarget bootstrap(Method method, List<?> rawArguments) {
        return InvokeDynamic.bootstrap((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(method), rawArguments);
    }

    public static WithImplicitTarget bootstrap(Constructor<?> constructor, Object ... rawArgument) {
        return InvokeDynamic.bootstrap((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedConstructor(constructor), rawArgument);
    }

    public static WithImplicitTarget bootstrap(Constructor<?> constructor, List<?> rawArguments) {
        return InvokeDynamic.bootstrap((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedConstructor(constructor), rawArguments);
    }

    public static WithImplicitTarget bootstrap(MethodDescription.InDefinedShape bootstrapMethod, Object ... rawArgument) {
        return InvokeDynamic.bootstrap(bootstrapMethod, Arrays.asList(rawArgument));
    }

    public static WithImplicitTarget bootstrap(MethodDescription.InDefinedShape bootstrapMethod, List<?> rawArguments) {
        ArrayList arguments = new ArrayList(rawArguments.size());
        for (Object argument : rawArguments) {
            if (argument instanceof Class) {
                argument = new TypeDescription.ForLoadedType((Class)argument);
            } else if (JavaType.METHOD_HANDLE.getTypeStub().isInstance(argument)) {
                argument = JavaConstant.MethodHandle.ofLoaded(argument);
            } else if (JavaType.METHOD_TYPE.getTypeStub().isInstance(argument)) {
                argument = JavaConstant.MethodType.ofLoaded(argument);
            }
            arguments.add(argument);
        }
        if (!bootstrapMethod.isBootstrap(arguments)) {
            throw new IllegalArgumentException("Not a valid bootstrap method " + bootstrapMethod + " for " + arguments);
        }
        ArrayList serializedArguments = new ArrayList(arguments.size());
        for (Object anArgument : arguments) {
            if (anArgument instanceof TypeDescription) {
                anArgument = Type.getType(((TypeDescription)anArgument).getDescriptor());
            } else if (anArgument instanceof JavaConstant) {
                anArgument = ((JavaConstant)anArgument).asConstantPoolValue();
            }
            serializedArguments.add(anArgument);
        }
        return new WithImplicitTarget(bootstrapMethod, serializedArguments, new InvocationProvider.Default(), TerminationHandler.RETURNING, Assigner.DEFAULT, Assigner.Typing.STATIC);
    }

    public InvokeDynamic withBooleanValue(boolean ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (boolean aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForBooleanConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withByteValue(byte ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (byte aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForByteConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withShortValue(short ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (short aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForShortConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withCharacterValue(char ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (char aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForCharacterConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withIntegerValue(int ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (int aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForIntegerConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withLongValue(long ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (long aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForLongConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withFloatValue(float ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (float aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForFloatConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withDoubleValue(double ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (double aValue : value) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForDoubleConstant(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withValue(Object ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (Object aValue : value) {
            argumentProviders.add(InvocationProvider.ArgumentProvider.ConstantPoolWrapper.of(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public WithImplicitType withReference(Object value) {
        return new WithImplicitType.OfInstance(this.bootstrapMethod, this.handleArguments, this.invocationProvider, this.terminationHandler, this.assigner, this.typing, value);
    }

    public InvokeDynamic withReference(Object ... value) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(value.length);
        for (Object aValue : value) {
            argumentProviders.add(InvocationProvider.ArgumentProvider.ForInstance.of(aValue));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withType(TypeDescription ... typeDescription) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(typeDescription.length);
        for (TypeDescription aTypeDescription : typeDescription) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForClassConstant(aTypeDescription));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withEnumeration(EnumerationDescription ... enumerationDescription) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(enumerationDescription.length);
        for (EnumerationDescription anEnumerationDescription : enumerationDescription) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForEnumerationValue(anEnumerationDescription));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withInstance(JavaConstant ... javaConstant) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(javaConstant.length);
        for (JavaConstant aJavaConstant : javaConstant) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForJavaConstant(aJavaConstant));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withNullValue(Class<?> ... type) {
        return this.withNullValue(new TypeList.ForLoadedTypes(type).toArray(new TypeDescription[type.length]));
    }

    public InvokeDynamic withNullValue(TypeDescription ... typeDescription) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(typeDescription.length);
        for (TypeDescription aTypeDescription : typeDescription) {
            if (aTypeDescription.isPrimitive()) {
                throw new IllegalArgumentException("Cannot assign null to primitive type: " + aTypeDescription);
            }
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForNullValue(aTypeDescription));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withArgument(int ... index) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(index.length);
        for (int anIndex : index) {
            if (anIndex < 0) {
                throw new IllegalArgumentException("Method parameter indices cannot be negative: " + anIndex);
            }
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForMethodParameter(anIndex));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public WithImplicitType withArgument(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Method parameter indices cannot be negative: " + index);
        }
        return new WithImplicitType.OfArgument(this.bootstrapMethod, this.handleArguments, this.invocationProvider, this.terminationHandler, this.assigner, this.typing, index);
    }

    public InvokeDynamic withThis(Class<?> ... type) {
        return this.withThis(new TypeList.ForLoadedTypes(type).toArray(new TypeDescription[type.length]));
    }

    public InvokeDynamic withThis(TypeDescription ... typeDescription) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(typeDescription.length);
        for (TypeDescription aTypeDescription : typeDescription) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForThisInstance(aTypeDescription));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withMethodArguments() {
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(InvocationProvider.ArgumentProvider.ForInterceptedMethodParameters.INSTANCE), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withImplicitAndMethodArguments() {
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(InvocationProvider.ArgumentProvider.ForInterceptedMethodInstanceAndParameters.INSTANCE), this.terminationHandler, this.assigner, this.typing);
    }

    public InvokeDynamic withField(String ... name) {
        return this.withField(FieldLocator.ForClassHierarchy.Factory.INSTANCE, name);
    }

    public InvokeDynamic withField(FieldLocator.Factory fieldLocatorFactory, String ... name) {
        ArrayList<InvocationProvider.ArgumentProvider> argumentProviders = new ArrayList<InvocationProvider.ArgumentProvider>(name.length);
        for (String aName : name) {
            argumentProviders.add(new InvocationProvider.ArgumentProvider.ForField(aName, fieldLocatorFactory));
        }
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArguments(argumentProviders), this.terminationHandler, this.assigner, this.typing);
    }

    public WithImplicitType withField(String name) {
        return this.withField(name, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
    }

    public WithImplicitType withField(String name, FieldLocator.Factory fieldLocatorFactory) {
        return new WithImplicitType.OfField(this.bootstrapMethod, this.handleArguments, this.invocationProvider, this.terminationHandler, this.assigner, this.typing, name, fieldLocatorFactory);
    }

    public Implementation.Composable withAssigner(Assigner assigner, Assigner.Typing typing) {
        return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider, this.terminationHandler, assigner, typing);
    }

    @Override
    public Implementation andThen(Implementation implementation) {
        return new Implementation.Compound(new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider, TerminationHandler.DROPPING, this.assigner, this.typing), implementation);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.invocationProvider.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(implementationTarget.getInstrumentedType());
    }

    protected InvocationProvider getInvocationProvider() {
        return this.invocationProvider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvokeDynamic)) {
            return false;
        }
        InvokeDynamic other = (InvokeDynamic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MethodDescription.InDefinedShape this$bootstrapMethod = this.bootstrapMethod;
        MethodDescription.InDefinedShape other$bootstrapMethod = other.bootstrapMethod;
        if (this$bootstrapMethod == null ? other$bootstrapMethod != null : !this$bootstrapMethod.equals(other$bootstrapMethod)) {
            return false;
        }
        List<?> this$handleArguments = this.handleArguments;
        List<?> other$handleArguments = other.handleArguments;
        if (this$handleArguments == null ? other$handleArguments != null : !((Object)this$handleArguments).equals(other$handleArguments)) {
            return false;
        }
        InvocationProvider this$invocationProvider = this.getInvocationProvider();
        InvocationProvider other$invocationProvider = other.getInvocationProvider();
        if (this$invocationProvider == null ? other$invocationProvider != null : !this$invocationProvider.equals(other$invocationProvider)) {
            return false;
        }
        TerminationHandler this$terminationHandler = this.terminationHandler;
        TerminationHandler other$terminationHandler = other.terminationHandler;
        if (this$terminationHandler == null ? other$terminationHandler != null : !((Object)((Object)this$terminationHandler)).equals((Object)other$terminationHandler)) {
            return false;
        }
        Assigner this$assigner = this.assigner;
        Assigner other$assigner = other.assigner;
        if (this$assigner == null ? other$assigner != null : !this$assigner.equals(other$assigner)) {
            return false;
        }
        Assigner.Typing this$typing = this.typing;
        Assigner.Typing other$typing = other.typing;
        return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvokeDynamic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MethodDescription.InDefinedShape $bootstrapMethod = this.bootstrapMethod;
        result = result * 59 + ($bootstrapMethod == null ? 43 : $bootstrapMethod.hashCode());
        List<?> $handleArguments = this.handleArguments;
        result = result * 59 + ($handleArguments == null ? 43 : ((Object)$handleArguments).hashCode());
        InvocationProvider $invocationProvider = this.getInvocationProvider();
        result = result * 59 + ($invocationProvider == null ? 43 : $invocationProvider.hashCode());
        TerminationHandler $terminationHandler = this.terminationHandler;
        result = result * 59 + ($terminationHandler == null ? 43 : ((Object)((Object)$terminationHandler)).hashCode());
        Assigner $assigner = this.assigner;
        result = result * 59 + ($assigner == null ? 43 : $assigner.hashCode());
        Assigner.Typing $typing = this.typing;
        result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
        return result;
    }

    protected class Appender
    implements ByteCodeAppender {
        private final TypeDescription instrumentedType;

        public Appender(TypeDescription instrumentedType) {
            this.instrumentedType = instrumentedType;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            InvocationProvider.Target.Resolved target = InvokeDynamic.this.invocationProvider.make(instrumentedMethod).resolve(this.instrumentedType, InvokeDynamic.this.assigner, InvokeDynamic.this.typing);
            StackManipulation.Size size = new StackManipulation.Compound(target.getStackManipulation(), MethodInvocation.invoke(InvokeDynamic.this.bootstrapMethod).dynamic(target.getInternalName(), target.getReturnType(), target.getParameterTypes(), InvokeDynamic.this.handleArguments), InvokeDynamic.this.terminationHandler.resolve(instrumentedMethod, target.getReturnType(), InvokeDynamic.this.assigner, InvokeDynamic.this.typing)).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Appender appender = (Appender)other;
            return this.instrumentedType.equals(appender.instrumentedType) && InvokeDynamic.this.equals(appender.getOuter());
        }

        private InvokeDynamic getOuter() {
            return InvokeDynamic.this;
        }

        public int hashCode() {
            return this.instrumentedType.hashCode() + 31 * InvokeDynamic.this.hashCode();
        }
    }

    public static abstract class WithImplicitType
    extends AbstractDelegator {
        protected WithImplicitType(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing) {
            super(bootstrapMethod, handleArguments, invocationProvider, terminationHandler, assigner, typing);
        }

        public InvokeDynamic as(Class<?> type) {
            return this.as(new TypeDescription.ForLoadedType(type));
        }

        public abstract InvokeDynamic as(TypeDescription var1);

        @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="Super type implementation convers use case")
        protected static class OfField
        extends WithImplicitType {
            private final String fieldName;
            private final FieldLocator.Factory fieldLocatorFactory;

            protected OfField(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing, String fieldName, FieldLocator.Factory fieldLocatorFactory) {
                super(bootstrapMethod, handleArguments, invocationProvider, terminationHandler, assigner, typing);
                this.fieldName = fieldName;
                this.fieldLocatorFactory = fieldLocatorFactory;
            }

            @Override
            public InvokeDynamic as(TypeDescription typeDescription) {
                return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(new InvocationProvider.ArgumentProvider.ForField.WithExplicitType(this.fieldName, this.fieldLocatorFactory, typeDescription)), this.terminationHandler, this.assigner, this.typing);
            }

            @Override
            protected InvokeDynamic materialize() {
                return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(new InvocationProvider.ArgumentProvider.ForField(this.fieldName, this.fieldLocatorFactory)), this.terminationHandler, this.assigner, this.typing);
            }
        }

        @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="Super type implementation convers use case")
        protected static class OfArgument
        extends WithImplicitType {
            private final int index;

            protected OfArgument(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing, int index) {
                super(bootstrapMethod, handleArguments, invocationProvider, terminationHandler, assigner, typing);
                this.index = index;
            }

            @Override
            public InvokeDynamic as(TypeDescription typeDescription) {
                return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(new InvocationProvider.ArgumentProvider.ForMethodParameter.WithExplicitType(this.index, typeDescription)), this.terminationHandler, this.assigner, this.typing);
            }

            @Override
            protected InvokeDynamic materialize() {
                return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(new InvocationProvider.ArgumentProvider.ForMethodParameter(this.index)), this.terminationHandler, this.assigner, this.typing);
            }
        }

        @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="Super type implementation convers use case")
        protected static class OfInstance
        extends WithImplicitType {
            private final Object value;
            private final InvocationProvider.ArgumentProvider argumentProvider;

            protected OfInstance(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing, Object value) {
                super(bootstrapMethod, handleArguments, invocationProvider, terminationHandler, assigner, typing);
                this.value = value;
                this.argumentProvider = InvocationProvider.ArgumentProvider.ForInstance.of(value);
            }

            @Override
            public InvokeDynamic as(TypeDescription typeDescription) {
                if (!typeDescription.asBoxed().isInstance(this.value)) {
                    throw new IllegalArgumentException(this.value + " is not of type " + typeDescription);
                }
                return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(new InvocationProvider.ArgumentProvider.ForInstance(this.value, typeDescription)), this.terminationHandler, this.assigner, this.typing);
            }

            @Override
            protected InvokeDynamic materialize() {
                return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.appendArgument(this.argumentProvider), this.terminationHandler, this.assigner, this.typing);
            }
        }
    }

    public static class WithImplicitTarget
    extends WithImplicitArguments {
        protected WithImplicitTarget(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing) {
            super(bootstrapMethod, handleArguments, invocationProvider, terminationHandler, assigner, typing);
        }

        public WithImplicitArguments invoke(Class<?> returnType) {
            return this.invoke(new TypeDescription.ForLoadedType(returnType));
        }

        public WithImplicitArguments invoke(TypeDescription returnType) {
            return new WithImplicitArguments(this.bootstrapMethod, this.handleArguments, this.invocationProvider.withReturnTypeProvider(new InvocationProvider.ReturnTypeProvider.ForExplicitType(returnType)), this.terminationHandler, this.assigner, this.typing);
        }

        public WithImplicitArguments invoke(String methodName) {
            return new WithImplicitArguments(this.bootstrapMethod, this.handleArguments, this.invocationProvider.withNameProvider(new InvocationProvider.NameProvider.ForExplicitName(methodName)), this.terminationHandler, this.assigner, this.typing);
        }

        public WithImplicitArguments invoke(String methodName, Class<?> returnType) {
            return this.invoke(methodName, new TypeDescription.ForLoadedType(returnType));
        }

        public WithImplicitArguments invoke(String methodName, TypeDescription returnType) {
            return new WithImplicitArguments(this.bootstrapMethod, this.handleArguments, this.invocationProvider.withNameProvider(new InvocationProvider.NameProvider.ForExplicitName(methodName)).withReturnTypeProvider(new InvocationProvider.ReturnTypeProvider.ForExplicitType(returnType)), this.terminationHandler, this.assigner, this.typing);
        }
    }

    public static class WithImplicitArguments
    extends AbstractDelegator {
        protected WithImplicitArguments(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing) {
            super(bootstrapMethod, handleArguments, invocationProvider, terminationHandler, assigner, typing);
        }

        public InvokeDynamic withoutArguments() {
            return new InvokeDynamic(this.bootstrapMethod, this.handleArguments, this.invocationProvider.withoutArguments(), this.terminationHandler, this.assigner, this.typing);
        }

        @Override
        protected InvokeDynamic materialize() {
            return this.withoutArguments();
        }

        @Override
        public WithImplicitArguments withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new WithImplicitArguments(this.bootstrapMethod, this.handleArguments, this.invocationProvider, this.terminationHandler, assigner, typing);
        }
    }

    protected static abstract class AbstractDelegator
    extends InvokeDynamic {
        protected AbstractDelegator(MethodDescription.InDefinedShape bootstrapMethod, List<?> handleArguments, InvocationProvider invocationProvider, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing) {
            super(bootstrapMethod, handleArguments, invocationProvider, terminationHandler, assigner, typing);
        }

        protected abstract InvokeDynamic materialize();

        @Override
        public InvokeDynamic withBooleanValue(boolean ... value) {
            return this.materialize().withBooleanValue(value);
        }

        @Override
        public InvokeDynamic withByteValue(byte ... value) {
            return this.materialize().withByteValue(value);
        }

        @Override
        public InvokeDynamic withShortValue(short ... value) {
            return this.materialize().withShortValue(value);
        }

        @Override
        public InvokeDynamic withCharacterValue(char ... value) {
            return this.materialize().withCharacterValue(value);
        }

        @Override
        public InvokeDynamic withIntegerValue(int ... value) {
            return this.materialize().withIntegerValue(value);
        }

        @Override
        public InvokeDynamic withLongValue(long ... value) {
            return this.materialize().withLongValue(value);
        }

        @Override
        public InvokeDynamic withFloatValue(float ... value) {
            return this.materialize().withFloatValue(value);
        }

        @Override
        public InvokeDynamic withDoubleValue(double ... value) {
            return this.materialize().withDoubleValue(value);
        }

        @Override
        public InvokeDynamic withValue(Object ... value) {
            return this.materialize().withValue(value);
        }

        @Override
        public WithImplicitType withReference(Object value) {
            return this.materialize().withReference(value);
        }

        @Override
        public InvokeDynamic withReference(Object ... value) {
            return this.materialize().withReference(value);
        }

        @Override
        public InvokeDynamic withType(TypeDescription ... typeDescription) {
            return this.materialize().withType(typeDescription);
        }

        @Override
        public InvokeDynamic withInstance(JavaConstant ... javaConstant) {
            return this.materialize().withInstance(javaConstant);
        }

        @Override
        public InvokeDynamic withNullValue(Class<?> ... type) {
            return this.materialize().withNullValue(type);
        }

        @Override
        public InvokeDynamic withNullValue(TypeDescription ... typeDescription) {
            return this.materialize().withNullValue(typeDescription);
        }

        @Override
        public InvokeDynamic withArgument(int ... index) {
            return this.materialize().withArgument(index);
        }

        @Override
        public WithImplicitType withArgument(int index) {
            return this.materialize().withArgument(index);
        }

        @Override
        public InvokeDynamic withThis(Class<?> ... type) {
            return this.materialize().withThis(type);
        }

        @Override
        public InvokeDynamic withThis(TypeDescription ... typeDescription) {
            return this.materialize().withThis(typeDescription);
        }

        @Override
        public InvokeDynamic withMethodArguments() {
            return this.materialize().withMethodArguments();
        }

        @Override
        public InvokeDynamic withImplicitAndMethodArguments() {
            return this.materialize().withImplicitAndMethodArguments();
        }

        @Override
        public InvokeDynamic withField(String ... fieldName) {
            return this.materialize().withField(fieldName);
        }

        @Override
        public InvokeDynamic withEnumeration(EnumerationDescription ... enumerationDescription) {
            return this.materialize().withEnumeration(enumerationDescription);
        }

        @Override
        public InvokeDynamic withField(FieldLocator.Factory fieldLocatorFactory, String ... name) {
            return this.materialize().withField(fieldLocatorFactory, name);
        }

        @Override
        public WithImplicitType withField(String name) {
            return this.materialize().withField(name);
        }

        @Override
        public WithImplicitType withField(String name, FieldLocator.Factory fieldLocatorFactory) {
            return this.materialize().withField(name, fieldLocatorFactory);
        }

        @Override
        public Implementation.Composable withAssigner(Assigner assigner, Assigner.Typing typing) {
            return this.materialize().withAssigner(assigner, typing);
        }

        @Override
        public Implementation andThen(Implementation implementation) {
            return this.materialize().andThen(implementation);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return this.materialize().prepare(instrumentedType);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return this.materialize().appender(implementationTarget);
        }
    }

    protected static enum TerminationHandler {
        RETURNING{

            @Override
            protected StackManipulation resolve(MethodDescription interceptedMethod, TypeDescription returnType, Assigner assigner, Assigner.Typing typing) {
                StackManipulation stackManipulation = assigner.assign(returnType.asGenericType(), interceptedMethod.getReturnType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot return " + returnType + " from " + interceptedMethod);
                }
                return new StackManipulation.Compound(stackManipulation, MethodReturn.of(interceptedMethod.getReturnType()));
            }
        }
        ,
        DROPPING{

            @Override
            protected StackManipulation resolve(MethodDescription interceptedMethod, TypeDescription returnType, Assigner assigner, Assigner.Typing typing) {
                return Removal.of(interceptedMethod.isConstructor() ? interceptedMethod.getDeclaringType() : interceptedMethod.getReturnType());
            }
        };


        protected abstract StackManipulation resolve(MethodDescription var1, TypeDescription var2, Assigner var3, Assigner.Typing var4);
    }

    protected static interface InvocationProvider {
        public Target make(MethodDescription var1);

        public InvocationProvider appendArguments(List<ArgumentProvider> var1);

        public InvocationProvider appendArgument(ArgumentProvider var1);

        public InvocationProvider withoutArguments();

        public InvocationProvider withNameProvider(NameProvider var1);

        public InvocationProvider withReturnTypeProvider(ReturnTypeProvider var1);

        public InstrumentedType prepare(InstrumentedType var1);

        public static class Default
        implements InvocationProvider {
            private final NameProvider nameProvider;
            private final ReturnTypeProvider returnTypeProvider;
            private final List<ArgumentProvider> argumentProviders;

            protected Default() {
                this(NameProvider.ForInterceptedMethod.INSTANCE, ReturnTypeProvider.ForInterceptedMethod.INSTANCE, Collections.singletonList(ArgumentProvider.ForInterceptedMethodInstanceAndParameters.INSTANCE));
            }

            protected Default(NameProvider nameProvider, ReturnTypeProvider returnTypeProvider, List<ArgumentProvider> argumentProviders) {
                this.nameProvider = nameProvider;
                this.returnTypeProvider = returnTypeProvider;
                this.argumentProviders = argumentProviders;
            }

            @Override
            public Target make(MethodDescription methodDescription) {
                return new Target(this.nameProvider.resolve(methodDescription), this.returnTypeProvider.resolve(methodDescription), this.argumentProviders, methodDescription);
            }

            @Override
            public InvocationProvider appendArguments(List<ArgumentProvider> argumentProviders) {
                return new Default(this.nameProvider, this.returnTypeProvider, CompoundList.of(this.argumentProviders, argumentProviders));
            }

            @Override
            public InvocationProvider appendArgument(ArgumentProvider argumentProvider) {
                return new Default(this.nameProvider, this.returnTypeProvider, CompoundList.of(this.argumentProviders, argumentProvider));
            }

            @Override
            public InvocationProvider withoutArguments() {
                return new Default(this.nameProvider, this.returnTypeProvider, Collections.<ArgumentProvider>emptyList());
            }

            @Override
            public InvocationProvider withNameProvider(NameProvider nameProvider) {
                return new Default(nameProvider, this.returnTypeProvider, this.argumentProviders);
            }

            @Override
            public InvocationProvider withReturnTypeProvider(ReturnTypeProvider returnTypeProvider) {
                return new Default(this.nameProvider, returnTypeProvider, this.argumentProviders);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                for (ArgumentProvider argumentProvider : this.argumentProviders) {
                    instrumentedType = argumentProvider.prepare(instrumentedType);
                }
                return instrumentedType;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Default)) {
                    return false;
                }
                Default other = (Default)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                NameProvider this$nameProvider = this.nameProvider;
                NameProvider other$nameProvider = other.nameProvider;
                if (this$nameProvider == null ? other$nameProvider != null : !this$nameProvider.equals(other$nameProvider)) {
                    return false;
                }
                ReturnTypeProvider this$returnTypeProvider = this.returnTypeProvider;
                ReturnTypeProvider other$returnTypeProvider = other.returnTypeProvider;
                if (this$returnTypeProvider == null ? other$returnTypeProvider != null : !this$returnTypeProvider.equals(other$returnTypeProvider)) {
                    return false;
                }
                List<ArgumentProvider> this$argumentProviders = this.argumentProviders;
                List<ArgumentProvider> other$argumentProviders = other.argumentProviders;
                return !(this$argumentProviders == null ? other$argumentProviders != null : !((Object)this$argumentProviders).equals(other$argumentProviders));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Default;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                NameProvider $nameProvider = this.nameProvider;
                result = result * 59 + ($nameProvider == null ? 43 : $nameProvider.hashCode());
                ReturnTypeProvider $returnTypeProvider = this.returnTypeProvider;
                result = result * 59 + ($returnTypeProvider == null ? 43 : $returnTypeProvider.hashCode());
                List<ArgumentProvider> $argumentProviders = this.argumentProviders;
                result = result * 59 + ($argumentProviders == null ? 43 : ((Object)$argumentProviders).hashCode());
                return result;
            }

            protected static class Target
            implements scouter.repack.net.bytebuddy.implementation.InvokeDynamic$InvocationProvider$Target {
                private final String internalName;
                private final TypeDescription returnType;
                private final List<ArgumentProvider> argumentProviders;
                private final MethodDescription instrumentedMethod;

                protected Target(String internalName, TypeDescription returnType, List<ArgumentProvider> argumentProviders, MethodDescription instrumentedMethod) {
                    this.internalName = internalName;
                    this.returnType = returnType;
                    this.argumentProviders = argumentProviders;
                    this.instrumentedMethod = instrumentedMethod;
                }

                @Override
                public Target.Resolved resolve(TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                    StackManipulation[] stackManipulation = new StackManipulation[this.argumentProviders.size()];
                    ArrayList<TypeDescription> parameterTypes = new ArrayList<TypeDescription>();
                    int index = 0;
                    for (ArgumentProvider argumentProvider : this.argumentProviders) {
                        ArgumentProvider.Resolved resolved = argumentProvider.resolve(instrumentedType, this.instrumentedMethod, assigner, typing);
                        parameterTypes.addAll(resolved.getLoadedTypes());
                        stackManipulation[index++] = resolved.getLoadInstruction();
                    }
                    return new Target.Resolved.Simple(new StackManipulation.Compound(stackManipulation), this.internalName, this.returnType, parameterTypes);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Target)) {
                        return false;
                    }
                    Target other = (Target)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$internalName = this.internalName;
                    String other$internalName = other.internalName;
                    if (this$internalName == null ? other$internalName != null : !this$internalName.equals(other$internalName)) {
                        return false;
                    }
                    TypeDescription this$returnType = this.returnType;
                    TypeDescription other$returnType = other.returnType;
                    if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
                        return false;
                    }
                    List<ArgumentProvider> this$argumentProviders = this.argumentProviders;
                    List<ArgumentProvider> other$argumentProviders = other.argumentProviders;
                    if (this$argumentProviders == null ? other$argumentProviders != null : !((Object)this$argumentProviders).equals(other$argumentProviders)) {
                        return false;
                    }
                    MethodDescription this$instrumentedMethod = this.instrumentedMethod;
                    MethodDescription other$instrumentedMethod = other.instrumentedMethod;
                    return !(this$instrumentedMethod == null ? other$instrumentedMethod != null : !this$instrumentedMethod.equals(other$instrumentedMethod));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Target;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $internalName = this.internalName;
                    result = result * 59 + ($internalName == null ? 43 : $internalName.hashCode());
                    TypeDescription $returnType = this.returnType;
                    result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
                    List<ArgumentProvider> $argumentProviders = this.argumentProviders;
                    result = result * 59 + ($argumentProviders == null ? 43 : ((Object)$argumentProviders).hashCode());
                    MethodDescription $instrumentedMethod = this.instrumentedMethod;
                    result = result * 59 + ($instrumentedMethod == null ? 43 : $instrumentedMethod.hashCode());
                    return result;
                }
            }
        }

        public static interface ReturnTypeProvider {
            public TypeDescription resolve(MethodDescription var1);

            public static class ForExplicitType
            implements ReturnTypeProvider {
                private final TypeDescription typeDescription;

                protected ForExplicitType(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public TypeDescription resolve(MethodDescription methodDescription) {
                    return this.typeDescription;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForExplicitType)) {
                        return false;
                    }
                    ForExplicitType other = (ForExplicitType)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDescription this$typeDescription = this.typeDescription;
                    TypeDescription other$typeDescription = other.typeDescription;
                    return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForExplicitType;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDescription $typeDescription = this.typeDescription;
                    result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                    return result;
                }
            }

            public static enum ForInterceptedMethod implements ReturnTypeProvider
            {
                INSTANCE;


                @Override
                public TypeDescription resolve(MethodDescription methodDescription) {
                    return methodDescription.getReturnType().asErasure();
                }
            }
        }

        public static interface NameProvider {
            public String resolve(MethodDescription var1);

            public static class ForExplicitName
            implements NameProvider {
                private final String internalName;

                protected ForExplicitName(String internalName) {
                    this.internalName = internalName;
                }

                @Override
                public String resolve(MethodDescription methodDescription) {
                    return this.internalName;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForExplicitName)) {
                        return false;
                    }
                    ForExplicitName other = (ForExplicitName)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$internalName = this.internalName;
                    String other$internalName = other.internalName;
                    return !(this$internalName == null ? other$internalName != null : !this$internalName.equals(other$internalName));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForExplicitName;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $internalName = this.internalName;
                    result = result * 59 + ($internalName == null ? 43 : $internalName.hashCode());
                    return result;
                }
            }

            public static enum ForInterceptedMethod implements NameProvider
            {
                INSTANCE;


                @Override
                public String resolve(MethodDescription methodDescription) {
                    return methodDescription.getInternalName();
                }
            }
        }

        public static interface ArgumentProvider {
            public Resolved resolve(TypeDescription var1, MethodDescription var2, Assigner var3, Assigner.Typing var4);

            public InstrumentedType prepare(InstrumentedType var1);

            public static class ForJavaConstant
            implements ArgumentProvider {
                private final JavaConstant javaConstant;

                protected ForJavaConstant(JavaConstant javaConstant) {
                    this.javaConstant = javaConstant;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(this.javaConstant.asStackManipulation(), this.javaConstant.getType());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForJavaConstant)) {
                        return false;
                    }
                    ForJavaConstant other = (ForJavaConstant)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    JavaConstant this$javaConstant = this.javaConstant;
                    JavaConstant other$javaConstant = other.javaConstant;
                    return !(this$javaConstant == null ? other$javaConstant != null : !this$javaConstant.equals(other$javaConstant));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForJavaConstant;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    JavaConstant $javaConstant = this.javaConstant;
                    result = result * 59 + ($javaConstant == null ? 43 : $javaConstant.hashCode());
                    return result;
                }
            }

            public static class ForNullValue
            implements ArgumentProvider {
                private final TypeDescription typeDescription;

                protected ForNullValue(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple((StackManipulation)NullConstant.INSTANCE, this.typeDescription);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForNullValue)) {
                        return false;
                    }
                    ForNullValue other = (ForNullValue)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDescription this$typeDescription = this.typeDescription;
                    TypeDescription other$typeDescription = other.typeDescription;
                    return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForNullValue;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDescription $typeDescription = this.typeDescription;
                    result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                    return result;
                }
            }

            public static class ForEnumerationValue
            implements ArgumentProvider {
                private final EnumerationDescription enumerationDescription;

                protected ForEnumerationValue(EnumerationDescription enumerationDescription) {
                    this.enumerationDescription = enumerationDescription;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(FieldAccess.forEnumeration(this.enumerationDescription), this.enumerationDescription.getEnumerationType());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForEnumerationValue)) {
                        return false;
                    }
                    ForEnumerationValue other = (ForEnumerationValue)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    EnumerationDescription this$enumerationDescription = this.enumerationDescription;
                    EnumerationDescription other$enumerationDescription = other.enumerationDescription;
                    return !(this$enumerationDescription == null ? other$enumerationDescription != null : !this$enumerationDescription.equals(other$enumerationDescription));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForEnumerationValue;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    EnumerationDescription $enumerationDescription = this.enumerationDescription;
                    result = result * 59 + ($enumerationDescription == null ? 43 : $enumerationDescription.hashCode());
                    return result;
                }
            }

            public static class ForClassConstant
            implements ArgumentProvider {
                private final TypeDescription typeDescription;

                protected ForClassConstant(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(ClassConstant.of(this.typeDescription), TypeDescription.CLASS);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForClassConstant)) {
                        return false;
                    }
                    ForClassConstant other = (ForClassConstant)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDescription this$typeDescription = this.typeDescription;
                    TypeDescription other$typeDescription = other.typeDescription;
                    return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForClassConstant;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDescription $typeDescription = this.typeDescription;
                    result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                    return result;
                }
            }

            public static class ForStringConstant
            implements ArgumentProvider {
                private final String value;

                protected ForStringConstant(String value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple((StackManipulation)new TextConstant(this.value), TypeDescription.STRING);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForStringConstant)) {
                        return false;
                    }
                    ForStringConstant other = (ForStringConstant)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$value = this.value;
                    String other$value = other.value;
                    return !(this$value == null ? other$value != null : !this$value.equals(other$value));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForStringConstant;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $value = this.value;
                    result = result * 59 + ($value == null ? 43 : $value.hashCode());
                    return result;
                }
            }

            public static class ForDoubleConstant
            implements ArgumentProvider {
                private final double value;

                protected ForDoubleConstant(double value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(DoubleConstant.forValue(this.value), new TypeDescription.ForLoadedType(Double.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForDoubleConstant)) {
                        return false;
                    }
                    ForDoubleConstant other = (ForDoubleConstant)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return Double.compare(this.value, other.value) == 0;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForDoubleConstant;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    long $value = Double.doubleToLongBits(this.value);
                    result = result * 59 + (int)($value >>> 32 ^ $value);
                    return result;
                }
            }

            public static class ForFloatConstant
            implements ArgumentProvider {
                private final float value;

                protected ForFloatConstant(float value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(FloatConstant.forValue(this.value), new TypeDescription.ForLoadedType(Float.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForFloatConstant)) {
                        return false;
                    }
                    ForFloatConstant other = (ForFloatConstant)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return Float.compare(this.value, other.value) == 0;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForFloatConstant;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + Float.floatToIntBits(this.value);
                    return result;
                }
            }

            public static class ForLongConstant
            implements ArgumentProvider {
                private final long value;

                protected ForLongConstant(long value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(LongConstant.forValue(this.value), new TypeDescription.ForLoadedType(Long.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForLongConstant)) {
                        return false;
                    }
                    ForLongConstant other = (ForLongConstant)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.value == other.value;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForLongConstant;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    long $value = this.value;
                    result = result * 59 + (int)($value >>> 32 ^ $value);
                    return result;
                }
            }

            public static class ForIntegerConstant
            implements ArgumentProvider {
                private final int value;

                protected ForIntegerConstant(int value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(IntegerConstant.forValue(this.value), new TypeDescription.ForLoadedType(Integer.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForIntegerConstant)) {
                        return false;
                    }
                    ForIntegerConstant other = (ForIntegerConstant)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.value == other.value;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForIntegerConstant;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.value;
                    return result;
                }
            }

            public static class ForCharacterConstant
            implements ArgumentProvider {
                private final char value;

                protected ForCharacterConstant(char value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(IntegerConstant.forValue(this.value), new TypeDescription.ForLoadedType(Character.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForCharacterConstant)) {
                        return false;
                    }
                    ForCharacterConstant other = (ForCharacterConstant)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.value == other.value;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForCharacterConstant;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.value;
                    return result;
                }
            }

            public static class ForShortConstant
            implements ArgumentProvider {
                private final short value;

                protected ForShortConstant(short value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(IntegerConstant.forValue(this.value), new TypeDescription.ForLoadedType(Short.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForShortConstant)) {
                        return false;
                    }
                    ForShortConstant other = (ForShortConstant)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.value == other.value;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForShortConstant;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.value;
                    return result;
                }
            }

            public static class ForByteConstant
            implements ArgumentProvider {
                private final byte value;

                protected ForByteConstant(byte value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(IntegerConstant.forValue(this.value), new TypeDescription.ForLoadedType(Byte.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForByteConstant)) {
                        return false;
                    }
                    ForByteConstant other = (ForByteConstant)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.value == other.value;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForByteConstant;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.value;
                    return result;
                }
            }

            public static class ForBooleanConstant
            implements ArgumentProvider {
                private final boolean value;

                protected ForBooleanConstant(boolean value) {
                    this.value = value;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(IntegerConstant.forValue(this.value), new TypeDescription.ForLoadedType(Boolean.TYPE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForBooleanConstant)) {
                        return false;
                    }
                    ForBooleanConstant other = (ForBooleanConstant)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.value == other.value;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForBooleanConstant;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + (this.value ? 79 : 97);
                    return result;
                }
            }

            public static class ForMethodParameter
            implements ArgumentProvider {
                protected final int index;

                protected ForMethodParameter(int index) {
                    this.index = index;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    ParameterList<?> parameters = instrumentedMethod.getParameters();
                    if (this.index >= parameters.size()) {
                        throw new IllegalStateException("No parameter " + this.index + " for " + instrumentedMethod);
                    }
                    return this.doResolve(MethodVariableAccess.load((ParameterDescription)parameters.get(this.index)), ((ParameterDescription)parameters.get(this.index)).getType(), assigner, typing);
                }

                protected Resolved doResolve(StackManipulation access, TypeDescription.Generic type, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(access, type.asErasure());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForMethodParameter)) {
                        return false;
                    }
                    ForMethodParameter other = (ForMethodParameter)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.index == other.index;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForMethodParameter;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.index;
                    return result;
                }

                protected static class WithExplicitType
                extends ForMethodParameter {
                    private final TypeDescription typeDescription;

                    protected WithExplicitType(int index, TypeDescription typeDescription) {
                        super(index);
                        this.typeDescription = typeDescription;
                    }

                    @Override
                    protected Resolved doResolve(StackManipulation access, TypeDescription.Generic type, Assigner assigner, Assigner.Typing typing) {
                        StackManipulation stackManipulation = assigner.assign(type, this.typeDescription.asGenericType(), typing);
                        if (!stackManipulation.isValid()) {
                            throw new IllegalStateException("Cannot assign " + type + " to " + this.typeDescription);
                        }
                        return new Resolved.Simple((StackManipulation)new StackManipulation.Compound(access, stackManipulation), this.typeDescription);
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof WithExplicitType)) {
                            return false;
                        }
                        WithExplicitType other = (WithExplicitType)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        if (!super.equals(o)) {
                            return false;
                        }
                        TypeDescription this$typeDescription = this.typeDescription;
                        TypeDescription other$typeDescription = other.typeDescription;
                        return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                    }

                    @Override
                    protected boolean canEqual(Object other) {
                        return other instanceof WithExplicitType;
                    }

                    @Override
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        result = result * 59 + super.hashCode();
                        TypeDescription $typeDescription = this.typeDescription;
                        result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                        return result;
                    }
                }
            }

            public static class ForField
            implements ArgumentProvider {
                protected final String fieldName;
                protected final FieldLocator.Factory fieldLocatorFactory;

                protected ForField(String fieldName, FieldLocator.Factory fieldLocatorFactory) {
                    this.fieldName = fieldName;
                    this.fieldLocatorFactory = fieldLocatorFactory;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(instrumentedType).locate(this.fieldName);
                    if (!resolution.isResolved()) {
                        throw new IllegalStateException("Cannot find a field " + this.fieldName + " for " + instrumentedType);
                    }
                    if (!resolution.getField().isStatic() && instrumentedMethod.isStatic()) {
                        throw new IllegalStateException("Cannot access non-static " + resolution.getField() + " from " + instrumentedMethod);
                    }
                    return this.doResolve(new StackManipulation.Compound(resolution.getField().isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(resolution.getField()).read()), resolution.getField().getType(), assigner, typing);
                }

                protected Resolved doResolve(StackManipulation access, TypeDescription.Generic type, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(access, type.asErasure());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForField)) {
                        return false;
                    }
                    ForField other = (ForField)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$fieldName = this.fieldName;
                    String other$fieldName = other.fieldName;
                    if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                        return false;
                    }
                    FieldLocator.Factory this$fieldLocatorFactory = this.fieldLocatorFactory;
                    FieldLocator.Factory other$fieldLocatorFactory = other.fieldLocatorFactory;
                    return !(this$fieldLocatorFactory == null ? other$fieldLocatorFactory != null : !this$fieldLocatorFactory.equals(other$fieldLocatorFactory));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForField;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $fieldName = this.fieldName;
                    result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
                    FieldLocator.Factory $fieldLocatorFactory = this.fieldLocatorFactory;
                    result = result * 59 + ($fieldLocatorFactory == null ? 43 : $fieldLocatorFactory.hashCode());
                    return result;
                }

                protected static class WithExplicitType
                extends ForField {
                    private final TypeDescription typeDescription;

                    protected WithExplicitType(String fieldName, FieldLocator.Factory fieldLocatorFactory, TypeDescription typeDescription) {
                        super(fieldName, fieldLocatorFactory);
                        this.typeDescription = typeDescription;
                    }

                    @Override
                    protected Resolved doResolve(StackManipulation access, TypeDescription.Generic typeDescription, Assigner assigner, Assigner.Typing typing) {
                        StackManipulation stackManipulation = assigner.assign(typeDescription, this.typeDescription.asGenericType(), typing);
                        if (!stackManipulation.isValid()) {
                            throw new IllegalStateException("Cannot assign " + typeDescription + " to " + this.typeDescription);
                        }
                        return new Resolved.Simple((StackManipulation)new StackManipulation.Compound(access, stackManipulation), this.typeDescription);
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof WithExplicitType)) {
                            return false;
                        }
                        WithExplicitType other = (WithExplicitType)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        if (!super.equals(o)) {
                            return false;
                        }
                        TypeDescription this$typeDescription = this.typeDescription;
                        TypeDescription other$typeDescription = other.typeDescription;
                        return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                    }

                    @Override
                    protected boolean canEqual(Object other) {
                        return other instanceof WithExplicitType;
                    }

                    @Override
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        result = result * 59 + super.hashCode();
                        TypeDescription $typeDescription = this.typeDescription;
                        result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                        return result;
                    }
                }
            }

            public static class ForInstance
            implements ArgumentProvider {
                private static final String FIELD_PREFIX = "invokeDynamic";
                private final Object value;
                private final TypeDescription fieldType;
                private final String name;

                protected ForInstance(Object value, TypeDescription fieldType) {
                    this.value = value;
                    this.fieldType = fieldType;
                    this.name = String.format("%s$%s", FIELD_PREFIX, RandomString.make());
                }

                protected static ArgumentProvider of(Object value) {
                    return new ForInstance(value, new TypeDescription.ForLoadedType(value.getClass()));
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    FieldDescription fieldDescription = (FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly();
                    StackManipulation stackManipulation = assigner.assign(fieldDescription.getType(), this.fieldType.asGenericType(), typing);
                    if (!stackManipulation.isValid()) {
                        throw new IllegalStateException("Cannot assign " + fieldDescription + " to " + this.fieldType);
                    }
                    return new Resolved.Simple((StackManipulation)new StackManipulation.Compound(FieldAccess.forField(fieldDescription).read(), stackManipulation), fieldDescription.getType().asErasure());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType.withField(new FieldDescription.Token(this.name, 4105, this.fieldType.asGenericType())).withInitializer(new LoadedTypeInitializer.ForStaticField(this.name, this.value));
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForInstance)) {
                        return false;
                    }
                    ForInstance other = (ForInstance)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Object this$value = this.value;
                    Object other$value = other.value;
                    if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                        return false;
                    }
                    TypeDescription this$fieldType = this.fieldType;
                    TypeDescription other$fieldType = other.fieldType;
                    return !(this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForInstance;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Object $value = this.value;
                    result = result * 59 + ($value == null ? 43 : $value.hashCode());
                    TypeDescription $fieldType = this.fieldType;
                    result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
                    return result;
                }
            }

            public static class ForThisInstance
            implements ArgumentProvider {
                private final TypeDescription typeDescription;

                protected ForThisInstance(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    if (instrumentedMethod.isStatic()) {
                        throw new IllegalStateException("Cannot get this instance from static method: " + instrumentedMethod);
                    }
                    if (!instrumentedType.isAssignableTo(this.typeDescription)) {
                        throw new IllegalStateException(instrumentedType + " is not assignable to " + instrumentedType);
                    }
                    return new Resolved.Simple(MethodVariableAccess.loadThis(), this.typeDescription);
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForThisInstance)) {
                        return false;
                    }
                    ForThisInstance other = (ForThisInstance)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDescription this$typeDescription = this.typeDescription;
                    TypeDescription other$typeDescription = other.typeDescription;
                    return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForThisInstance;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDescription $typeDescription = this.typeDescription;
                    result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                    return result;
                }
            }

            public static interface Resolved {
                public StackManipulation getLoadInstruction();

                public List<TypeDescription> getLoadedTypes();

                public static class Simple
                implements Resolved {
                    private final StackManipulation stackManipulation;
                    private final List<TypeDescription> loadedTypes;

                    public Simple(StackManipulation stackManipulation, TypeDescription loadedType) {
                        this(stackManipulation, Collections.singletonList(loadedType));
                    }

                    public Simple(StackManipulation stackManipulation, List<TypeDescription> loadedTypes) {
                        this.stackManipulation = stackManipulation;
                        this.loadedTypes = loadedTypes;
                    }

                    @Override
                    public StackManipulation getLoadInstruction() {
                        return this.stackManipulation;
                    }

                    @Override
                    public List<TypeDescription> getLoadedTypes() {
                        return this.loadedTypes;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Simple)) {
                            return false;
                        }
                        Simple other = (Simple)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        StackManipulation this$stackManipulation = this.stackManipulation;
                        StackManipulation other$stackManipulation = other.stackManipulation;
                        if (this$stackManipulation == null ? other$stackManipulation != null : !this$stackManipulation.equals(other$stackManipulation)) {
                            return false;
                        }
                        List<TypeDescription> this$loadedTypes = this.getLoadedTypes();
                        List<TypeDescription> other$loadedTypes = other.getLoadedTypes();
                        return !(this$loadedTypes == null ? other$loadedTypes != null : !((Object)this$loadedTypes).equals(other$loadedTypes));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Simple;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        StackManipulation $stackManipulation = this.stackManipulation;
                        result = result * 59 + ($stackManipulation == null ? 43 : $stackManipulation.hashCode());
                        List<TypeDescription> $loadedTypes = this.getLoadedTypes();
                        result = result * 59 + ($loadedTypes == null ? 43 : ((Object)$loadedTypes).hashCode());
                        return result;
                    }
                }
            }

            public static enum ConstantPoolWrapper {
                BOOLEAN((Class)Boolean.TYPE, (Class)Boolean.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(IntegerConstant.forValue((Boolean)value));
                    }
                }
                ,
                BYTE((Class)Byte.TYPE, (Class)Byte.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(IntegerConstant.forValue(((Byte)value).byteValue()));
                    }
                }
                ,
                SHORT((Class)Short.TYPE, (Class)Short.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(IntegerConstant.forValue(((Short)value).shortValue()));
                    }
                }
                ,
                CHARACTER((Class)Character.TYPE, (Class)Character.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(IntegerConstant.forValue(((Character)value).charValue()));
                    }
                }
                ,
                INTEGER((Class)Integer.TYPE, (Class)Integer.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(IntegerConstant.forValue((Integer)value));
                    }
                }
                ,
                LONG((Class)Long.TYPE, (Class)Long.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(LongConstant.forValue((Long)value));
                    }
                }
                ,
                FLOAT((Class)Float.TYPE, (Class)Float.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(FloatConstant.forValue(((Float)value).floatValue()));
                    }
                }
                ,
                DOUBLE((Class)Double.TYPE, (Class)Double.class){

                    @Override
                    protected ArgumentProvider make(Object value) {
                        return new WrappingArgumentProvider(DoubleConstant.forValue((Double)value));
                    }
                };

                private final TypeDescription primitiveType;
                private final TypeDescription wrapperType;

                private ConstantPoolWrapper(Class<?> primitiveType, Class<?> wrapperType) {
                    this.primitiveType = new TypeDescription.ForLoadedType(primitiveType);
                    this.wrapperType = new TypeDescription.ForLoadedType(wrapperType);
                }

                public static ArgumentProvider of(Object value) {
                    if (value instanceof Boolean) {
                        return BOOLEAN.make(value);
                    }
                    if (value instanceof Byte) {
                        return BYTE.make(value);
                    }
                    if (value instanceof Short) {
                        return SHORT.make(value);
                    }
                    if (value instanceof Character) {
                        return CHARACTER.make(value);
                    }
                    if (value instanceof Integer) {
                        return INTEGER.make(value);
                    }
                    if (value instanceof Long) {
                        return LONG.make(value);
                    }
                    if (value instanceof Float) {
                        return FLOAT.make(value);
                    }
                    if (value instanceof Double) {
                        return DOUBLE.make(value);
                    }
                    if (value instanceof String) {
                        return new ForStringConstant((String)value);
                    }
                    if (value instanceof Class) {
                        return new ForClassConstant(new TypeDescription.ForLoadedType((Class)value));
                    }
                    if (value instanceof Enum) {
                        return new ForEnumerationValue(new EnumerationDescription.ForLoadedEnumeration((Enum)value));
                    }
                    if (JavaType.METHOD_HANDLE.getTypeStub().isInstance(value)) {
                        return new ForJavaConstant(JavaConstant.MethodHandle.ofLoaded(value));
                    }
                    if (JavaType.METHOD_TYPE.getTypeStub().isInstance(value)) {
                        return new ForJavaConstant(JavaConstant.MethodType.ofLoaded(value));
                    }
                    return ForInstance.of(value);
                }

                protected abstract ArgumentProvider make(Object var1);

                protected class WrappingArgumentProvider
                implements ArgumentProvider {
                    private final StackManipulation stackManipulation;

                    protected WrappingArgumentProvider(StackManipulation stackManipulation) {
                        this.stackManipulation = stackManipulation;
                    }

                    @Override
                    public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                        return new Resolved.Simple((StackManipulation)new StackManipulation.Compound(this.stackManipulation, assigner.assign(ConstantPoolWrapper.this.primitiveType.asGenericType(), ConstantPoolWrapper.this.wrapperType.asGenericType(), typing)), ConstantPoolWrapper.this.wrapperType);
                    }

                    @Override
                    public InstrumentedType prepare(InstrumentedType instrumentedType) {
                        return instrumentedType;
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && ConstantPoolWrapper.this.equals((Object)((WrappingArgumentProvider)other).getOuter()) && this.stackManipulation.equals(((WrappingArgumentProvider)other).stackManipulation);
                    }

                    private ConstantPoolWrapper getOuter() {
                        return ConstantPoolWrapper.this;
                    }

                    public int hashCode() {
                        return this.stackManipulation.hashCode() + 31 * ConstantPoolWrapper.this.hashCode();
                    }
                }
            }

            public static enum ForInterceptedMethodParameters implements ArgumentProvider
            {
                INSTANCE;


                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple((StackManipulation)MethodVariableAccess.allArgumentsOf(instrumentedMethod), instrumentedMethod.getParameters().asTypeList().asErasures());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }
            }

            public static enum ForInterceptedMethodInstanceAndParameters implements ArgumentProvider
            {
                INSTANCE;


                @Override
                public Resolved resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return new Resolved.Simple(MethodVariableAccess.allArgumentsOf(instrumentedMethod).prependThisReference(), instrumentedMethod.isStatic() ? instrumentedMethod.getParameters().asTypeList().asErasures() : CompoundList.of(instrumentedMethod.getDeclaringType().asErasure(), instrumentedMethod.getParameters().asTypeList().asErasures()));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }
            }
        }

        public static interface Target {
            public Resolved resolve(TypeDescription var1, Assigner var2, Assigner.Typing var3);

            public static class ForMethodDescription
            implements Target,
            Resolved {
                private final MethodDescription.InDefinedShape methodDescription;

                protected ForMethodDescription(MethodDescription.InDefinedShape methodDescription) {
                    this.methodDescription = methodDescription;
                }

                @Override
                public Resolved resolve(TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                    return this;
                }

                @Override
                public String getInternalName() {
                    return this.methodDescription.getInternalName();
                }

                @Override
                public TypeDescription getReturnType() {
                    return this.methodDescription.getReturnType().asErasure();
                }

                @Override
                public StackManipulation getStackManipulation() {
                    return MethodVariableAccess.allArgumentsOf(this.methodDescription).prependThisReference();
                }

                @Override
                public List<TypeDescription> getParameterTypes() {
                    return this.methodDescription.isStatic() ? this.methodDescription.getParameters().asTypeList().asErasures() : CompoundList.of(this.methodDescription.getDeclaringType().asErasure(), this.methodDescription.getParameters().asTypeList().asErasures());
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForMethodDescription)) {
                        return false;
                    }
                    ForMethodDescription other = (ForMethodDescription)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    MethodDescription.InDefinedShape this$methodDescription = this.methodDescription;
                    MethodDescription.InDefinedShape other$methodDescription = other.methodDescription;
                    return !(this$methodDescription == null ? other$methodDescription != null : !this$methodDescription.equals(other$methodDescription));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForMethodDescription;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    MethodDescription.InDefinedShape $methodDescription = this.methodDescription;
                    result = result * 59 + ($methodDescription == null ? 43 : $methodDescription.hashCode());
                    return result;
                }
            }

            public static interface Resolved {
                public StackManipulation getStackManipulation();

                public TypeDescription getReturnType();

                public String getInternalName();

                public List<TypeDescription> getParameterTypes();

                public static class Simple
                implements Resolved {
                    private final StackManipulation stackManipulation;
                    private final String internalName;
                    private final TypeDescription returnType;
                    private final List<TypeDescription> parameterTypes;

                    public Simple(StackManipulation stackManipulation, String internalName, TypeDescription returnType, List<TypeDescription> parameterTypes) {
                        this.stackManipulation = stackManipulation;
                        this.internalName = internalName;
                        this.returnType = returnType;
                        this.parameterTypes = parameterTypes;
                    }

                    @Override
                    public StackManipulation getStackManipulation() {
                        return this.stackManipulation;
                    }

                    @Override
                    public TypeDescription getReturnType() {
                        return this.returnType;
                    }

                    @Override
                    public String getInternalName() {
                        return this.internalName;
                    }

                    @Override
                    public List<TypeDescription> getParameterTypes() {
                        return this.parameterTypes;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Simple)) {
                            return false;
                        }
                        Simple other = (Simple)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        StackManipulation this$stackManipulation = this.getStackManipulation();
                        StackManipulation other$stackManipulation = other.getStackManipulation();
                        if (this$stackManipulation == null ? other$stackManipulation != null : !this$stackManipulation.equals(other$stackManipulation)) {
                            return false;
                        }
                        String this$internalName = this.getInternalName();
                        String other$internalName = other.getInternalName();
                        if (this$internalName == null ? other$internalName != null : !this$internalName.equals(other$internalName)) {
                            return false;
                        }
                        TypeDescription this$returnType = this.getReturnType();
                        TypeDescription other$returnType = other.getReturnType();
                        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
                            return false;
                        }
                        List<TypeDescription> this$parameterTypes = this.getParameterTypes();
                        List<TypeDescription> other$parameterTypes = other.getParameterTypes();
                        return !(this$parameterTypes == null ? other$parameterTypes != null : !((Object)this$parameterTypes).equals(other$parameterTypes));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Simple;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        StackManipulation $stackManipulation = this.getStackManipulation();
                        result = result * 59 + ($stackManipulation == null ? 43 : $stackManipulation.hashCode());
                        String $internalName = this.getInternalName();
                        result = result * 59 + ($internalName == null ? 43 : $internalName.hashCode());
                        TypeDescription $returnType = this.getReturnType();
                        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
                        List<TypeDescription> $parameterTypes = this.getParameterTypes();
                        result = result * 59 + ($parameterTypes == null ? 43 : ((Object)$parameterTypes).hashCode());
                        return result;
                    }
                }
            }
        }
    }
}

