/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.value;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.value.SummaryValue;
import scouter.lang.value.Value;

public class LongSummary
extends SummaryValue
implements Value {
    public long sum;
    public int count;
    public long min;
    public long max;

    @Override
    public byte getValueType() {
        return 46;
    }

    @Override
    public void write(DataOutputX out) throws IOException {
        out.writeLong(this.sum);
        out.writeInt(this.count);
        out.writeLong(this.min);
        out.writeLong(this.max);
    }

    @Override
    public Value read(DataInputX in) throws IOException {
        this.sum = in.readLong();
        this.count = in.readInt();
        this.min = in.readLong();
        this.max = in.readLong();
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[sum=").append(this.sum);
        sb.append(",count=").append(this.count);
        sb.append(",min=").append(this.min);
        sb.append(",max=").append(this.max);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object toJavaObject() {
        return this;
    }

    @Override
    public void addcount() {
        ++this.count;
    }

    @Override
    public SummaryValue add(Number value) {
        if (value == null) {
            return this;
        }
        if (this.count == 0) {
            this.sum = value.longValue();
            this.count = 1;
            this.max = value.longValue();
            this.min = value.longValue();
        } else {
            this.sum = (long)((double)this.sum + value.doubleValue());
            ++this.count;
            this.max = Math.max(this.max, value.longValue());
            this.min = Math.min(this.min, value.longValue());
        }
        return this;
    }

    @Override
    public SummaryValue add(SummaryValue other) {
        if (other == null || other.getCount() == 0) {
            return this;
        }
        this.count += other.getCount();
        this.sum += other.longSum();
        this.min = Math.min(this.min, other.longMin());
        this.max = Math.max(this.max, other.longMax());
        return this;
    }

    @Override
    public long longSum() {
        return this.sum;
    }

    @Override
    public long longMin() {
        return this.min;
    }

    @Override
    public long longMax() {
        return this.max;
    }

    @Override
    public long longAvg() {
        return this.count == 0 ? 0L : this.sum / (long)this.count;
    }

    @Override
    public double doubleSum() {
        return this.sum;
    }

    @Override
    public double doubleMin() {
        return this.min;
    }

    @Override
    public double doubleMax() {
        return this.max;
    }

    @Override
    public double doubleAvg() {
        return this.count == 0 ? 0.0 : (double)(this.sum / (long)this.count);
    }

    @Override
    public int getCount() {
        return this.count;
    }
}

