/*
 * Decompiled with CFR 0.152.
 */
package scouter.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import scouter.lang.DeltaType;
import scouter.lang.conf.ConfigDesc;
import scouter.lang.conf.ConfigValueType;
import scouter.lang.conf.ConfigValueUtil;
import scouter.lang.conf.ValueType;
import scouter.lang.conf.ValueTypeDesc;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.server.ConfObserver;
import scouter.server.Logger;
import scouter.server.ScouterTgMtConfig;
import scouter.server.http.model.CounterProtocol;
import scouter.server.support.telegraf.TgConfig;
import scouter.server.support.telegraf.TgmConfig;
import scouter.util.FileUtil;
import scouter.util.StringEnumer;
import scouter.util.StringKeyLinkedMap;
import scouter.util.StringLinkedSet;
import scouter.util.StringSet;
import scouter.util.StringUtil;
import scouter.util.SysJMX;
import scouter.util.SystemUtil;
import scouter.util.ThreadUtil;

public class Configure
extends Thread {
    private static Configure instance = null;
    public static final String CONF_DIR = "./conf/";
    private static JAXBContext jaxbContext;
    private static Marshaller marshaller;
    private static Unmarshaller unmarshaller;
    private static final String TELEGRAF_INPUT_MEASUREMENT_PREFIX = "input_telegraf_$";
    private static final int TELEGRAF_INPUT_MEASUREMENT_PREFIX_LENGTH;
    private static final String TELEGRAF_INPUT_MEASUREMENT_ENABLED_POSTFIX = "_enabled";
    private static final String TELEGRAF_INPUT_MEASUREMENT_DEBUG_ENABLED_POSTFIX = "_debug_enabled";
    private static final String TELEGRAF_INPUT_MEASUREMENT_TAG_FILTER_POSTFIX = "_tag_filter";
    private static final String TELEGRAF_INPUT_MEASUREMENT_COUNTER_MAPPINGS_POSTFIX = "_counter_mappings";
    private static final String TELEGRAF_INPUT_MEASUREMENT_OBJ_FAMILY_BASE_POSTFIX = "_objFamily_base";
    private static final String TELEGRAF_INPUT_MEASUREMENT_OBJ_FAMILY_APPEND_TAGS_POSTFIX = "_objFamily_append_tags";
    private static final String TELEGRAF_INPUT_MEASUREMENT_OBJ_TYPE_BASE_POSTFIX = "_objType_base";
    private static final String TELEGRAF_INPUT_MEASUREMENT_OBJ_TYPE_PREPEND_TAGS_POSTFIX = "_objType_prepend_tags";
    private static final String TELEGRAF_INPUT_MEASUREMENT_OBJ_TYPE_APPEND_TAGS_POSTFIX = "_objType_append_tags";
    private static final String TELEGRAF_INPUT_MEASUREMENT_OBJ_TYPE_ICON_POSTFIX = "_objType_icon";
    private static final String TELEGRAF_INPUT_MEASUREMENT_OBJ_NAME_BASE_POSTFIX = "_objName_base";
    private static final String TELEGRAF_INPUT_MEASUREMENT_OBJ_NAME_APPEND_TAGS = "_objName_append_tags";
    private static final String TELEGRAF_INPUT_MEASUREMENT_HOST_TAG_POSTFIX = "_host_tag";
    private static final String TELEGRAF_INPUT_MEASUREMENT_HOST_MAPPINGS_POSTFIX = "_host_mappings";
    public Map<String, ScouterTgMtConfig> telegrafInputConfigMap = new ConcurrentHashMap<String, ScouterTgMtConfig>();
    @Deprecated
    public Map<String, ScouterTgMtConfig> telegrafInputConfigMapDeprecated = new ConcurrentHashMap<String, ScouterTgMtConfig>();
    public TgConfig telegrafOriginalConfig = new TgConfig();
    @ConfigDesc(value="Server ID")
    public String server_id = SysJMX.getHostName();
    @ConfigDesc(value="Logging TCP connection related event")
    public boolean log_tcp_action_enabled = false;
    @ConfigDesc(value="Logging incoming MultiPacket")
    public boolean log_udp_multipacket = false;
    @ConfigDesc(value="Logging expired MultiPacket")
    public boolean log_expired_multipacket = true;
    @ConfigDesc(value="Logging all incoming packs")
    public boolean log_udp_packet = false;
    @ConfigDesc(value="Logging incoming CounterPack")
    public boolean log_udp_counter = false;
    @ConfigDesc(value="Logging incoming PerfInteractionCounterPack")
    public boolean log_udp_interaction_counter = false;
    @ConfigDesc(value="Logging incoming XLogPack")
    public boolean log_udp_xlog = false;
    @ConfigDesc(value="Logging incoming ProfilePack")
    public boolean log_udp_profile = false;
    @ConfigDesc(value="Logging incoming TextPack")
    public boolean log_udp_text = false;
    @ConfigDesc(value="Logging incoming AlertPack")
    public boolean log_udp_alert = false;
    @ConfigDesc(value="Logging incoming ObjectPack")
    public boolean log_udp_object = false;
    @ConfigDesc(value="Logging incoming StatusPack")
    public boolean log_udp_status = false;
    @ConfigDesc(value="Logging incoming StackPack")
    public boolean log_udp_stack = false;
    @ConfigDesc(value="Logging incoming SummaryPack")
    public boolean log_udp_summary = false;
    @ConfigDesc(value="Logging incoming BatchPack")
    public boolean log_udp_batch = false;
    @ConfigDesc(value="Logging all request handlers in starting")
    public boolean log_service_handler_list = false;
    @ConfigDesc(value="Logging incoming SpanPack")
    public boolean log_udp_span = false;
    @ConfigDesc(value="Logging when index traversal is too heavy.")
    public int log_index_traversal_warning_count = 100;
    @ConfigDesc(value="Retaining log according to date")
    public boolean log_rotation_enabled = true;
    @ConfigDesc(value="Keeping period of log")
    public int log_keep_days = 31;
    @ConfigDesc(value="Logging sql failed to parse")
    public boolean log_sql_parsing_fail_enabled = false;
    @ConfigDesc(value="")
    public boolean _trace = false;
    @ConfigDesc(value="UDP Host")
    public String net_udp_listen_ip = "0.0.0.0";
    @ConfigDesc(value="UDP Port")
    public int net_udp_listen_port = 6100;
    @ConfigDesc(value="TCP Host")
    public String net_tcp_listen_ip = "0.0.0.0";
    @ConfigDesc(value="TCP Port")
    public int net_tcp_listen_port = 6100;
    @ConfigDesc(value="Client Socket Timeout(ms)")
    public int net_tcp_client_so_timeout_ms = 8000;
    @ConfigDesc(value="Agent Socket Timeout(ms)")
    public int net_tcp_agent_so_timeout_ms = 60000;
    @ConfigDesc(value="Transfer period(ms) of KEEP_ALIVE")
    public int net_tcp_agent_keepalive_interval_ms = 5000;
    @ConfigDesc(value="Waiting time(ms) for agent session")
    public int net_tcp_get_agent_connection_wait_ms = 1000;
    @ConfigDesc(value="UDP Packet Buffer Size")
    public int net_udp_packet_buffer_size = 65535;
    @ConfigDesc(value="UDP Receiver Buffer Size")
    public int net_udp_so_rcvbuf_size = 0x400000;
    @ConfigDesc(value="")
    public int _net_udp_worker_thread_count = 3;
    @ConfigDesc(value="TCP Thread Pool Size")
    public int net_tcp_service_pool_size = 100;
    @ConfigDesc(value="Activating Http Server")
    public boolean net_http_server_enabled = false;
    @ConfigDesc(value="Http Port")
    public int net_http_port = 6180;
    @ConfigDesc(value="user extension web root")
    public String net_http_extweb_dir = "./extweb";
    @ConfigDesc(value="Activating Scouter API")
    public boolean net_http_api_enabled = false;
    @ConfigDesc(value="Enable a swagger for HTTP API.")
    public boolean net_http_api_swagger_enabled = false;
    @ConfigDesc(value="Swagger option of host's ip or domain to call APIs.")
    public String net_http_api_swagger_host_ip = "";
    @ConfigDesc(value="API CORS support for Access-Control-Allow-Origin")
    public String net_http_api_cors_allow_origin = "*";
    @ConfigDesc(value="Access-Control-Allow-Credentials")
    public String net_http_api_cors_allow_credentials = "true";
    @ConfigDesc(value="size of webapp connection pool to collector")
    public int net_webapp_tcp_client_pool_size = 12;
    @ConfigDesc(value="timeout of web app connection pool to collector(It depends on net_tcp_client_so_timeout_ms)")
    public int net_webapp_tcp_client_pool_timeout = this.net_tcp_client_so_timeout_ms;
    @ConfigDesc(value="Enable api access control by client ip")
    public boolean net_http_api_auth_ip_enabled = false;
    @ConfigDesc(value="If get api caller's ip from http header.")
    public String net_http_api_auth_ip_header_key;
    @ConfigDesc(value="Enable api access control by JSESSIONID of Cookie")
    public boolean net_http_api_auth_session_enabled = false;
    @ConfigDesc(value="api http session timeout")
    public int net_http_api_session_timeout = 86400;
    @ConfigDesc(value="Enable api access control by Bearer token(of Authorization http header) - get access token from /user/loginGetToken.")
    public boolean net_http_api_auth_bearer_token_enabled = false;
    @ConfigDesc(value="Enable gzip response on api call")
    public boolean net_http_api_gzip_enabled = true;
    @ConfigDesc(value="api access allow ip addresses")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String net_http_api_allow_ips = "localhost,127.0.0.1,0:0:0:0:0:0:0:1,::1";
    @ConfigDesc(value="Store directory of database")
    public String db_dir = "./database";
    @ConfigDesc(value="Path to log directory")
    public String log_dir = "./logs";
    @ConfigDesc(value="Path to plugin directory")
    public String plugin_dir = "./plugin";
    @ConfigDesc(value="Path to client related directory")
    public String client_dir = "./client";
    @ConfigDesc(value="temp dir")
    public String temp_dir = "./tempdata";
    @ConfigDesc(value="Waiting time(ms) until stopped heartbeat of object is determined to be inactive")
    public int object_deadtime_ms = 8000;
    @ConfigDesc(value="inactive object warning level. default 0.(0:info, 1:warn, 2:error, 3:fatal)")
    public int object_inactive_alert_level = 0;
    @ConfigDesc(value="Zipkin Waiting time(ms) until stopped heartbeat of object is determined to be inactive")
    public int object_zipkin_deadtime_ms = 180000;
    @ConfigDesc(value="Activating XLog data in zip file")
    public boolean compress_xlog_enabled = false;
    @ConfigDesc(value="Activating profile data in zip file")
    public boolean compress_profile_enabled = false;
    @ConfigDesc(value="")
    public int _compress_write_buffer_block_count = 3;
    @ConfigDesc(value="")
    public int _compress_read_cache_block_count = 3;
    @ConfigDesc(value="")
    public long _compress_read_cache_expired_ms = 60000L;
    @ConfigDesc(value="")
    public int _compress_dailycount_header_cache_size = 3;
    @ConfigDesc(value="")
    public int _compress_write_thread = 2;
    @ConfigDesc(value="")
    public boolean _auto_5m_sampling = true;
    @ConfigDesc(value="Activating automatic deletion function in the database")
    public boolean mgr_purge_enabled = true;
    @ConfigDesc(value="Condition of disk usage for automatic deletion. if lack, delete profile data first exclude today data.")
    public int mgr_purge_disk_usage_pct = 80;
    @ConfigDesc(value="Retaining date for automatic deletion. delete profile data first.")
    public int mgr_purge_profile_keep_days;
    @Deprecated
    @ConfigDesc(value="Deprecated : use mgr_purge_profile_keep_days")
    public int mgr_purge_keep_days = this.mgr_purge_profile_keep_days = 10;
    @ConfigDesc(value="Retaining date for automatic deletion.")
    public int mgr_purge_xlog_keep_days;
    @Deprecated
    @ConfigDesc(value="Deprecated : use mgr_purge_xlog_keep_days")
    public int mgr_purge_xlog_without_profile_keep_days = this.mgr_purge_xlog_keep_days = 30;
    @ConfigDesc(value="Retaining date for automatic deletion")
    public int mgr_purge_counter_keep_days = 70;
    @ConfigDesc(value="Ignored log ID set")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public StringSet mgr_log_ignore_ids = new StringSet();
    @ConfigDesc(value="true for daily dictionary mode about service name. default value is false that means it's permanent.")
    public boolean mgr_text_db_daily_service_enabled = false;
    @ConfigDesc(value="true for daily dictionary mode about api name. default value is false that means it's permanent.")
    public boolean mgr_text_db_daily_api_enabled = false;
    @ConfigDesc(value="true for daily dictionary mode about user agent. default value is false that means it's permanent.")
    public boolean mgr_text_db_daily_ua_enabled = false;
    @ConfigDesc(value="change default memory size of hash index.(MB)[warn] modified this will break the database files.\nbackup old database files before change values.(restart required)")
    public int _mgr_text_db_index_default_mb = 1;
    @ConfigDesc(value="change memory size of hash index for service text.(MB)[warn] modified this will break the database files.\nbackup old database files before change values.(restart required)")
    public int _mgr_text_db_index_service_mb = 1;
    @ConfigDesc(value="change memory size of hash index for apicall text.(MB)[warn] modified this will break the database files.\nbackup old database files before change values.(restart required)")
    public int _mgr_text_db_index_api_mb = 1;
    @ConfigDesc(value="change memory size of hash index for user agent text.(MB)[warn] modified this will break the database files.\nbackup old database files before change values.(restart required)")
    public int _mgr_text_db_index_ua_mb = 1;
    @ConfigDesc(value="change memory size of hash index for login text.(MB)[warn] modified this will break the database files.\nbackup old database files before change values.(restart required)")
    public int _mgr_text_db_index_login_mb = 1;
    @ConfigDesc(value="change memory size of hash index for desc text.(MB)[warn] modified this will break the database files.\nbackup old database files before change values.(restart required)")
    public int _mgr_text_db_index_desc_mb = 1;
    @ConfigDesc(value="change memory size of hash index for hashed message text.(MB)[warn] modified this will break the database files.\nbackup old database files before change values.(restart required)")
    public int _mgr_text_db_index_hmsg_mb = 1;
    @ConfigDesc(value="change memory size of hash index for daily text db.(MB)[warn] modified this will break the database files.\nbackup old database files before change values.(restart required)")
    public int _mgr_text_db_daily_index_mb = 1;
    @ConfigDesc(value="change default memory size of key value store index.(MB)[warn] modified this will break the database files.\nbackup old database files before change values.(restart required)")
    public int _mgr_kv_store_index_default_mb = 8;
    @ConfigDesc(value="name of 3rd party ui")
    public String ext_link_name = "scouter-paper";
    @ConfigDesc(value="outgoing link pattern for a 3rd party UI.(client restart required)\nContext menu in any chart shows the menu 'Open with 3rd-party UI.'\n* variable patterns : \n   $[objHashes] : comma separated objHash values\n   $[objType] : object type\n   $[from] : start time in chart by millis\n   $[to] : end time in chart by millis")
    public String ext_link_url_pattern = "http://my-scouter-paper-ip:6188/index.html#/paper?&address=localhost&port=6188&realtime=false&xlogElapsedTime=8000&instances=$[objHashes]&from=$[from]&to=$[to]&layout=my-layout-template-01";
    @ConfigDesc(value="Span Queue Size")
    public int span_queue_size = 1000;
    @ConfigDesc(value="XLog Writer Queue Size")
    public int xlog_queue_size = 10000;
    @ConfigDesc(value="Ignored time(ms) in retrieving XLog in real time")
    public int xlog_realtime_lower_bound_ms = 0;
    @ConfigDesc(value="Ignored time(ms) in retrieving previous XLog")
    public int xlog_pasttime_lower_bound_ms = 0;
    @ConfigDesc(value="Profile Writer Queue Size")
    public int profile_queue_size = 1000;
    @ConfigDesc(value="Activating IP-based city/country extraction")
    public boolean geoip_enabled = true;
    @ConfigDesc(value="Path to GeoIP data file")
    public String geoip_data_city_file = "./conf/GeoLiteCity.dat";
    @ConfigDesc(value="Activating table-based SQL compression")
    public boolean sql_table_parsing_enabled = true;
    @ConfigDesc(value="Activating TagCount function")
    public boolean tagcnt_enabled = true;
    @ConfigDesc(value="search xlog service option - max xlog count to search per request")
    public int req_search_xlog_max_count = 500;
    @ConfigDesc(value="Path to telegraf config xml file")
    public String input_telegraf_config_file = "./conf/scouter-telegraf.xml";
    @ConfigDesc(value="Deprecated use the telegraf config view instead. This value may be ignored.")
    public boolean input_telegraf_enabled = true;
    @ConfigDesc(value="Deprecated use the telegraf config view instead. This value may be ignored.")
    public boolean input_telegraf_debug_enabled = false;
    @ConfigDesc(value="Deprecated use the telegraf config view instead. This value may be ignored.")
    public boolean input_telegraf_delta_counter_normalize_default = true;
    @ConfigDesc(value="Deprecated use the telegraf config view instead. This value may be ignored.")
    public int input_telegraf_delta_counter_normalize_default_seconds = 30;
    @ConfigDesc(value="Deprecated use the telegraf config view instead. This value may be ignored.")
    public int telegraf_object_deadtime_ms = 35000;
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\nTelegraf http input of the $measurement$ enabled.\n$measurement$ is a variable to the measurement name of the line protocol.\neg) input_telegraf_$redis_keyspace$_enabled=true")
    public boolean input_telegraf_$measurement$_enabled = true;
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\nprint telegraf line protocol of the $measurement$ to STDOUT")
    public boolean input_telegraf_$measurement$_debug_enabled = false;
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\nIf set, only the metric matching to this tag value is handled.\nIt can have multiple values. comma separator means 'or' condition. eg) cpu:cpu-total,cpu:cpu0\nIt also have not(!) condition. eg) cpu:!cpu-total")
    @ConfigValueType(value=ValueType.COMMA_COLON_SEPARATED_VALUE, strings={"filtering tag name(reqiured)", "filtering tag value(reqiured)"}, booleans={true, true})
    public String input_telegraf_$measurement$_tag_filter = "";
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\nwhich fields of $measurement$ are mapped to scouter's counter.\nformat: {line-protocol field name}:{scouter counter name}:{display name?}:{unit?}:{hasTotal?}:{normalize sec?}\nIt can have multiple values.\n - {scouter counter name} can be defined in combination with the line protocol's tag variables.\nFor example, if the value of 'tag1' is 'disk01' and the value of 'tag2' is 'bin', the counter name defined as 'scouter-du-$tag1$-$tag2$' is 'scouter-du-disk01-bin'.\n eg)used_memory:tg-redis-used-memory,used_memory_rss:redis-used-memory-rss,redis used rss,bytes:true\n eg)cpu:cpu-$cpu-no$ -- this example shows counter definition with tag value.\nIf {line-protocol field name} is started with '&' or '&&', then It works as delta counter\nWhen specified as a delta type, the difference in values per second is stored. and the counter name ends with '_delta'\ndouble '&&' means BOTH type. AS BOTH type, the value and the difference value both are stored.\n - {normalize sec} applies only to a delta counter if the counter is a 'BOTH' type counter. (This value can have min 4 to max 60)")
    @ConfigValueType(value=ValueType.COMMA_COLON_SEPARATED_VALUE, strings={"line protocol field\n(reqiured)", "mapping counter name\n(reqiured)", "display name", "unit", "totalizable\ndefault true", "norm. sec.\ndefault 30"}, booleans={true, true, false, false, false, false})
    public String input_telegraf_$measurement$_counter_mappings = "";
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\ndefine an obj Family prefix. objectType is defined with some tags.\nsee input_telegraf_$measurement$_objFamily_append_tags option.")
    public String input_telegraf_$measurement$_objFamily_base = "";
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\nthis tags's value is appended to objFamily_base.\nIt can have multiple values. eg)tag1,tag2")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String input_telegraf_$measurement$_objFamily_append_tags = "";
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\ndefine an objectType prefix. objectType is defined with some tags.\nsee input_telegraf_$measurement$_objType_prepend(or append)_tags option.")
    public String input_telegraf_$measurement$_objType_base = "";
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\nthis tags's value is prepended to objType_base.\nIt can have multiple values. eg)tag1,tag2")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String input_telegraf_$measurement$_objType_prepend_tags = "scouter_obj_type_prefix";
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\nthis tags's value is appended to objType_base.\nIt can have multiple values. eg)tag1,tag2")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String input_telegraf_$measurement$_objType_append_tags = "";
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\nthis tags's value is object type's icon file name that the scouter client have. eg)redis")
    public String input_telegraf_$measurement$_objType_icon = "";
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\ndefine an objectName prefix. objectName is defined with some tags.\nsee input_telegraf_$measurement$_objName_append_tags option.")
    public String input_telegraf_$measurement$_objName_base = "";
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\nthis tags's value is appended to objName_base.\nIt can have multiple values. eg)tag1,tag2")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String input_telegraf_$measurement$_objName_append_tags = "";
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\ntag name to define host")
    public String input_telegraf_$measurement$_host_tag = "host";
    @ConfigDesc(value="[This option is just a sample. Change $measurement$ to your measurement name like $cpu$.]\nwhich host value defined with $measurement$_host_tag option is mapped to scouter's host.\nIt can have multiple values. eg)hostValue1:scouterHost1,hostValue2:scouterHost2")
    @ConfigValueType(value=ValueType.COMMA_COLON_SEPARATED_VALUE, strings={"telegraf host name(reqiured)", "scouter host name(reqiured)"}, booleans={true, true})
    public String input_telegraf_$measurement$_host_mappings = "";
    public boolean visitor_hourly_count_enabled = true;
    private long last_load_time = -1L;
    private long last_load_time_tg = -1L;
    public Properties property = new Properties();
    private boolean running = true;
    private File propertyFile;
    long last_check = 0L;
    public static boolean WORKABLE;
    private static HashSet<String> ignoreSet;

    public static final synchronized Configure getInstance() {
        if (instance == null) {
            instance = new Configure();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    public static final synchronized Configure newInstanceForTestCase() {
        if (instance != null) {
            Configure.instance.running = false;
        }
        instance = new Configure();
        instance.setDaemon(true);
        instance.setName(ThreadUtil.getName(instance));
        instance.start();
        return instance;
    }

    private Configure() {
        this.reload(false);
    }

    private Configure(boolean b) {
    }

    @Override
    public void run() {
        while (this.running) {
            this.reload(false);
            ThreadUtil.sleep(3000L);
        }
    }

    public File getPropertyFile() {
        if (this.propertyFile != null) {
            return this.propertyFile;
        }
        String s = System.getProperty("scouter.config", "./conf/scouter.conf");
        this.propertyFile = new File(s.trim());
        return this.propertyFile;
    }

    public File getTgFile() {
        return new File(this.input_telegraf_config_file);
    }

    public synchronized void reload(boolean force) {
        long now = System.currentTimeMillis();
        if (!force && now < this.last_check + 3000L) {
            return;
        }
        this.last_check = now;
        boolean configRenewed = this.reloadConfig();
        this.reloadTgConfig(configRenewed);
    }

    private void reloadTgConfig(boolean configRenewed) {
        File tgFile = this.getTgFile();
        if (!tgFile.exists() || tgFile.lastModified() != this.last_load_time_tg) {
            if (!tgFile.exists() && configRenewed) {
                this.telegrafInputConfigMap = this.telegrafInputConfigMapDeprecated;
            } else if (tgFile.canRead()) {
                try {
                    this.telegrafOriginalConfig = (TgConfig)unmarshaller.unmarshal(tgFile);
                    this.last_load_time_tg = tgFile.lastModified();
                }
                catch (JAXBException e) {
                    e.printStackTrace();
                }
                this.applyTelegrafInputConfigNew();
            }
        }
    }

    public String getTgConfigContents() {
        File tgFile = this.getTgFile();
        if (tgFile.exists() && tgFile.canRead()) {
            String tgContents = FileUtil.load(tgFile, "utf-8");
            return tgContents;
        }
        if (!tgFile.exists()) {
            return TgConfig.getSampleContents();
        }
        return "";
    }

    public boolean saveTgConfigContents(String text) {
        File tgFile = this.getTgFile();
        return FileUtil.saveText(tgFile, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reloadConfig() {
        block5: {
            File file = this.getPropertyFile();
            if (file.lastModified() == this.last_load_time) {
                return false;
            }
            this.last_load_time = file.lastModified();
            Properties temp = new Properties();
            if (!file.canRead()) break block5;
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                temp.load(in);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtil.close(in);
                    throw throwable;
                }
                FileUtil.close(in);
            }
            FileUtil.close(in);
            this.property = ConfigValueUtil.replaceSysProp(temp);
            this.applyConfig();
            this.applyTelegrafInputConfig();
            return true;
        }
        return false;
    }

    private void applyConfig() {
        this.xlog_queue_size = this.getInt("xlog_queue_size", 10000);
        this.profile_queue_size = this.getInt("profile_queue_size", 1000);
        this.log_tcp_action_enabled = this.getBoolean("log_tcp_action_enabled", false);
        this.net_udp_listen_ip = this.getValue("net_udp_listen_ip", "0.0.0.0");
        this.net_udp_listen_port = this.getInt("net_udp_listen_port", 6100);
        this.net_tcp_listen_ip = this.getValue("net_tcp_listen_ip", "0.0.0.0");
        this.net_tcp_listen_port = this.getInt("net_tcp_listen_port", 6100);
        this.net_tcp_client_so_timeout_ms = this.getInt("net_tcp_client_so_timeout_ms", 8000);
        this.net_tcp_agent_so_timeout_ms = this.getInt("net_tcp_agent_so_timeout_ms", 60000);
        this.net_tcp_agent_keepalive_interval_ms = this.getInt("net_tcp_agent_keepalive_interval_ms", 5000);
        this.net_tcp_get_agent_connection_wait_ms = this.getInt("net_tcp_get_agent_connection_wait_ms", 1000);
        this.net_http_server_enabled = this.getBoolean("net_http_server_enabled", false);
        this.net_http_port = this.getInt("net_http_port", 6180);
        this.net_http_extweb_dir = this.getValue("net_http_extweb_dir", "./extweb");
        this.net_http_api_enabled = this.getBoolean("net_http_api_enabled", false);
        this.net_http_api_swagger_enabled = this.getBoolean("net_http_api_swagger_enabled", false);
        this.net_http_api_swagger_host_ip = this.getValue("net_http_api_swagger_host_ip", "");
        this.net_http_api_cors_allow_origin = this.getValue("net_http_api_cors_allow_origin", "*");
        this.net_http_api_cors_allow_credentials = this.getValue("net_http_api_cors_allow_credentials", "true");
        this.net_webapp_tcp_client_pool_size = this.getInt("net_webapp_tcp_client_pool_size", 12);
        this.net_webapp_tcp_client_pool_timeout = this.getInt("net_webapp_tcp_client_pool_timeout", this.net_tcp_client_so_timeout_ms);
        this.net_http_api_auth_ip_enabled = this.getBoolean("net_http_api_auth_ip_enabled", false);
        this.net_http_api_auth_ip_header_key = this.getValue("net_http_api_auth_ip_header_key", "");
        this.net_http_api_auth_session_enabled = this.getBoolean("net_http_api_auth_session_enabled", false);
        this.net_http_api_session_timeout = this.getInt("net_http_api_session_timeout", 86400);
        this.net_http_api_auth_bearer_token_enabled = this.getBoolean("net_http_api_auth_bearer_token_enabled", false);
        this.net_http_api_gzip_enabled = this.getBoolean("net_http_api_gzip_enabled", true);
        this.net_http_api_allow_ips = this.getValue("net_http_api_allow_ips", "localhost,127.0.0.1,0:0:0:0:0:0:0:1,::1");
        this.server_id = this.getValue("server_id", SysJMX.getHostName());
        this.db_dir = this.getValue("db_dir", "./database");
        this.log_dir = this.getValue("log_dir", "./logs");
        this.plugin_dir = this.getValue("plugin_dir", "./plugin");
        this.client_dir = this.getValue("client_dir", "./client");
        this.temp_dir = this.getValue("temp_dir", "./tempdata");
        this.object_deadtime_ms = this.getInt("object_deadtime_ms", 8000);
        this.object_inactive_alert_level = this.getInt("object_inactive_alert_level", 0);
        this.object_zipkin_deadtime_ms = this.getInt("object_zipkin_deadtime_ms", 300000);
        this.compress_xlog_enabled = this.getBoolean("compress_xlog_enabled", false);
        this.compress_profile_enabled = this.getBoolean("compress_profile_enabled", false);
        this._compress_write_buffer_block_count = this.getInt("_compress_write_buffer_block_count", 3);
        this._compress_dailycount_header_cache_size = this.getInt("_compress_dailycount_header_cache_size", 3);
        this._compress_read_cache_block_count = this.getInt("_compress_read_cache_block_count", 3);
        this._compress_read_cache_expired_ms = this.getLong("_compress_read_cache_expired_ms", 60000L);
        this._compress_write_thread = this.getInt("_compress_write_thread", 2);
        this.net_udp_packet_buffer_size = this.getInt("net_udp_packet_buffer_size", 65535);
        int default_so_rcvbuf = 0x400000;
        if (SystemUtil.IS_AIX || SystemUtil.IS_HP_UX) {
            default_so_rcvbuf = 0;
        }
        this.net_udp_so_rcvbuf_size = this.getInt("net_udp_so_rcvbuf_size", default_so_rcvbuf);
        this.log_expired_multipacket = this.getBoolean("log_expired_multipacket", true);
        this.log_udp_multipacket = this.getBoolean("log_udp_multipacket", false);
        this.log_udp_packet = this.getBoolean("log_udp_packet", false);
        this.log_udp_counter = this.getBoolean("log_udp_counter", false);
        this.log_udp_interaction_counter = this.getBoolean("log_udp_interaction_counter", false);
        this.log_udp_xlog = this.getBoolean("log_udp_xlog", false);
        this.log_udp_profile = this.getBoolean("log_udp_profile", false);
        this.log_udp_text = this.getBoolean("log_udp_text", false);
        this.log_udp_alert = this.getBoolean("log_udp_alert", false);
        this.log_udp_object = this.getBoolean("log_udp_object", false);
        this.log_udp_status = this.getBoolean("log_udp_status", false);
        this.log_udp_stack = this.getBoolean("log_udp_stack", false);
        this.log_udp_summary = this.getBoolean("log_udp_summary", false);
        this.log_udp_batch = this.getBoolean("log_udp_batch", false);
        this.log_service_handler_list = this.getBoolean("log_service_handler_list", false);
        this.log_udp_span = this.getBoolean("log_udp_span", false);
        this.log_index_traversal_warning_count = this.getInt("log_index_traversal_warning_count", 100);
        this.log_rotation_enabled = this.getBoolean("log_rotation_enabled", true);
        this.log_keep_days = this.getInt("log_keep_days", 31);
        this.log_sql_parsing_fail_enabled = this.getBoolean("log_sql_parsing_fail_enabled", false);
        this._trace = this.getBoolean("_trace", false);
        this._auto_5m_sampling = this.getBoolean("_auto_5m_sampling", true);
        this.xlog_realtime_lower_bound_ms = this.getInt("xlog_realtime_lower_bound_ms", 0);
        this.xlog_pasttime_lower_bound_ms = this.getInt("xlog_pasttime_lower_bound_ms", 0);
        this.mgr_purge_enabled = this.getBoolean("mgr_purge_enabled", true);
        this.mgr_purge_disk_usage_pct = this.getInt("mgr_purge_disk_usage_pct", 80);
        this.mgr_purge_keep_days = this.getInt("mgr_purge_keep_days", 10);
        this.mgr_purge_profile_keep_days = this.getInt("mgr_purge_profile_keep_days", 10);
        if (this.mgr_purge_profile_keep_days == 0) {
            this.mgr_purge_profile_keep_days = this.mgr_purge_keep_days;
        }
        this.mgr_purge_xlog_without_profile_keep_days = this.getInt("mgr_purge_xlog_without_profile_keep_days", this.mgr_purge_profile_keep_days * 3);
        this.mgr_purge_xlog_keep_days = this.getInt("mgr_purge_xlog_keep_days", this.mgr_purge_profile_keep_days * 3);
        if (this.mgr_purge_xlog_keep_days == 0) {
            this.mgr_purge_xlog_keep_days = this.mgr_purge_xlog_without_profile_keep_days;
        }
        this.mgr_purge_counter_keep_days = this.getInt("mgr_purge_counter_keep_days", this.mgr_purge_keep_days * 7);
        this.mgr_text_db_daily_service_enabled = this.getBoolean("mgr_text_db_daily_service_enabled", false);
        this.mgr_text_db_daily_api_enabled = this.getBoolean("mgr_text_db_daily_api_enabled", false);
        this.mgr_text_db_daily_ua_enabled = this.getBoolean("mgr_text_db_daily_ua_enabled", false);
        this._mgr_text_db_index_default_mb = this.getInt("_mgr_text_db_index_default_mb", 1);
        this._mgr_text_db_index_service_mb = this.getInt("_mgr_text_db_index_service_mb", 1);
        this._mgr_text_db_index_api_mb = this.getInt("_mgr_text_db_index_api_mb", 1);
        this._mgr_text_db_index_ua_mb = this.getInt("_mgr_text_db_index_ua_mb", 1);
        this._mgr_text_db_index_login_mb = this.getInt("_mgr_text_db_index_login_mb", 1);
        this._mgr_text_db_index_desc_mb = this.getInt("_mgr_text_db_index_desc_mb", 1);
        this._mgr_text_db_index_hmsg_mb = this.getInt("_mgr_text_db_index_hmsg_mb", 1);
        this._mgr_text_db_daily_index_mb = this.getInt("_mgr_text_db_daily_index_mb", 1);
        this._mgr_kv_store_index_default_mb = this.getInt("_mgr_kv_store_index_default_mb", 8);
        this.ext_link_name = this.getValue("ext_link_name", "scouter-paper");
        this.ext_link_url_pattern = this.getValue("ext_link_url_pattern", "http://my-scouter-paper-ip:6188/index.html#/paper?&address=localhost&port=6188&realtime=false&xlogElapsedTime=8000&instances=$[objHashes]&from=$[from]&to=$[to]&layout=my-layout-template-01");
        this._net_udp_worker_thread_count = this.getInt("_net_udp_worker_thread_count", 3);
        this.geoip_data_city_file = this.getValue("geoip_data_city_file", "./conf/GeoLiteCity.dat");
        this.geoip_enabled = this.getBoolean("geoip_enabled", true);
        this.sql_table_parsing_enabled = this.getBoolean("sql_table_parsing_enabled", true);
        this.mgr_log_ignore_ids = this.getStringSet("mgr_log_ignore_ids", ",");
        this.tagcnt_enabled = this.getBoolean("tagcnt_enabled", true);
        this.visitor_hourly_count_enabled = this.getBoolean("visitor_hourly_count_enabled", true);
        this.net_tcp_service_pool_size = this.getInt("net_tcp_service_pool_size", 100);
        this.req_search_xlog_max_count = this.getInt("req_search_xlog_max_count", 500);
        this.input_telegraf_enabled = this.getBoolean("input_telegraf_enabled", true);
        this.input_telegraf_debug_enabled = this.getBoolean("input_telegraf_debug_enabled", false);
        this.input_telegraf_delta_counter_normalize_default = this.getBoolean("input_telegraf_delta_counter_normalize_default", true);
        this.input_telegraf_delta_counter_normalize_default_seconds = this.getInt("input_telegraf_delta_counter_normalize_default_seconds", 30);
        this.telegraf_object_deadtime_ms = this.getInt("telegraf_object_deadtime_ms", 35000);
        this.input_telegraf_$measurement$_enabled = this.getBoolean("input_telegraf_$measurement$_enabled", true);
        this.input_telegraf_$measurement$_debug_enabled = this.getBoolean("input_telegraf_$measurement$_debug_enabled", false);
        this.input_telegraf_$measurement$_tag_filter = this.getValue("input_telegraf_$measurement$_tag_filter", "");
        this.input_telegraf_$measurement$_counter_mappings = this.getValue("input_telegraf_$measurement$_counter_mappings", "");
        this.input_telegraf_$measurement$_objFamily_base = this.getValue("input_telegraf_$measurement$_objFamily_base", "");
        this.input_telegraf_$measurement$_objFamily_append_tags = this.getValue("input_telegraf_$measurement$_objFamily_append_tags", "");
        this.input_telegraf_$measurement$_objType_base = this.getValue("input_telegraf_$measurement$_objType_base", "");
        this.input_telegraf_$measurement$_objType_prepend_tags = this.getValue("input_telegraf_$measurement$_objType_prepend_tags", "scouter_obj_type_prefix");
        this.input_telegraf_$measurement$_objType_append_tags = this.getValue("input_telegraf_$measurement$_objType_append_tags", "");
        this.input_telegraf_$measurement$_objType_icon = this.getValue("input_telegraf_$measurement$_objType_icon", "");
        this.input_telegraf_$measurement$_objName_base = this.getValue("input_telegraf_$measurement$_objName_base", "");
        this.input_telegraf_$measurement$_objName_append_tags = this.getValue("input_telegraf_$measurement$_objName_append_tags", "");
        this.input_telegraf_$measurement$_host_tag = this.getValue("input_telegraf_$measurement$_host_tag", "host");
        this.input_telegraf_$measurement$_host_mappings = this.getValue("input_telegraf_$measurement$_host_mappings", "");
        ConfObserver.exec();
    }

    protected void applyTelegrafInputConfig() {
        HashMap<String, ScouterTgMtConfig> tConfigMap = new HashMap<String, ScouterTgMtConfig>();
        for (Map.Entry<Object, Object> e : this.property.entrySet()) {
            String[] hostMappings;
            String[] tags;
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            if (value == null || !key.startsWith(TELEGRAF_INPUT_MEASUREMENT_PREFIX)) continue;
            String simplifiedKey = key.substring(TELEGRAF_INPUT_MEASUREMENT_PREFIX_LENGTH);
            int secondDollar = simplifiedKey.indexOf("$_");
            String measurement = simplifiedKey.substring(0, secondDollar);
            String postfix = simplifiedKey.substring(secondDollar + 1);
            ScouterTgMtConfig tConfig = (ScouterTgMtConfig)tConfigMap.get(measurement);
            if (tConfig == null) {
                tConfig = new ScouterTgMtConfig(measurement);
                tConfig.setObjTypePrependTags(Arrays.asList(this.input_telegraf_$measurement$_objType_prepend_tags));
                tConfigMap.put(measurement, tConfig);
            }
            if (TELEGRAF_INPUT_MEASUREMENT_ENABLED_POSTFIX.equals(postfix)) {
                try {
                    tConfig.setEnabled(Boolean.parseBoolean(value));
                }
                catch (Exception exception) {}
                continue;
            }
            if (TELEGRAF_INPUT_MEASUREMENT_DEBUG_ENABLED_POSTFIX.equals(postfix)) {
                try {
                    tConfig.setDebugEnabled(Boolean.parseBoolean(value));
                }
                catch (Exception exception) {}
                continue;
            }
            if (TELEGRAF_INPUT_MEASUREMENT_TAG_FILTER_POSTFIX.equals(postfix)) {
                String[] mappings = StringUtil.split(value, ',');
                if (mappings.length == 0) continue;
                HashMap<String, List<String>> tagFilterMap = new HashMap<String, List<String>>();
                for (String mapping : mappings) {
                    String[] kv = StringUtil.split(mapping, ':');
                    if (kv.length != 2) {
                        Logger.println("CFG003", "Abnormal line protocol tag mapping config.");
                        continue;
                    }
                    ArrayList<String> list = (ArrayList<String>)tagFilterMap.get(kv[0]);
                    if (list == null) {
                        list = new ArrayList<String>();
                        tagFilterMap.put(kv[0], list);
                    }
                    list.add(kv[1]);
                }
                tConfig.setTagFilter(tagFilterMap);
                continue;
            }
            if (TELEGRAF_INPUT_MEASUREMENT_COUNTER_MAPPINGS_POSTFIX.equals(postfix)) {
                String[] counterMappings = StringUtil.split(value, ',');
                if (counterMappings == null || counterMappings.length == 0) continue;
                HashMap<String, CounterProtocol> counterMappingMap = new HashMap<String, CounterProtocol>();
                for (String counterMapping : counterMappings) {
                    CounterProtocol counter = new CounterProtocol();
                    String[] split = StringUtil.splitByWholeSeparatorPreserveAllTokens(counterMapping, ':');
                    if (split.length >= 2) {
                        String originName;
                        String originName0 = originName = split[0];
                        if (originName.charAt(0) == '&') {
                            if (originName.charAt(1) == '&') {
                                counter.setDeltaType(DeltaType.BOTH);
                                originName0 = originName.substring(2);
                            } else {
                                counter.setDeltaType(DeltaType.DELTA);
                                originName0 = originName.substring(1);
                            }
                        }
                        counterMappingMap.put(originName0, counter);
                        counter.setName(split[1]);
                    }
                    if (split.length >= 3) {
                        if (StringUtil.isNotEmpty(split[2])) {
                            counter.setDisplayName(split[2]);
                        } else {
                            counter.setDisplayName(split[1]);
                        }
                    } else {
                        counter.setDisplayName(split[1]);
                    }
                    if (split.length >= 4) {
                        counter.setUnit(split[3]);
                    } else {
                        counter.setUnit("");
                    }
                    if (split.length >= 5) {
                        try {
                            counter.setTotal(Boolean.parseBoolean(split[4]));
                        }
                        catch (Exception originName) {
                            // empty catch block
                        }
                    }
                    if (split.length < 6) continue;
                    int normalizeSec = 0;
                    try {
                        normalizeSec = Integer.valueOf(split[5]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    counter.setNormalizeSec(normalizeSec);
                }
                tConfig.setCounterMapping(counterMappingMap);
                continue;
            }
            if (TELEGRAF_INPUT_MEASUREMENT_OBJ_FAMILY_BASE_POSTFIX.equals(postfix)) {
                tConfig.setObjFamilyBase(value);
                continue;
            }
            if (TELEGRAF_INPUT_MEASUREMENT_OBJ_FAMILY_APPEND_TAGS_POSTFIX.equals(postfix)) {
                tags = StringUtil.split(value, ',');
                if (tags == null || tags.length == 0) continue;
                tConfig.setObjFamilyAppendTags(Arrays.asList(tags));
                continue;
            }
            if (TELEGRAF_INPUT_MEASUREMENT_OBJ_TYPE_BASE_POSTFIX.equals(postfix)) {
                tConfig.setObjTypeBase(value);
                continue;
            }
            if (TELEGRAF_INPUT_MEASUREMENT_OBJ_TYPE_PREPEND_TAGS_POSTFIX.equals(postfix)) {
                if (StringUtil.isEmpty(value)) {
                    value = this.input_telegraf_$measurement$_objType_prepend_tags;
                }
                if ((tags = StringUtil.split(value, ',')) == null || tags.length == 0) continue;
                tConfig.setObjTypePrependTags(Arrays.asList(tags));
                continue;
            }
            if (TELEGRAF_INPUT_MEASUREMENT_OBJ_TYPE_APPEND_TAGS_POSTFIX.equals(postfix)) {
                tags = StringUtil.split(value, ',');
                if (tags == null || tags.length == 0) continue;
                tConfig.setObjTypeAppendTags(Arrays.asList(tags));
                continue;
            }
            if (TELEGRAF_INPUT_MEASUREMENT_OBJ_TYPE_ICON_POSTFIX.equals(postfix)) {
                tConfig.setObjTypeIcon(value);
                continue;
            }
            if (TELEGRAF_INPUT_MEASUREMENT_OBJ_NAME_BASE_POSTFIX.equals(postfix)) {
                tConfig.setObjNameBase(value);
                continue;
            }
            if (TELEGRAF_INPUT_MEASUREMENT_OBJ_NAME_APPEND_TAGS.equals(postfix)) {
                tags = StringUtil.split(value, ',');
                if (tags == null || tags.length == 0) continue;
                tConfig.setObjNameAppendTags(Arrays.asList(tags));
                continue;
            }
            if (TELEGRAF_INPUT_MEASUREMENT_HOST_TAG_POSTFIX.equals(postfix)) {
                tConfig.setHostTag(value);
                continue;
            }
            if (!TELEGRAF_INPUT_MEASUREMENT_HOST_MAPPINGS_POSTFIX.equals(postfix) || (hostMappings = StringUtil.split(value, ',')) == null || hostMappings.length == 0) continue;
            HashMap<String, String> hostMappingMap = new HashMap<String, String>();
            for (String hostAndMap : hostMappings) {
                String[] split = StringUtil.split(hostAndMap, ':');
                if (split.length != 2) continue;
                hostMappingMap.put(split[0], split[1]);
            }
            tConfig.setHostMapping(hostMappingMap);
        }
        this.telegrafInputConfigMapDeprecated = tConfigMap;
    }

    protected void applyTelegrafInputConfigNew() {
        HashMap<String, ScouterTgMtConfig> tConfigMap = new HashMap<String, ScouterTgMtConfig>();
        if (this.telegrafOriginalConfig == null) {
            return;
        }
        this.input_telegraf_enabled = this.telegrafOriginalConfig.enabled;
        if (this.input_telegraf_enabled) {
            this.net_http_server_enabled = true;
        }
        this.input_telegraf_debug_enabled = this.telegrafOriginalConfig.debugEnabled;
        this.input_telegraf_delta_counter_normalize_default = this.telegrafOriginalConfig.deltaCounterNormalizeDefault;
        this.input_telegraf_delta_counter_normalize_default_seconds = this.telegrafOriginalConfig.deltaCounterNormalizeDefaultSeconds;
        this.telegraf_object_deadtime_ms = this.telegrafOriginalConfig.objectDeadtimeMs;
        for (TgmConfig tgmConfig : this.telegrafOriginalConfig.measurements) {
            String measurementName = tgmConfig.measurementName;
            ScouterTgMtConfig scouterMtConfig = (ScouterTgMtConfig)tConfigMap.get(measurementName);
            if (scouterMtConfig == null) {
                scouterMtConfig = new ScouterTgMtConfig(measurementName);
                tConfigMap.put(measurementName, scouterMtConfig);
            }
            scouterMtConfig.setEnabled(tgmConfig.enabled);
            scouterMtConfig.setDebugEnabled(tgmConfig.debugEnabled);
            scouterMtConfig.setTagFilter(tgmConfig.tagFilters.stream().collect(Collectors.toMap(f -> f.tag, f -> f.match, (v1, v2) -> {
                v1.addAll(v2);
                return v1;
            }, HashMap::new)));
            tgmConfig.tagFilters.stream().collect(Collectors.groupingBy(f -> f.tag)).entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (List)e.getValue()));
            scouterMtConfig.setObjFamilyBase(tgmConfig.objFamilyBase);
            scouterMtConfig.setObjFamilyAppendTags(tgmConfig.objFamilyAppendTags);
            scouterMtConfig.setObjTypeBase(tgmConfig.objTypeBase);
            scouterMtConfig.setObjTypePrependTags(tgmConfig.objTypePrependTags);
            scouterMtConfig.setObjTypeAppendTags(tgmConfig.objTypeAppendTags);
            scouterMtConfig.setObjTypeIcon(tgmConfig.objTypeIcon);
            scouterMtConfig.setObjNameBase(tgmConfig.objNameBase);
            scouterMtConfig.setObjNameAppendTags(tgmConfig.objNameAppendTags);
            scouterMtConfig.setHostTag(tgmConfig.hostTag);
            scouterMtConfig.setHostMapping(tgmConfig.hostMappings.stream().collect(Collectors.toMap(m -> m.telegraf, m -> m.scouter)));
            scouterMtConfig.setCounterMapping(tgmConfig.counterMappings.stream().collect(Collectors.toMap(m -> m.tgFieldName, CounterProtocol::of)));
        }
        for (Map.Entry entry : this.telegrafInputConfigMapDeprecated.entrySet()) {
            if (tConfigMap.containsKey(entry.getKey())) continue;
            tConfigMap.put((String)entry.getKey(), (ScouterTgMtConfig)entry.getValue());
        }
        this.telegrafInputConfigMap = tConfigMap;
    }

    private StringSet getStringSet(String key, String deli) {
        StringSet set = new StringSet();
        String v = this.getValue(key);
        if (v != null) {
            String[] vv;
            for (String x : vv = StringUtil.split(v, deli)) {
                if ((x = StringUtil.trimToEmpty(x)).length() <= 0) continue;
                set.put(x);
            }
        }
        return set;
    }

    public String getValue(String key) {
        return StringUtil.trim(this.property.getProperty(key));
    }

    public String getValue(String key, String def) {
        return StringUtil.trim(this.property.getProperty(key, def));
    }

    public int getInt(String key, int def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Integer.parseInt(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public long getLong(String key, long def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Long.parseLong(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Boolean.parseBoolean(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String loadText() {
        String string;
        File file = this.getPropertyFile();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            byte[] buff = FileUtil.readAll(fin);
            string = new String(buff);
        }
        catch (Exception exception) {
            FileUtil.close(fin);
            return null;
        }
        catch (Throwable throwable) {
            FileUtil.close(fin);
            throw throwable;
        }
        FileUtil.close(fin);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveText(String text) {
        block6: {
            boolean bl;
            File file = this.getPropertyFile();
            FileOutputStream out = null;
            try {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                out = new FileOutputStream(file);
                ((OutputStream)out).write(text.getBytes());
                bl = true;
                FileUtil.close(out);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                FileUtil.close(out);
            }
            return bl;
        }
        return false;
    }

    public MapValue getKeyValueInfo() {
        StringKeyLinkedMap<Object> defMap = ConfigValueUtil.getConfigDefault(new Configure(true));
        StringKeyLinkedMap<Object> curMap = ConfigValueUtil.getConfigDefault(this);
        MapValue m = new MapValue();
        ListValue nameList = m.newList("key");
        ListValue valueList = m.newList("value");
        ListValue defList = m.newList("default");
        StringEnumer enu = defMap.keys();
        while (enu.hasMoreElements()) {
            String key = enu.nextString();
            if (ignoreSet.contains(key)) continue;
            nameList.add(key);
            valueList.add(ConfigValueUtil.toValue(curMap.get(key)));
            defList.add(ConfigValueUtil.toValue(defMap.get(key)));
        }
        return m;
    }

    public StringKeyLinkedMap<String> getConfigureDesc() {
        return ConfigValueUtil.getConfigDescMap(this);
    }

    public StringKeyLinkedMap<ValueType> getConfigureValueType() {
        return ConfigValueUtil.getConfigValueTypeMap(this);
    }

    public StringKeyLinkedMap<ValueTypeDesc> getConfigureValueTypeDesc() {
        return ConfigValueUtil.getConfigValueTypeDescMap(this);
    }

    public static StringLinkedSet toOrderSet(String values, String deli) {
        StringLinkedSet set = new StringLinkedSet();
        StringTokenizer nizer = new StringTokenizer(values, deli);
        while (nizer.hasMoreTokens()) {
            String s = StringUtil.trimToEmpty(nizer.nextToken());
            if (s.length() <= 0) continue;
            set.put(s);
        }
        return set;
    }

    public static void main(String[] args) {
        StringKeyLinkedMap<ValueType> map = new Configure().getConfigureValueType();
        System.out.println(map);
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TgConfig.class});
            marshaller = jaxbContext.createMarshaller();
            unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        TELEGRAF_INPUT_MEASUREMENT_PREFIX_LENGTH = TELEGRAF_INPUT_MEASUREMENT_PREFIX.length();
        WORKABLE = true;
        ignoreSet = new HashSet();
        ignoreSet.add("property");
        ignoreSet.add("telegrafInputConfigMap");
    }
}

