/*
 * Decompiled with CFR 0.152.
 */
package scouter.server;

import java.io.File;
import java.io.IOException;
import scouter.Version;
import scouter.server.Configure;
import scouter.server.CounterManager;
import scouter.server.Logger;
import scouter.server.ShutdownManager;
import scouter.server.account.AccountManager;
import scouter.server.core.AutoDeleteScheduler;
import scouter.server.core.TextCacheReset;
import scouter.server.db.DBCtr;
import scouter.server.http.HttpServer;
import scouter.server.netio.data.NetDataProcessor;
import scouter.server.netio.data.net.DataUdpServer;
import scouter.server.netio.service.ServiceHandlingProxy;
import scouter.server.netio.service.net.TcpServer;
import scouter.server.plugin.PlugInManager;
import scouter.server.plugin.alert.AlertEngine;
import scouter.server.plugin.builtin.BuiltInPluginManager;
import scouter.server.term.TermMain;
import scouter.util.ShellArg;
import scouter.util.SysJMX;
import scouter.util.ThreadUtil;
import scouter.util.logo.Logo;

public class Main {
    public static void main(String[] args) throws IOException, Exception {
        Logo.print(true);
        Logger.println("Scouter Server Version " + Version.getServerFullVersion());
        Logo.print(Logger.pw(), true);
        Configure.getInstance();
        if (!DBCtr.createLock()) {
            return;
        }
        AlertEngine.load();
        CounterManager.getInstance();
        AccountManager.ACCOUNT_FILENAME();
        DataUdpServer.conf();
        ServiceHandlingProxy.load();
        TcpServer.conf();
        HttpServer.load();
        PlugInManager.load();
        BuiltInPluginManager.loadPlugins();
        NetDataProcessor.working();
        AutoDeleteScheduler.getInstance();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ShutdownManager.shutdown();
            }
        });
        TextCacheReset.engine();
        ShellArg sarg = new ShellArg(args);
        if (!sarg.hasKey("-console")) {
            File exit = new File(SysJMX.getProcessPID() + ".scouter");
            try {
                exit.createNewFile();
            }
            catch (Exception e) {
                String tmp = System.getProperty("user.home", "/tmp");
                exit = new File(tmp, SysJMX.getProcessPID() + ".scouter.run");
                try {
                    exit.createNewFile();
                }
                catch (Exception k) {
                    System.exit(1);
                }
            }
            exit.deleteOnExit();
            System.out.println("System JRE version : " + System.getProperty("java.version"));
            while (true) {
                if (!exit.exists()) {
                    ShutdownManager.shutdown();
                    System.exit(0);
                }
                DBCtr.updateLock();
                ThreadUtil.sleep(1000L);
            }
        }
        TermMain.process(sarg);
    }
}

