/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core.cache;

import java.util.ArrayList;
import java.util.List;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scouter.server.core.cache.CacheOut;
import scouter.util.IntSet;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001-\u0011Q\u0002\u0017'pO2{w\u000e]\"bG\",'BA\u0002\u0005\u0003\u0015\u0019\u0017m\u00195f\u0015\t)a!\u0001\u0003d_J,'BA\u0004\t\u0003\u0019\u0019XM\u001d<fe*\t\u0011\"A\u0004tG>,H/\u001a:\u0004\u0001U\u0011AbH\n\u0003\u00015\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007\u0002\u0003\u000b\u0001\u0005\u0003\u0005\u000b\u0011B\u000b\u0002\u0011\r\f\u0007/Y2jif\u0004\"A\u0004\f\n\u0005]y!aA%oi\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\"a\u0007\u0015\u0011\u0007q\u0001Q$D\u0001\u0003!\tqr\u0004\u0004\u0001\u0005\u000b\u0001\u0002!\u0019A\u0011\u0003\u0003Y\u000b\"AI\u0013\u0011\u00059\u0019\u0013B\u0001\u0013\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0004\u0014\n\u0005\u001dz!aA!os\")A\u0003\u0007a\u0001+!9!\u0006\u0001b\u0001\n\u0003Y\u0013!B9vKV,W#\u0001\u0017\u0011\u00079iS%\u0003\u0002/\u001f\t)\u0011I\u001d:bs\"1\u0001\u0007\u0001Q\u0001\n1\na!];fk\u0016\u0004\u0003b\u0002\u001a\u0001\u0005\u0004%\taM\u0001\r_\nT\u0007*Y:i)\u0006\u0014G.Z\u000b\u0002iA\u0019a\"L\u000b\t\rY\u0002\u0001\u0015!\u00035\u00035y'M\u001b%bg\"$\u0016M\u00197fA!9\u0001\b\u0001b\u0001\n\u0003\u0019\u0014aB3mCB\u001cX\r\u001a\u0005\u0007u\u0001\u0001\u000b\u0011\u0002\u001b\u0002\u0011\u0015d\u0017\r]:fI\u0002Bq\u0001\u0010\u0001C\u0002\u0013\u0005Q(A\u0003feJ|'/F\u0001?!\rqQf\u0010\t\u0003\u001d\u0001K!!Q\b\u0003\u000f\t{w\u000e\\3b]\"11\t\u0001Q\u0001\ny\na!\u001a:s_J\u0004\u0003bB#\u0001\u0001\u0004%\tAR\u0001\u0006S:$W\r_\u000b\u0002+!9\u0001\n\u0001a\u0001\n\u0003I\u0015!C5oI\u0016Dx\fJ3r)\tQU\n\u0005\u0002\u000f\u0017&\u0011Aj\u0004\u0002\u0005+:LG\u000fC\u0004O\u000f\u0006\u0005\t\u0019A\u000b\u0002\u0007a$\u0013\u0007\u0003\u0004Q\u0001\u0001\u0006K!F\u0001\u0007S:$W\r\u001f\u0011\t\u000fI\u0003\u0001\u0019!C\u0001'\u0006!An\\8q+\u0005!\u0006C\u0001\bV\u0013\t1vB\u0001\u0003M_:<\u0007b\u0002-\u0001\u0001\u0004%\t!W\u0001\tY>|\u0007o\u0018\u0013fcR\u0011!J\u0017\u0005\b\u001d^\u000b\t\u00111\u0001U\u0011\u0019a\u0006\u0001)Q\u0005)\u0006)An\\8qA!)a\f\u0001C\u0001?\u0006\u0019\u0001/\u001e;\u0015\u000b)\u0003'\r\u001a4\t\u000b\u0005l\u0006\u0019A\u000b\u0002\u000f=\u0014'\u000eS1tQ\")1-\u0018a\u0001+\u0005!A/[7f\u0011\u0015)W\f1\u0001@\u0003\r)'O\u001d\u0005\u0006Ov\u0003\r!H\u0001\u0007e\u0016\u001cwN\u001d3\t\u000b%\u0004A\u0011\u00016\u0002\u000f\u001d,G\u000fT5tiR!1n];x!\ra\u0017/H\u0007\u0002[*\u0011an\\\u0001\u0005kRLGNC\u0001q\u0003\u0011Q\u0017M^1\n\u0005Il'\u0001\u0002'jgRDQ\u0001\u001e5A\u0002Q\u000b!b\u001d;beR|Fn\\8q\u0011\u00151\b\u000e1\u0001\u0016\u0003-\u0019H/\u0019:u?&tG-\u001a=\t\u000b\rD\u0007\u0019A\u000b\t\u000b%\u0004A\u0011A=\u0015\u0011-T\u00181AA\u0003\u0003\u000fAQa\u001f=A\u0002q\f!b\u001c2k\u0011\u0006\u001c\bnU3u!\tix0D\u0001\u007f\u0015\tq\u0007\"C\u0002\u0002\u0002y\u0014a!\u00138u'\u0016$\b\"\u0002;y\u0001\u0004!\u0006\"\u0002<y\u0001\u0004)\u0002\"B2y\u0001\u0004)\u0002bBA\u0006\u0001\u0011\u0005\u0011QB\u0001\u0013O\u0016$H*[:u/&$\b.\u001b8D_VtG\u000fF\u0004l\u0003\u001f\t\t\"a\u0005\t\rQ\fI\u00011\u0001U\u0011\u00191\u0018\u0011\u0002a\u0001+!9\u0011QCA\u0005\u0001\u0004)\u0012AB0d_VtG\u000fC\u0004\u0002\f\u0001!\t!!\u0007\u0015\u0013-\fY\"!\b\u0002 \u0005\u0005\u0002BB>\u0002\u0018\u0001\u0007A\u0010\u0003\u0004u\u0003/\u0001\r\u0001\u0016\u0005\u0007m\u0006]\u0001\u0019A\u000b\t\u000f\u0005U\u0011q\u0003a\u0001+!9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\u0012\u0001B2paf$2BSA\u0015\u0003W\ty#a\r\u00028!110a\tA\u0002qDq!!\f\u0002$\u0001\u00071.\u0001\u0003ck\u001a4\u0007bBA\u0019\u0003G\u0001\r!F\u0001\u0006?\u001a\u0014x.\u001c\u0005\b\u0003k\t\u0019\u00031\u0001\u0016\u0003\ryFo\u001c\u0005\u0007G\u0006\r\u0002\u0019A\u000b\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002<QI!*!\u0010\u0002@\u0005\u0005\u00131\t\u0005\b\u0003[\tI\u00041\u0001l\u0011\u001d\t\t$!\u000fA\u0002UAq!!\u000e\u0002:\u0001\u0007Q\u0003\u0003\u0004d\u0003s\u0001\r!\u0006\u0005\b\u0003K\u0001A\u0011AA$)\u001dQ\u0015\u0011JA&\u0003\u001bBq!!\f\u0002F\u0001\u00071\u000eC\u0004\u00022\u0005\u0015\u0003\u0019A\u000b\t\u000f\u0005U\u0012Q\ta\u0001+!9\u0011Q\u0005\u0001\u0005\n\u0005EC#\u0003&\u0002T\u0005U\u0013qKA-\u0011\u0019Y\u0018q\na\u0001y\"9\u0011QFA(\u0001\u0004Y\u0007bBA\u0019\u0003\u001f\u0002\r!\u0006\u0005\b\u0003k\ty\u00051\u0001\u0016\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\n1aZ3u)!\t\t'a\u001a\u0002l\u0005=\u0004\u0003\u0002\u000f\u0002duI1!!\u001a\u0003\u0005!\u0019\u0015m\u00195f\u001fV$\bbBA5\u00037\u0002\r\u0001V\u0001\nY\u0006\u001cHo\u00187p_BDq!!\u001c\u0002\\\u0001\u0007Q#\u0001\u0006mCN$x,\u001b8eKbDaaYA.\u0001\u0004)\u0002bBA/\u0001\u0011\u0005\u00111\u000f\u000b\u000b\u0003C\n)(a\u001e\u0002z\u0005m\u0004BB>\u0002r\u0001\u0007A\u0010C\u0004\u0002j\u0005E\u0004\u0019\u0001+\t\u000f\u00055\u0014\u0011\u000fa\u0001+!11-!\u001dA\u0002UAq!a \u0001\t\u0003\t\t)\u0001\bhKR<\u0016\u000e\u001e5j]\u000e{WO\u001c;\u0015\u0011\u0005\u0005\u00141QAC\u0003\u000fCq!!\u001b\u0002~\u0001\u0007A\u000bC\u0004\u0002n\u0005u\u0004\u0019A\u000b\t\u000f\u0005%\u0015Q\u0010a\u0001+\u0005)1m\\;oi\"9\u0011q\u0010\u0001\u0005\u0002\u00055ECCA1\u0003\u001f\u000b\t*a%\u0002\u0016\"110a#A\u0002qDq!!\u001b\u0002\f\u0002\u0007A\u000bC\u0004\u0002n\u0005-\u0005\u0019A\u000b\t\u000f\u0005%\u00151\u0012a\u0001+\u0001")
public class XLogLoopCache<V> {
    private final Object[] queue;
    private final int[] objHashTable;
    private final int[] elapsed;
    private final boolean[] error;
    private int index;
    private long loop;

    public Object[] queue() {
        return this.queue;
    }

    public int[] objHashTable() {
        return this.objHashTable;
    }

    public int[] elapsed() {
        return this.elapsed;
    }

    public boolean[] error() {
        return this.error;
    }

    public int index() {
        return this.index;
    }

    public void index_$eq(int x$1) {
        this.index = x$1;
    }

    public long loop() {
        return this.loop;
    }

    public void loop_$eq(long x$1) {
        this.loop = x$1;
    }

    public void put(int objHash, int time, boolean err, V record) {
        Object[] objectArray = this.queue();
        synchronized (objectArray) {
            BoxedUnit boxedUnit;
            this.queue()[this.index()] = record;
            this.objHashTable()[this.index()] = objHash;
            this.elapsed()[this.index()] = time;
            this.error()[this.index()] = err;
            this.index_$eq(this.index() + 1);
            if (this.index() >= this.queue().length) {
                this.loop_$eq(this.loop() + 1L);
                this.index_$eq(0);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public List<V> getList(long start_loop, int start_index, int time) {
        int end_index = this.index();
        long end_loop = this.loop();
        ArrayList buff = new ArrayList(this.queue().length);
        long l = end_loop - start_loop;
        if (0L == l) {
            BoxedUnit boxedUnit;
            if (start_index < end_index) {
                this.copy(buff, start_index, end_index, time);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (1L == l) {
            BoxedUnit boxedUnit;
            if (start_index <= end_index) {
                this.copy(buff, end_index, this.queue().length, time);
                this.copy(buff, 0, end_index, time);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.copy(buff, start_index, this.queue().length, time);
                this.copy(buff, 0, end_index, time);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            this.copy(buff, end_index, this.queue().length, time);
            this.copy(buff, 0, end_index, time);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return buff;
    }

    public List<V> getList(IntSet objHashSet, long start_loop, int start_index, int time) {
        int end_index = this.index();
        long end_loop = this.loop();
        ArrayList buff = new ArrayList(this.queue().length);
        long l = end_loop - start_loop;
        if (0L == l) {
            BoxedUnit boxedUnit;
            if (start_index < end_index) {
                this.copy(objHashSet, buff, start_index, end_index, time);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (1L == l) {
            BoxedUnit boxedUnit;
            if (start_index <= end_index) {
                this.copy(objHashSet, buff, end_index, this.queue().length, time);
                this.copy(objHashSet, buff, 0, end_index, time);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.copy(objHashSet, buff, start_index, this.queue().length, time);
                this.copy(objHashSet, buff, 0, end_index, time);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            this.copy(objHashSet, buff, end_index, this.queue().length, time);
            this.copy(objHashSet, buff, 0, end_index, time);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return buff;
    }

    public List<V> getListWithinCount(long start_loop, int start_index, int _count) {
        int count = _count;
        long l = this.loop() - start_loop;
        if (0L == l) {
            BoxedUnit boxedUnit;
            int gap = this.index() - start_index;
            if (gap > 0) {
                count = Math.min(count, gap);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (1L == l) {
            count = Math.min(count, this.queue().length - start_index + this.index());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ArrayList buff = new ArrayList(count);
        if (count > this.index()) {
            this.copy(buff, this.queue().length - (count - this.index()), this.queue().length);
            this.copy(buff, 0, this.index());
        } else {
            this.copy(buff, this.index() - count, this.index());
        }
        return buff;
    }

    public List<V> getListWithinCount(IntSet objHashSet, long start_loop, int start_index, int _count) {
        int count = _count;
        long l = this.loop() - start_loop;
        if (0L == l) {
            BoxedUnit boxedUnit;
            int gap = this.index() - start_index;
            if (gap > 0) {
                count = Math.min(count, gap);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (1L == l) {
            count = Math.min(count, this.queue().length - start_index + this.index());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ArrayList buff = new ArrayList(count);
        if (count > this.index()) {
            this.copy(objHashSet, buff, this.queue().length - (count - this.index()), this.queue().length);
            this.copy(objHashSet, buff, 0, this.index());
        } else {
            this.copy(objHashSet, buff, this.index() - count, this.index());
        }
        return buff;
    }

    private void copy(IntSet objHashSet, List<V> buff, int _from, int _to, int time) {
        for (int i = _from; i < _to; ++i) {
            Object object;
            if (objHashSet == null || objHashSet.contains(this.objHashTable()[i])) {
                if (this.queue()[i] != null && (this.elapsed()[i] >= time || this.error()[i])) {
                    object = BoxesRunTime.boxToBoolean((boolean)buff.add(this.queue()[i]));
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
    }

    public void copy(List<V> buff, int _from, int _to, int time) {
        for (int i = _from; i < _to; ++i) {
            Object object = this.queue()[i] != null && (this.elapsed()[i] >= time || this.error()[i]) ? BoxesRunTime.boxToBoolean((boolean)buff.add(this.queue()[i])) : BoxedUnit.UNIT;
        }
    }

    public void copy(List<V> buff, int _from, int _to) {
        for (int i = _from; i < _to; ++i) {
            Object object = this.queue()[i] == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)buff.add(this.queue()[i]));
        }
    }

    private void copy(IntSet objHashSet, List<V> buff, int _from, int _to) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(_from), _to).foreach((Function1)new Serializable(this, objHashSet, buff){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XLogLoopCache $outer;
            private final IntSet objHashSet$1;
            private final List buff$1;

            public final Object apply(int i) {
                return this.objHashSet$1 == null || this.objHashSet$1.contains(this.$outer.objHashTable()[i]) ? (this.$outer.queue()[i] == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.buff$1.add(this.$outer.queue()[i]))) : BoxedUnit.UNIT;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.objHashSet$1 = objHashSet$1;
                this.buff$1 = var3_3;
            }
        });
    }

    public CacheOut<V> get(long last_loop, int last_index, int time) {
        CacheOut<V> d = new CacheOut<V>();
        d.data_$eq(this.getList(last_loop, last_index, time));
        d.loop_$eq(this.loop());
        d.index_$eq(this.index());
        return d;
    }

    public CacheOut<V> get(IntSet objHashSet, long last_loop, int last_index, int time) {
        CacheOut<V> d = new CacheOut<V>();
        d.data_$eq(this.getList(objHashSet, last_loop, last_index, time));
        d.loop_$eq(this.loop());
        d.index_$eq(this.index());
        return d;
    }

    public CacheOut<V> getWithinCount(long last_loop, int last_index, int count) {
        CacheOut<V> d = new CacheOut<V>();
        d.data_$eq(this.getListWithinCount(last_loop, last_index, count));
        d.loop_$eq(this.loop());
        d.index_$eq(this.index());
        return d;
    }

    public CacheOut<V> getWithinCount(IntSet objHashSet, long last_loop, int last_index, int count) {
        CacheOut<V> d = new CacheOut<V>();
        d.data_$eq(this.getListWithinCount(objHashSet, last_loop, last_index, count));
        d.loop_$eq(this.loop());
        d.index_$eq(this.index());
        return d;
    }

    public XLogLoopCache(int capacity) {
        this.queue = new Object[capacity];
        this.objHashTable = new int[capacity];
        this.elapsed = new int[capacity];
        this.error = new boolean[capacity];
        this.index = 0;
        this.loop = 0L;
    }
}

