/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.lang.CounterKey;
import scouter.lang.value.Value;
import scouter.server.Logger$;
import scouter.server.db.DBCtr$;
import scouter.server.db.DailyCounterWR;
import scouter.server.db.counter.DailyCounterData;
import scouter.server.db.counter.DailyCounterData$;
import scouter.server.db.counter.DailyCounterIndex;
import scouter.server.db.counter.DailyCounterIndex$;
import scouter.server.util.OftenAction$;
import scouter.server.util.ThreadScala$;
import scouter.util.FileUtil;
import scouter.util.RequestQueue;

public final class DailyCounterWR$ {
    public static final DailyCounterWR$ MODULE$;
    private final RequestQueue<DailyCounterWR.Data> queue;
    private final String prefix;
    private int lastDateInt;
    private DailyCounterIndex index;
    private DailyCounterData writer;

    static {
        new DailyCounterWR$();
    }

    public RequestQueue<DailyCounterWR.Data> queue() {
        return this.queue;
    }

    public String prefix() {
        return this.prefix;
    }

    public int lastDateInt() {
        return this.lastDateInt;
    }

    public void lastDateInt_$eq(int x$1) {
        this.lastDateInt = x$1;
    }

    public DailyCounterIndex index() {
        return this.index;
    }

    public void index_$eq(DailyCounterIndex x$1) {
        this.index = x$1;
    }

    public DailyCounterData writer() {
        return this.writer;
    }

    public void writer_$eq(DailyCounterData x$1) {
        this.writer = x$1;
    }

    public void add(int date, CounterKey key, int hhmm, Value value) {
        boolean ok = this.queue().put(new DailyCounterWR.Data(date, key, hhmm, value));
        if (!ok) {
            Logger$.MODULE$.println("S123", 10, "queue exceeded!!");
        }
    }

    public void close() {
        FileUtil.close(this.index());
        FileUtil.close(this.writer());
        this.index_$eq(null);
        this.writer_$eq(null);
    }

    public void closeForce() {
        try {
            if (this.index() != null) {
                this.index().closeForce();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            if (this.writer() != null) {
                this.writer().closeForce();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.index_$eq(null);
        this.writer_$eq(null);
    }

    public void open(String date) {
        try {
            String path = this.getDBPath(date);
            File f = new File(path);
            Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
            String fileName = new StringBuilder().append((Object)path).append((Object)"/").append((Object)this.prefix()).toString();
            this.index_$eq(DailyCounterIndex$.MODULE$.open(fileName));
            this.writer_$eq(DailyCounterData$.MODULE$.openForWrite(fileName));
            return;
        }
        catch (Throwable throwable) {
            this.index_$eq(null);
            this.writer_$eq(null);
            Logger$.MODULE$.println("G103", throwable.getMessage());
            Logger$.MODULE$.printStackTrace("G104", throwable);
            this.close();
            return;
        }
    }

    public String getDBPath(String date) {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append("/").append(date).append("/counter");
        return sb.toString();
    }

    private DailyCounterWR$() {
        MODULE$ = this;
        this.queue = new RequestQueue(DBCtr$.MODULE$.MAX_QUE_SIZE());
        this.prefix = "5m";
        this.lastDateInt = 0;
        this.index = null;
        this.writer = null;
        ThreadScala$.MODULE$.start("scouter.server.db.DailyCounterWR", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                while (true) {
                    DailyCounterWR.Data counterData;
                    block7: {
                        if (!DBCtr$.MODULE$.running()) {
                            DailyCounterWR$.MODULE$.close();
                            return;
                        }
                        counterData = DailyCounterWR$.MODULE$.queue().get();
                        try {
                            if (DailyCounterWR$.MODULE$.lastDateInt() != counterData.date()) {
                                DailyCounterWR$.MODULE$.lastDateInt_$eq(counterData.date());
                                DailyCounterWR$.MODULE$.close();
                                DailyCounterWR$.MODULE$.open(Integer.toString(counterData.date()));
                            }
                            if (DailyCounterWR$.MODULE$.index() == null || DailyCounterWR$.MODULE$.writer() == null || DailyCounterWR$.MODULE$.writer().dataFile() == null || DailyCounterWR$.MODULE$.index().index() == null) {
                                OftenAction$.MODULE$.act("DailyCounterWR", 10, (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        DailyCounterWR$.MODULE$.closeForce();
                                        DailyCounterWR$.MODULE$.queue().clear();
                                        DailyCounterWR$.MODULE$.lastDateInt_$eq(0);
                                    }
                                });
                                Logger$.MODULE$.println("S122", 10, "can't open db");
                            }
                            break block7;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        continue;
                    }
                    byte[] key = counterData.key().getBytesKey();
                    long dataOffset = DailyCounterWR$.MODULE$.index().get(key);
                    if (dataOffset >= 0L) {
                        DailyCounterWR$.MODULE$.writer().write(dataOffset, counterData.key(), counterData.hhmm(), counterData.value());
                        continue;
                    }
                    if (counterData.value().getValueType() == 0) continue;
                    dataOffset = DailyCounterWR$.MODULE$.writer().writeNew(counterData.key(), counterData.hhmm(), counterData.value());
                    DailyCounterWR$.MODULE$.index().set(key, dataOffset);
                }
            }
        });
    }
}

