/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.server.db.DBCtr$;
import scouter.server.util.EnumerScala$;
import scouter.server.util.ThreadScala$;
import scouter.server.util.cardinality.HyperLogLog;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.Hexa32;
import scouter.util.IntKeyLinkedMap;
import scouter.util.ThreadUtil;

public final class VisitorHourlyDB$ {
    public static final VisitorHourlyDB$ MODULE$;
    private final int rsd;
    private long lastFlush;
    private final IntKeyLinkedMap<HyperLogLog> objHashHyperTable;

    static {
        new VisitorHourlyDB$();
    }

    public int rsd() {
        return this.rsd;
    }

    private long lastFlush() {
        return this.lastFlush;
    }

    private void lastFlush_$eq(long x$1) {
        this.lastFlush = x$1;
    }

    public void scouter$server$db$VisitorHourlyDB$$flush() {
        long now = System.currentTimeMillis();
        if (now - this.lastFlush() >= 10000L) {
            this.lastFlush_$eq(now);
            EnumerScala$.MODULE$.foreach(this.objHashHyperTable().keys(), (Function1<Object, Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(int h) {
                    this.apply$mcVI$sp(h);
                }

                public void apply$mcVI$sp(int h) {
                    try {
                        HyperLogLog hhl = VisitorHourlyDB$.MODULE$.objHashHyperTable().get(h);
                        if (hhl != null && hhl.dirty) {
                            hhl.dirty = false;
                            VisitorHourlyDB$.MODULE$.scouter$server$db$VisitorHourlyDB$$save(VisitorHourlyDB$.MODULE$.scouter$server$db$VisitorHourlyDB$$getFileName(Hexa32.toString32(h)), hhl);
                        }
                    }
                    catch (Throwable throwable) {}
                }
            });
        }
    }

    public IntKeyLinkedMap<HyperLogLog> objHashHyperTable() {
        return this.objHashHyperTable;
    }

    public HyperLogLog getNewObject(int objHash) {
        Object object;
        HyperLogLog h = this.objHashHyperTable().get(objHash);
        if (h == null) {
            h = this.load(DateUtil.yyyymmdd(), this.scouter$server$db$VisitorHourlyDB$$getFileName(Hexa32.toString32(objHash)));
            if (h == null) {
                h = new HyperLogLog(this.rsd());
            }
            object = this.objHashHyperTable().put(objHash, h);
        } else {
            object = BoxedUnit.UNIT;
        }
        h.dirty = true;
        return h;
    }

    private HyperLogLog load(String date, String name) {
        return this.scouter$server$db$VisitorHourlyDB$$load(date, System.currentTimeMillis(), name);
    }

    public HyperLogLog scouter$server$db$VisitorHourlyDB$$load(String date, long time, String name) {
        HyperLogLog hyperLogLog;
        String path = this.getDBPath(date);
        File f = new File(path);
        Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
        File file = new File(new StringBuilder().append((Object)path).append((Object)"/").append((Object)this.getFileName(name, time)).append((Object)".usr").toString());
        if (file.exists()) {
            byte[] bytes = FileUtil.readAll(file);
            hyperLogLog = HyperLogLog.build(bytes);
        } else {
            hyperLogLog = null;
        }
        return hyperLogLog;
    }

    public void scouter$server$db$VisitorHourlyDB$$save(String name, HyperLogLog hll) {
        String path = this.getDBPath(DateUtil.yyyymmdd());
        File f = new File(path);
        Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
        File file = new File(new StringBuilder().append((Object)path).append((Object)"/").append((Object)name).append((Object)".usr").toString());
        FileUtil.save(file, hll.getBytes());
    }

    private String getDBPath(String date) {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append("/").append(date).append("/visit_hourly");
        return sb.toString();
    }

    public String scouter$server$db$VisitorHourlyDB$$getFileName(String name) {
        return this.getFileName(name, System.currentTimeMillis());
    }

    private String getFileName(String name, long time) {
        return new StringBuilder().append((Object)name).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)DateUtil.getHour(time))).toString();
    }

    public long getVisitorObject(int objHash) {
        HyperLogLog h = this.objHashHyperTable().get(objHash);
        if (h == null) {
            h = this.load(DateUtil.yyyymmdd(), Hexa32.toString32(objHash));
        }
        return h == null ? 0L : h.cardinality();
    }

    public long getVisitorObject(String date, long time, int objHash) {
        HyperLogLog h = this.scouter$server$db$VisitorHourlyDB$$load(date, time, Hexa32.toString32(objHash));
        return h == null ? 0L : h.cardinality();
    }

    public long getMergedVisitorObject(String date, long time, ListValue objHashLv) {
        long cardinality = 0L;
        HyperLogLog totalVisitor = new HyperLogLog(this.rsd());
        EnumerScala$.MODULE$.foreach(objHashLv, new Serializable(date, time, totalVisitor){
            public static final long serialVersionUID = 0L;
            private final String date$1;
            private final long time$1;
            private final HyperLogLog totalVisitor$1;

            public final void apply(DecimalValue obj) {
                HyperLogLog h = VisitorHourlyDB$.MODULE$.scouter$server$db$VisitorHourlyDB$$load(this.date$1, this.time$1, Hexa32.toString32(obj.intValue()));
                if (h != null) {
                    this.totalVisitor$1.addAll(h);
                }
            }
            {
                this.date$1 = date$1;
                this.time$1 = time$1;
                this.totalVisitor$1 = totalVisitor$1;
            }
        });
        return totalVisitor.cardinality();
    }

    private VisitorHourlyDB$() {
        MODULE$ = this;
        this.rsd = 20;
        ThreadScala$.MODULE$.startDaemon("scouter.server.db.VisitorHourlyDB", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int hourUnit = DateUtil.getHour(System.currentTimeMillis());
                while (DBCtr$.MODULE$.running()) {
                    int currentHour = DateUtil.getHour(System.currentTimeMillis());
                    if (hourUnit != currentHour) {
                        hourUnit = currentHour;
                        VisitorHourlyDB$.MODULE$.objHashHyperTable().clear();
                    }
                    VisitorHourlyDB$.MODULE$.scouter$server$db$VisitorHourlyDB$$flush();
                    ThreadUtil.sleep(1000L);
                }
            }
        });
        this.lastFlush = System.currentTimeMillis();
        this.objHashHyperTable = new IntKeyLinkedMap().setMax(500);
    }
}

