/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.counter;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.CounterKey;
import scouter.lang.value.Value;
import scouter.server.db.counter.DailyCounterData$;
import scouter.server.db.counter.DailyCounterUtils$;
import scouter.util.FileUtil;
import scouter.util.IClose;

@ScalaSignature(bytes="\u0006\u0001\u0005Es!B\u0001\u0003\u0011\u0003Y\u0011\u0001\u0005#bS2L8i\\;oi\u0016\u0014H)\u0019;b\u0015\t\u0019A!A\u0004d_VtG/\u001a:\u000b\u0005\u00151\u0011A\u00013c\u0015\t9\u0001\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0013\u000591oY8vi\u0016\u00148\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u0011\t\u0006LG._\"pk:$XM\u001d#bi\u0006\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0004\u001b\u001b\t\u0007I\u0011A\u000e\u0002\u000bQ\f'\r\\3\u0016\u0003q\u0001B!\b\u0012%W5\taD\u0003\u0002 A\u0005!Q\u000f^5m\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\u0013!\u000b7\u000f\u001b;bE2,\u0007CA\u0013)\u001d\t\tb%\u0003\u0002(%\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9#\u0003\u0005\u0002\rY\u0019!aB\u0001\u0001.'\rac\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0001\nA\u0001\\1oO&\u00111\u0007\r\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005U:T\"\u0001\u001c\u000b\u0005}A\u0011B\u0001\u001d7\u0005\u0019I5\t\\8tK\"A!\b\fB\u0001B\u0003%A%\u0001\u0005gS2,g*Y7f\u0011!aDF!A!\u0002\u0013!\u0013\u0001B7pI\u0016DQa\u0006\u0017\u0005\u0002y\"2aK A\u0011\u0015QT\b1\u0001%\u0011\u0015aT\b1\u0001%\u0011\u001d\u0011E\u00061A\u0005\u0002\r\u000b\u0001B]3ge\u0016t7-Z\u000b\u0002\tB\u0011\u0011#R\u0005\u0003\rJ\u00111!\u00138u\u0011\u001dAE\u00061A\u0005\u0002%\u000bAB]3ge\u0016t7-Z0%KF$\"AS'\u0011\u0005EY\u0015B\u0001'\u0013\u0005\u0011)f.\u001b;\t\u000f9;\u0015\u0011!a\u0001\t\u0006\u0019\u0001\u0010J\u0019\t\rAc\u0003\u0015)\u0003E\u0003%\u0011XM\u001a:f]\u000e,\u0007\u0005C\u0004SY\u0001\u0007I\u0011A*\u0002\u0011\u0011\fG/\u0019$jY\u0016,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/\u0002\n!![8\n\u0005e3&\u0001\u0005*b]\u0012|W.Q2dKN\u001ch)\u001b7f\u0011\u001dYF\u00061A\u0005\u0002q\u000bA\u0002Z1uC\u001aKG.Z0%KF$\"AS/\t\u000f9S\u0016\u0011!a\u0001)\"1q\f\fQ!\nQ\u000b\u0011\u0002Z1uC\u001aKG.\u001a\u0011\t\u000b\u0005dC\u0011\t2\u0002\u000b\rdwn]3\u0015\u0003)CQ\u0001\u001a\u0017\u0005\u0002\t\f!b\u00197pg\u00164uN]2f\u0011\u00151G\u0006\"\u0001h\u0003\u0011\u0011X-\u00193\u0015\u0005!t\u0007cA\tjW&\u0011!N\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003#1L!!\u001c\n\u0003\t\tKH/\u001a\u0005\u0006_\u0016\u0004\r\u0001]\u0001\u0007_\u001a47/\u001a;\u0011\u0005E\t\u0018B\u0001:\u0013\u0005\u0011auN\\4\t\u000bQdC\u0011A;\u0002\u0013\u001d,GOV1mk\u0016\u001cHC\u0001<\u007f!\r\t\u0012n\u001e\t\u0003qrl\u0011!\u001f\u0006\u0003un\fQA^1mk\u0016T!!\r\u0005\n\u0005uL(!\u0002,bYV,\u0007\"B8t\u0001\u0004\u0001\bbBA\u0001Y\u0011\u0005\u00111A\u0001\tO\u0016$h+\u00197vKR)q/!\u0002\u0002\b!)qn a\u0001a\"1\u0011\u0011B@A\u0002\u0011\u000bA\u0001\u001b5n[\"9\u0011Q\u0002\u0017\u0005\u0002\u0005=\u0011!B<sSR,G#\u0003&\u0002\u0012\u0005M\u0011qDA\u0011\u0011\u0019y\u00171\u0002a\u0001a\"A\u0011QCA\u0006\u0001\u0004\t9\"A\u0002lKf\u0004B!!\u0007\u0002\u001c5\t10C\u0002\u0002\u001em\u0014!bQ8v]R,'oS3z\u0011\u001d\tI!a\u0003A\u0002\u0011CaA_A\u0006\u0001\u00049\bbBA\u0013Y\u0011\u0005\u0011qE\u0001\toJLG/\u001a(foR9\u0001/!\u000b\u0002,\u00055\u0002\u0002CA\u000b\u0003G\u0001\r!a\u0006\t\u000f\u0005%\u00111\u0005a\u0001\t\"1!0a\tA\u0002]Dq!!\r\u000eA\u0003%A$\u0001\u0004uC\ndW\r\t\u0005\n\u0003ki!\u0019!C\u0001\u0003o\tq\u0002\u001d:f\r&Dhi\u001c:Xe&$XM]\u000b\u0003\u0003s\u00012aLA\u001e\u0013\tI\u0003\u0007\u0003\u0005\u0002@5\u0001\u000b\u0011BA\u001d\u0003A\u0001(/\u001a$jq\u001a{'o\u0016:ji\u0016\u0014\b\u0005C\u0004\u0002D5!\t!!\u0012\u0002\u0019=\u0004XM\u001c$pe^\u0013\u0018\u000e^3\u0015\u0007-\n9\u0005\u0003\u0004;\u0003\u0003\u0002\r\u0001\n\u0005\b\u0003\u0017jA\u0011AA'\u0003\u0011y\u0007/\u001a8\u0015\u0007-\ny\u0005\u0003\u0004;\u0003\u0013\u0002\r\u0001\n")
public class DailyCounterData
implements IClose {
    private final String fileName;
    private int refrence;
    private RandomAccessFile dataFile;

    public static DailyCounterData open(String string) {
        return DailyCounterData$.MODULE$.open(string);
    }

    public static DailyCounterData openForWrite(String string) {
        return DailyCounterData$.MODULE$.openForWrite(string);
    }

    public static String preFixForWriter() {
        return DailyCounterData$.MODULE$.preFixForWriter();
    }

    public static Hashtable<String, DailyCounterData> table() {
        return DailyCounterData$.MODULE$.table();
    }

    public int refrence() {
        return this.refrence;
    }

    public void refrence_$eq(int x$1) {
        this.refrence = x$1;
    }

    public RandomAccessFile dataFile() {
        return this.dataFile;
    }

    public void dataFile_$eq(RandomAccessFile x$1) {
        this.dataFile = x$1;
    }

    @Override
    public void close() {
        Hashtable<String, DailyCounterData> hashtable = DailyCounterData$.MODULE$.table();
        synchronized (hashtable) {
            BoxedUnit boxedUnit;
            if (this.refrence() == 0) {
                DailyCounterData$.MODULE$.table().remove(this.fileName);
                DailyCounterData$.MODULE$.table().remove(new StringBuilder().append((Object)DailyCounterData$.MODULE$.preFixForWriter()).append((Object)this.fileName).toString());
                this.dataFile_$eq(FileUtil.close(this.dataFile()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.refrence_$eq(this.refrence() - 1);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void closeForce() {
        Hashtable<String, DailyCounterData> hashtable = DailyCounterData$.MODULE$.table();
        synchronized (hashtable) {
            DailyCounterData$.MODULE$.table().remove(this.fileName);
            DailyCounterData$.MODULE$.table().remove(new StringBuilder().append((Object)DailyCounterData$.MODULE$.preFixForWriter()).append((Object)this.fileName).toString());
            this.dataFile_$eq(FileUtil.close(this.dataFile()));
            this.refrence_$eq(0);
            return;
        }
    }

    public synchronized byte[] read(long offset) {
        try {
            this.dataFile().seek(offset);
            byte valueType = this.dataFile().readByte();
            byte timetype = this.dataFile().readByte();
            int valueLen = DailyCounterUtils$.MODULE$.getLength(valueType);
            int bucketCount = DailyCounterUtils$.MODULE$.getBucketCount(timetype);
            this.dataFile().seek(offset + 2L);
            byte[] buffer = new byte[valueLen * bucketCount];
            this.dataFile().read(buffer);
            return buffer;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public synchronized Value[] getValues(long offset) {
        try {
            this.dataFile().seek(offset);
            byte valueType = this.dataFile().readByte();
            byte timetype = this.dataFile().readByte();
            int valueLen = DailyCounterUtils$.MODULE$.getLength(valueType);
            int bucketCount = DailyCounterUtils$.MODULE$.getBucketCount(timetype);
            byte[] buffer = new byte[valueLen * bucketCount];
            this.dataFile().read(buffer);
            Value[] values = new Value[bucketCount];
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), values.length - 1).foreach$mVc$sp((Function1)new Serializable(this, valueLen, buffer, values){
                public static final long serialVersionUID = 0L;
                private final int valueLen$1;
                private final byte[] buffer$1;
                private final Value[] values$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.values$1[i] = new DataInputX(this.buffer$1, i * this.valueLen$1).readValue();
                }
                {
                    this.valueLen$1 = valueLen$1;
                    this.buffer$1 = buffer$1;
                    this.values$1 = values$1;
                }
            });
            return values;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public synchronized Value getValue(long offset, int hhmm) {
        try {
            this.dataFile().seek(offset);
            byte valueType = this.dataFile().readByte();
            byte intervalType = this.dataFile().readByte();
            int valueLen = DailyCounterUtils$.MODULE$.getLength(valueType);
            int bucketCount = DailyCounterUtils$.MODULE$.getBucketCount(intervalType);
            int bucketPos = DailyCounterUtils$.MODULE$.getBucketPos(intervalType, hhmm);
            if (bucketPos < bucketCount) {
                this.dataFile().seek(offset + 2L + (long)(valueLen * bucketPos));
                byte[] buffer = new byte[valueLen];
                this.dataFile().read(buffer);
                return new DataInputX(buffer).readValue();
            }
            return null;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(long offset, CounterKey key, int hhmm, Value value) {
        this.dataFile().seek(offset);
        byte valueType = this.dataFile().readByte();
        if (valueType != value.getValueType() && value.getValueType() != 0) {
            return;
        }
        byte timetype = this.dataFile().readByte();
        if (timetype != key.timetype) {
            return;
        }
        int valueLen = DailyCounterUtils$.MODULE$.getLength(valueType);
        int bucketPos = DailyCounterUtils$.MODULE$.getBucketPos(timetype, hhmm);
        this.dataFile().seek(offset + 2L + (long)(bucketPos * valueLen));
        this.dataFile().write(new DataOutputX().writeValue(value).toByteArray());
    }

    public long writeNew(CounterKey key, int hhmm, Value value) {
        byte valueType = value.getValueType();
        int valueLen = DailyCounterUtils$.MODULE$.getLength(valueType);
        if (valueLen <= 0) {
            return 0L;
        }
        int bucketCount = DailyCounterUtils$.MODULE$.getBucketCount(key.timetype);
        if (bucketCount <= 0) {
            return 0L;
        }
        int bucketPos = DailyCounterUtils$.MODULE$.getBucketPos(key.timetype, hhmm);
        long location = this.dataFile().length();
        this.dataFile().seek(location);
        this.dataFile().writeByte(value.getValueType());
        this.dataFile().writeByte(key.timetype);
        this.dataFile().write(new byte[valueLen * bucketCount]);
        this.dataFile().seek(location + 2L + (long)(bucketPos * valueLen));
        this.dataFile().write(new DataOutputX().writeValue(value).toByteArray());
        return location;
    }

    public DailyCounterData(String fileName, String mode) {
        this.fileName = fileName;
        this.refrence = 0;
        this.dataFile = new RandomAccessFile(new StringBuilder().append((Object)fileName).append((Object)".data").toString(), mode);
    }
}

