/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.http.model;

import java.util.HashMap;
import java.util.Map;
import scouter.lang.Counter;
import scouter.lang.CounterKey;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.DoubleValue;
import scouter.lang.value.FloatValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.NumberValue;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.ScouterTgMtConfig;
import scouter.server.core.app.MeterCounter;
import scouter.server.core.app.MeterCounterManager;
import scouter.server.core.cache.CounterTimeCache;
import scouter.server.http.model.CounterProtocol;
import scouter.server.http.model.NumberValueWithTime;
import scouter.util.HashUtil;

public class InfluxSingleLine {
    private String measurement;
    private String host;
    private String family;
    private String objType;
    private String objTypeIcon;
    private String objName;
    private int objHash;
    long receivedTime;
    long timestampOrigin;
    boolean debug;
    Map<String, String> tags;
    Map<CounterProtocol, NumberValue> numberFields = new HashMap<CounterProtocol, NumberValue>();

    private InfluxSingleLine(ScouterTgMtConfig tConfig, String measurement, Map<String, String> tags, Map<String, String> fields, long receivedTime, long timestampOrigin, boolean debug) {
        this.measurement = measurement;
        this.tags = tags;
        this.receivedTime = receivedTime;
        this.timestampOrigin = timestampOrigin;
        this.host = tConfig.toHost(tags);
        this.family = tConfig.toFamily(tags);
        this.objType = tConfig.toObjType(tags);
        this.objTypeIcon = tConfig.getObjTypeIcon();
        this.objName = tConfig.toObjName(this.host, tags);
        this.objHash = HashUtil.hash(this.objName);
        this.debug = debug;
        for (Map.Entry<String, String> field : fields.entrySet()) {
            this.addNumField(tConfig, field);
        }
    }

    private void addNumField(ScouterTgMtConfig tConfig, Map.Entry<String, String> field) {
        CounterProtocol counterProtocol = tConfig.getCounterProtocol(field.getKey());
        if (counterProtocol == null) {
            return;
        }
        String valueStr = field.getValue();
        char lastChar = valueStr.charAt(valueStr.length() - 1);
        if (lastChar == 'i') {
            long value = Long.parseLong(valueStr.substring(0, valueStr.length() - 1));
            this.numberFields.put(counterProtocol, new DecimalValue(value));
        } else if (lastChar >= '0' && lastChar <= '9') {
            this.numberFields.put(counterProtocol, new FloatValue(Float.parseFloat(valueStr)));
        } else {
            return;
        }
    }

    public static String toLineStringKey(String lineString) {
        char[] chars = lineString.toCharArray();
        int sink = 0;
        int mode = 0;
        StringBuilder lineKey = new StringBuilder(80);
        block10: for (int pos = 0; pos < lineString.length(); ++pos) {
            char c = chars[pos];
            if (mode == 0) {
                if (sink == 92) {
                    lineKey.append(c);
                    sink = 0;
                    continue;
                }
                switch (c) {
                    case '\\': {
                        sink = 92;
                        break;
                    }
                    case ' ': {
                        lineKey.append(' ');
                        ++mode;
                        break;
                    }
                    default: {
                        lineKey.append(c);
                        break;
                    }
                }
                continue;
            }
            if (mode != true) break;
            if (sink == 92) {
                lineKey.append(c);
                sink = 0;
                continue;
            }
            switch (c) {
                case '\\': {
                    sink = 92;
                    continue block10;
                }
                case ' ': {
                    ++mode;
                    continue block10;
                }
                case '=': {
                    ++mode;
                    continue block10;
                }
                case ',': {
                    ++mode;
                    continue block10;
                }
                default: {
                    lineKey.append(c);
                }
            }
        }
        return lineKey.toString();
    }

    public static InfluxSingleLine of(String lineStr, Configure configure, long receivedTime) {
        char[] chars = lineStr.toCharArray();
        int sink = 0;
        int mode = 0;
        StringBuilder measurementSb = new StringBuilder();
        StringBuilder tagKeySb = new StringBuilder();
        StringBuilder tagValueSb = new StringBuilder();
        boolean tagKeyMode = true;
        HashMap<String, String> tags = new HashMap<String, String>();
        StringBuilder fieldKeySb = new StringBuilder();
        StringBuilder fieldValueSb = new StringBuilder();
        boolean fieldKeyMode = true;
        HashMap<String, String> fields = new HashMap<String, String>();
        StringBuilder timestampSb = new StringBuilder();
        block19: for (int pos = 0; pos < lineStr.length(); ++pos) {
            char c = chars[pos];
            if (mode == 0) {
                if (sink == 92) {
                    measurementSb.append(c);
                    sink = 0;
                    continue;
                }
                switch (c) {
                    case '\\': {
                        sink = 92;
                        break;
                    }
                    case ',': {
                        ++mode;
                        break;
                    }
                    default: {
                        measurementSb.append(c);
                        break;
                    }
                }
                continue;
            }
            if (mode == 1) {
                if (sink == 92) {
                    if (tagKeyMode) {
                        tagKeySb.append(c);
                    } else {
                        tagValueSb.append(c);
                    }
                    sink = 0;
                    continue;
                }
                switch (c) {
                    case '\\': {
                        sink = 92;
                        break;
                    }
                    case ' ': {
                        ++mode;
                        if (tagKeySb.length() <= 0) continue block19;
                        tags.put(tagKeySb.toString(), tagValueSb.toString());
                        break;
                    }
                    case '=': {
                        tagKeyMode = false;
                        break;
                    }
                    case ',': {
                        tagKeyMode = true;
                        tags.put(tagKeySb.toString(), tagValueSb.toString());
                        tagKeySb = new StringBuilder();
                        tagValueSb = new StringBuilder();
                        break;
                    }
                    default: {
                        if (tagKeyMode) {
                            tagKeySb.append(c);
                            break;
                        }
                        tagValueSb.append(c);
                        break;
                    }
                }
                continue;
            }
            if (mode == 2) {
                if (sink == 92) {
                    if (fieldKeyMode) {
                        fieldKeySb.append(c);
                    } else {
                        fieldValueSb.append(c);
                    }
                    sink = 0;
                    continue;
                }
                switch (c) {
                    case '\\': {
                        if (sink == 34) continue block19;
                        sink = 92;
                        break;
                    }
                    case '\"': {
                        if (sink == 34) {
                            sink = 0;
                            break;
                        }
                        sink = 34;
                        break;
                    }
                    case ' ': {
                        if (sink == 34) continue block19;
                        ++mode;
                        if (fieldKeySb.length() <= 0) continue block19;
                        fields.put(fieldKeySb.toString(), fieldValueSb.toString());
                        break;
                    }
                    case '=': {
                        if (sink == 34) continue block19;
                        fieldKeyMode = false;
                        break;
                    }
                    case ',': {
                        if (sink == 34) continue block19;
                        fieldKeyMode = true;
                        fields.put(fieldKeySb.toString(), fieldValueSb.toString());
                        fieldKeySb = new StringBuilder();
                        fieldValueSb = new StringBuilder();
                        break;
                    }
                    default: {
                        if (sink == 34) continue block19;
                        if (fieldKeyMode) {
                            fieldKeySb.append(c);
                            break;
                        }
                        fieldValueSb.append(c);
                        break;
                    }
                }
                continue;
            }
            if (mode != 3) continue;
            timestampSb.append(c);
        }
        String measurement = measurementSb.toString();
        ScouterTgMtConfig tConfig = configure.telegrafInputConfigMap.get(measurement);
        if (tConfig == null) {
            return null;
        }
        if (!configure.input_telegraf_debug_enabled && tConfig.isDebugEnabled()) {
            Logger.println("TG006", "[line protocol received] " + lineStr);
        }
        if (!tConfig.isEnabled()) {
            return null;
        }
        if (!tConfig.isValidConfig()) {
            return null;
        }
        if (!tConfig.isTagFilterMatching(tags)) {
            return null;
        }
        try {
            return new InfluxSingleLine(tConfig, measurement, tags, fields, receivedTime, Long.parseLong(timestampSb.toString()) / 1000000L, tConfig.isDebugEnabled());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public String getHost() {
        return this.host;
    }

    public String getFamily() {
        return this.family;
    }

    public String getObjType() {
        return this.objType;
    }

    public String getObjTypeIcon() {
        return this.objTypeIcon;
    }

    public String getObjName() {
        return this.objName;
    }

    public int getObjHash() {
        return this.objHash;
    }

    public long getReceivedTime() {
        return this.receivedTime;
    }

    public long getTimestampOrigin() {
        return this.timestampOrigin;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Map<CounterProtocol, NumberValue> getNumberFields() {
        return this.numberFields;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ObjectPack toObjectPack(String address, int deadTime) {
        ObjectPack objPack = new ObjectPack();
        objPack.objHash = this.objHash;
        objPack.objName = this.objName;
        objPack.objType = this.objType;
        objPack.address = address;
        MapValue tagMap = new MapValue();
        tagMap.put("deadTime", deadTime);
        objPack.tags = tagMap;
        return objPack;
    }

    public PerfCounterPack toPerfCounterPack() {
        PerfCounterPack perfPack = new PerfCounterPack();
        perfPack.time = this.receivedTime;
        perfPack.timetype = 1;
        perfPack.objName = this.objName;
        for (Map.Entry<CounterProtocol, NumberValue> counterValueEntry : this.numberFields.entrySet()) {
            Counter deltaCounter;
            CounterProtocol counterProtocol = counterValueEntry.getKey();
            Counter normalCounter = counterProtocol.toNormalCounter(this.tags);
            NumberValue counterValue = counterValueEntry.getValue();
            if (normalCounter != null) {
                if (counterProtocol.getNormalizeSec() > 0 && !counterProtocol.hasDeltaCounter()) {
                    MeterCounter meterCounter = MeterCounterManager.getInstance().getMeterCounter(this.objHash, normalCounter.getName());
                    meterCounter.add(counterValue.doubleValue());
                    double valueNormalized = meterCounter.getAvg(counterProtocol.getNormalizeSec());
                    perfPack.data.put(normalCounter.getName(), new DoubleValue(valueNormalized));
                } else {
                    perfPack.data.put(normalCounter.getName(), counterValue);
                }
            }
            if ((deltaCounter = counterProtocol.toDeltaCounter(this.tags)) == null) continue;
            CounterKey counterKey = new CounterKey(this.objHash, deltaCounter.getName(), 1);
            NumberValueWithTime prev = CounterTimeCache.get(counterKey);
            if (prev != null) {
                float deltaPerSec;
                switch (counterValue.getValueType()) {
                    case 20: {
                        long delta = counterValue.longValue() - prev.getValue().longValue();
                        deltaPerSec = (float)delta * 1000.0f / (float)(this.timestampOrigin - prev.getTime());
                        break;
                    }
                    default: {
                        float delta_f = counterValue.floatValue() - prev.getValue().floatValue();
                        deltaPerSec = delta_f * 1000.0f / (float)(this.timestampOrigin - prev.getTime());
                    }
                }
                if (counterProtocol.getNormalizeSec() > 0) {
                    MeterCounter meterCounter = MeterCounterManager.getInstance().getMeterCounter(this.objHash, deltaCounter.getName());
                    meterCounter.add(deltaPerSec);
                    deltaPerSec = (float)meterCounter.getAvg(counterProtocol.getNormalizeSec());
                } else {
                    Configure conf = Configure.getInstance();
                    if (conf.input_telegraf_delta_counter_normalize_default) {
                        MeterCounter meterCounter = MeterCounterManager.getInstance().getMeterCounter(this.objHash, deltaCounter.getName());
                        meterCounter.add(deltaPerSec);
                        deltaPerSec = (float)meterCounter.getAvg(conf.input_telegraf_delta_counter_normalize_default_seconds);
                    }
                }
                perfPack.data.put(deltaCounter.getName(), new FloatValue(deltaPerSec));
            }
            CounterTimeCache.put(counterKey, new NumberValueWithTime(counterValue, this.timestampOrigin));
        }
        return perfPack;
    }

    public String toString() {
        return "InfluxSingleLine{measurement='" + this.measurement + '\'' + ", host='" + this.host + '\'' + ", objType='" + this.objType + '\'' + ", objName='" + this.objName + '\'' + ", objHash=" + this.objHash + ", receivedTime=" + this.receivedTime + ", timestampOrigin=" + this.timestampOrigin + ", tags=" + this.tags + ", numberFields=" + this.numberFields + '}';
    }
}

