/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service.handle;

import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.server.core.AgentManager$;
import scouter.server.db.StackAnalyzerDB$;
import scouter.server.netio.AgentCall$;
import scouter.server.netio.service.anotation.ServiceHandler;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u001b\t!2\u000b^1dW\u0006s\u0017\r\\={KJ\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\r!\fg\u000e\u001a7f\u0015\t)a!A\u0004tKJ4\u0018nY3\u000b\u0005\u001dA\u0011!\u00028fi&|'BA\u0005\u000b\u0003\u0019\u0019XM\u001d<fe*\t1\"A\u0004tG>,H/\u001a:\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012\u0001\u0002:fC\u0012$B\u0001H\u0010(YA\u0011q\"H\u0005\u0003=A\u0011A!\u00168ji\")\u0001%\u0007a\u0001C\u0005\u0019A-\u001b8\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011R\u0011AA5p\u0013\t13E\u0001\u0006ECR\f\u0017J\u001c9vibCQ\u0001K\rA\u0002%\nA\u0001Z8viB\u0011!EK\u0005\u0003W\r\u00121\u0002R1uC>+H\u000f];u1\")Q&\u0007a\u0001]\u0005)An\\4j]B\u0011qbL\u0005\u0003aA\u0011qAQ8pY\u0016\fg\u000e\u000b\u0003\u001aeaJ\u0004CA\u001a7\u001b\u0005!$BA\u001b\u0005\u0003%\tgn\u001c;bi&|g.\u0003\u00028i\tq1+\u001a:wS\u000e,\u0007*\u00198eY\u0016\u0014\u0018!\u0002<bYV,\u0017%\u0001\u001e\u0002%\u001d+EkX*U\u0003\u000e[u,\u0011(B\u0019fSVI\u0015\u0005\u0006y\u0001!\t!P\u0001\ne\u0016\fG-\u00138eKb$B\u0001\b @\u0001\")\u0001e\u000fa\u0001C!)\u0001f\u000fa\u0001S!)Qf\u000fa\u0001]!\"1H\r\u001dCC\u0005\u0019\u0015aD$F)~\u001bF+Q\"L?&sE)\u0012-\t\u000b\u0015\u0003A\u0011\u0001$\u0002\u0017Q,(O\\(o'R\f7m\u001b\u000b\u00059\u001dC\u0015\nC\u0003!\t\u0002\u0007\u0011\u0005C\u0003)\t\u0002\u0007\u0011\u0006C\u0003.\t\u0002\u0007a\u0006\u000b\u0003EeaZ\u0015%\u0001'\u0002\u0013A\u001bF+Q\"L?>s\u0005")
public class StackAnalyzerService {
    @ServiceHandler(value="GET_STACK_ANALYZER")
    public void read(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        String objName = param.getText("objName");
        long from = param.getLong("from");
        long to = param.getLong("to");
        Serializable handler = new Serializable(this, dout){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$1;

            public final DataOutputX apply(long time, byte[] data) {
                this.dout$1.writeByte(3);
                return this.dout$1.write(data);
            }
            {
                this.dout$1 = dout$1;
            }
        };
        if (from > 0L && to > from) {
            StackAnalyzerDB$.MODULE$.read(objName, from, to, (Function2<Object, byte[], Object>)handler);
            return;
        }
        String date = param.getText("date");
        int hour = CastUtil.cint(param.get("hour"));
        if (date == null) {
            return;
        }
        from = DateUtil.yyyymmdd(date) + (long)(hour * 3600 * 1000);
        to = from + 3600000L;
        StackAnalyzerDB$.MODULE$.read(objName, from, to, (Function2<Object, byte[], Object>)handler);
    }

    @ServiceHandler(value="GET_STACK_INDEX")
    public void readIndex(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        String objName = param.getText("objName");
        long from = param.getLong("from");
        long to = param.getLong("to");
        Serializable handler = new Serializable(this, dout){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$2;

            public final DataOutputX apply(long time) {
                this.dout$2.writeByte(3);
                return this.dout$2.writeLong(time);
            }
            {
                this.dout$2 = dout$2;
            }
        };
        if (from > 0L && to > from) {
            StackAnalyzerDB$.MODULE$.read(objName, from, to, (Function1<Object, Object>)handler);
            return;
        }
        String date = param.getText("date");
        int hour = CastUtil.cint(param.get("hour"));
        if (date == null) {
            return;
        }
        from = DateUtil.yyyymmdd(date) + (long)(hour * 3600 * 1000);
        to = from + 3600000L;
        StackAnalyzerDB$.MODULE$.read(objName, from, to, (Function1<Object, Object>)handler);
    }

    @ServiceHandler(value="PSTACK_ON")
    public void turnOnStack(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        int objHash = param.getInt("objHash");
        ObjectPack o = AgentManager$.MODULE$.getAgent(objHash);
        MapPack p = AgentCall$.MODULE$.call(o, "PSTACK_ON", param);
        if (p != null) {
            dout.writeByte(3);
            dout.writePack(p);
        }
    }
}

