/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.plugin;

import scouter.lang.pack.AlertPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.pack.SummaryPack;
import scouter.lang.pack.TextPack;
import scouter.lang.pack.XLogPack;
import scouter.lang.pack.XLogProfilePack;
import scouter.server.Logger;
import scouter.server.plugin.IAlert;
import scouter.server.plugin.ICounter;
import scouter.server.plugin.IObject;
import scouter.server.plugin.ISummary;
import scouter.server.plugin.IText;
import scouter.server.plugin.IXLog;
import scouter.server.plugin.IXLogProfile;
import scouter.server.plugin.PlugInLoader;
import scouter.server.plugin.builtin.BuiltInPluginManager;

public class PlugInManager {
    static IXLog xlog;
    static IXLog xlogdb;
    static IXLogProfile xlogProfiles;
    static IObject objects;
    static IAlert alerts;
    static ICounter counters;
    static ISummary summary;
    static IText text;

    public static void xlog(XLogPack m) {
        BuiltInPluginManager.invokeAllPlugins("pluginServerXLog", m);
        if (xlog != null) {
            try {
                xlog.process(m);
            }
            catch (Throwable t) {
                Logger.printStackTrace("PL001", t);
            }
        }
    }

    public static void xlogdb(XLogPack m) {
        if (xlogdb != null) {
            try {
                xlogdb.process(m);
            }
            catch (Throwable t) {
                Logger.printStackTrace("PL002", t);
            }
        }
    }

    public static void profile(XLogProfilePack m) {
        BuiltInPluginManager.invokeAllPlugins("pluginServerProfile", m);
        if (xlogProfiles != null) {
            try {
                xlogProfiles.process(m);
            }
            catch (Throwable t) {
                Logger.printStackTrace("PL003", t);
            }
        }
    }

    public static void active(ObjectPack p) {
        BuiltInPluginManager.invokeAllPlugins("pluginServerObject", p);
        if (objects != null) {
            try {
                objects.process(p);
            }
            catch (Throwable t) {
                Logger.printStackTrace("PL004", t);
            }
        }
    }

    public static void alert(AlertPack p) {
        BuiltInPluginManager.invokeAllPlugins("pluginServerAlert", p);
        if (alerts != null) {
            try {
                alerts.process(p);
            }
            catch (Throwable t) {
                Logger.printStackTrace("PL005", t);
            }
        }
    }

    public static void counter(PerfCounterPack p) {
        BuiltInPluginManager.invokeAllPlugins("pluginServerCounter", p);
        if (counters != null) {
            try {
                counters.process(p);
            }
            catch (Throwable t) {
                Logger.printStackTrace("PL006", t);
            }
        }
    }

    public static void summary(SummaryPack p) {
        BuiltInPluginManager.invokeAllPlugins("pluginServerSummary", p);
        if (summary != null) {
            try {
                summary.process(p);
            }
            catch (Throwable t) {
                Logger.printStackTrace("PL007", t);
            }
        }
    }

    public static void text(TextPack p) {
        BuiltInPluginManager.invokeAllPlugins("pluginServerText", p);
        if (text != null) {
            try {
                text.process(p);
            }
            catch (Throwable t) {
                Logger.printStackTrace("PL008", t);
            }
        }
    }

    public static void load() {
        PlugInLoader.getInstance();
    }
}

