/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.plugin;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import scouter.lang.conf.ConfigDesc;
import scouter.lang.conf.Internal;
import scouter.lang.conf.ParamDesc;
import scouter.lang.pack.AlertPack;
import scouter.server.Logger;
import scouter.server.core.AlertCore;
import scouter.server.db.KeyValueStoreRW;
import scouter.server.db.TextRD;
import scouter.util.HashUtil;
import scouter.util.Hexa32;

public class PluginHelper {
    private static final String NO_DATE = "00000000";
    private static Map<String, AccessibleObject> reflCache = Collections.synchronizedMap(new LinkedHashMap(100));
    private static PluginHelper instance = new PluginHelper();
    private static List<Desc> pluginHelperDesc;

    private PluginHelper() {
    }

    public static PluginHelper getInstance() {
        return instance;
    }

    @ConfigDesc(value="logging")
    public void log(Object c) {
        Logger.println(c);
    }

    @ConfigDesc(value="System.out.println")
    public void println(Object c) {
        System.out.println(c);
    }

    @ConfigDesc(value="url encoding")
    public String urlEncode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8");
    }

    @ConfigDesc(value="url decoding")
    public String urlDecode(String s) throws UnsupportedEncodingException {
        return URLDecoder.decode(s, "UTF-8");
    }

    @ConfigDesc(value="make shorten url.")
    public String toShortenUrl(String producerUrl, String urlToShortening) throws UnsupportedEncodingException {
        String shorten = Hexa32.toString32(HashUtil.hash(urlToShortening));
        KeyValueStoreRW.set("shortner", shorten, urlToShortening);
        return producerUrl + "/" + shorten;
    }

    @ConfigDesc(value="get NumberFormatter set fraction 1")
    public NumberFormat getNumberFormatter() {
        return this.getNumberFormatter(1);
    }

    @ConfigDesc(value="get NumberFormatter set the fraction")
    @ParamDesc(value="int fractionDigits")
    public NumberFormat getNumberFormatter(int fractionDigits) {
        NumberFormat f = NumberFormat.getInstance();
        f.setMaximumFractionDigits(fractionDigits);
        return f;
    }

    @ConfigDesc(value="format the number as fraction 1")
    public String formatNumber(float f) {
        return this.formatNumber(f, 1);
    }

    @ConfigDesc(value="format the number as given fraction")
    @ParamDesc(value="float f, int fractionDigits")
    public String formatNumber(float f, int fractionDigits) {
        return this.getNumberFormatter(fractionDigits).format(f);
    }

    @ConfigDesc(value="format the number as fraction 1")
    public String formatNumber(double v) {
        return this.formatNumber(v, 1);
    }

    @ConfigDesc(value="format the number as given fraction")
    @ParamDesc(value="double v, int fractionDigits")
    public String formatNumber(double v, int fractionDigits) {
        return this.getNumberFormatter(fractionDigits).format(v);
    }

    @ConfigDesc(value="format the number as fraction 1")
    public String formatNumber(int v) {
        return this.formatNumber(v, 1);
    }

    @ConfigDesc(value="format the number as given fraction")
    @ParamDesc(value="int v, int fractionDigits")
    public String formatNumber(int v, int fractionDigits) {
        return this.getNumberFormatter(fractionDigits).format(v);
    }

    @ConfigDesc(value="format the number as fraction 1")
    public String formatNumber(long v) {
        return this.formatNumber(v, 1);
    }

    @ConfigDesc(value="format the number as given fraction")
    @ParamDesc(value="long v, int fractionDigits")
    public String formatNumber(long v, int fractionDigits) {
        return this.getNumberFormatter(fractionDigits).format(v);
    }

    @ConfigDesc(value="alert as info level")
    @ParamDesc(value="int objHash, String objType, String title, String message")
    public void alertInfo(int objHash, String objType2, String title, String message) {
        this.alert((byte)0, objHash, objType2, title, message);
    }

    @ConfigDesc(value="alert as warn level")
    @ParamDesc(value="int objHash, String objType, String title, String message")
    public void alertWarn(int objHash, String objType2, String title, String message) {
        this.alert((byte)1, objHash, objType2, title, message);
    }

    @ConfigDesc(value="alert as error level")
    @ParamDesc(value="int objHash, String objType, String title, String message")
    public void alertError(int objHash, String objType2, String title, String message) {
        this.alert((byte)2, objHash, objType2, title, message);
    }

    @ConfigDesc(value="alert as fatal level")
    @ParamDesc(value="int objHash, String objType, String title, String message")
    public void alertFatal(int objHash, String objType2, String title, String message) {
        this.alert((byte)3, objHash, objType2, title, message);
    }

    @ConfigDesc(value="make hashMap easily")
    @ParamDesc(value="String[] keyValueArray")
    public HashMap<String, String> toMap(String[] keyValueArray) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keyValueArray.length; i += 2) {
            map.put(keyValueArray[i], keyValueArray[i + 1]);
        }
        return map;
    }

    @ConfigDesc(value="request http get")
    @ParamDesc(value="String url, Map<String, String> paramMap")
    public void httpGet(String _url, Map<String, String> paramMap) {
        this.httpGet(_url, paramMap, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigDesc(value="request http get")
    @ParamDesc(value="String url, Map<String, String> paramMap, int timeoutMillis")
    public void httpGet(String _url, Map<String, String> paramMap, int timeoutMillis) {
        CloseableHttpResponse response = null;
        try {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(timeoutMillis).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            HttpGet httpGet = new HttpGet(_url + "?" + this.getParamsString(paramMap));
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Internal
    public String getParamsString(Map<String, String> params) throws UnsupportedEncodingException {
        if (params == null || params.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            result.append("&");
        }
        String resultString = result.toString();
        return resultString.length() > 0 ? resultString.substring(0, resultString.length() - 1) : resultString;
    }

    @Internal
    public void alert(byte level, int objHash, String objType2, String title, String message) {
        AlertPack p = new AlertPack();
        p.time = System.currentTimeMillis();
        p.level = level;
        p.objHash = objHash;
        p.objType = objType2;
        p.title = title;
        p.message = message;
        AlertCore.add(p);
    }

    @Internal
    public String getErrorString(int hash) {
        return this.getErrorString(NO_DATE, hash);
    }

    @Internal
    public String getErrorString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "error", hash);
    }

    @Internal
    public String getApicallString(int hash) {
        return this.getApicallString(NO_DATE, hash);
    }

    @Internal
    public String getApicallString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "apicall", hash);
    }

    @Internal
    public String getMethodString(int hash) {
        return this.getMethodString(NO_DATE, hash);
    }

    @Internal
    public String getMethodString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "method", hash);
    }

    @Internal
    public String getServiceString(int hash) {
        return this.getServiceString(NO_DATE, hash);
    }

    @Internal
    public String getServiceString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "service", hash);
    }

    @Internal
    public String getSqlString(int hash) {
        return this.getSqlString(NO_DATE, hash);
    }

    @Internal
    public String getSqlString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "sql", hash);
    }

    @Internal
    public String getObjectString(int hash) {
        return this.getObjectString(NO_DATE, hash);
    }

    @Internal
    public String getObjectString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "object", hash);
    }

    @Internal
    public String getRefererString(int hash) {
        return this.getRefererString(NO_DATE, hash);
    }

    @Internal
    public String getRefererString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "referer", hash);
    }

    @Internal
    public String getUserAgentString(int hash) {
        return this.getUserAgentString(NO_DATE, hash);
    }

    @Internal
    public String getUserAgentString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "ua", hash);
    }

    @Internal
    public String getUserGroupString(int hash) {
        return this.getUserGroupString(NO_DATE, hash);
    }

    @Internal
    public String getUserGroupString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "group", hash);
    }

    @Internal
    public String getCityString(int hash) {
        return this.getCityString(NO_DATE, hash);
    }

    @Internal
    public String getCityString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "city", hash);
    }

    @Internal
    public String getLoginString(int hash) {
        return this.getLoginString(NO_DATE, hash);
    }

    @Internal
    public String getLoginString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "login", hash);
    }

    @Internal
    public String getDescString(int hash) {
        return this.getDescString(NO_DATE, hash);
    }

    @Internal
    public String getDescString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "desc", hash);
    }

    @Internal
    public String getWebString(int hash) {
        return this.getWebString(NO_DATE, hash);
    }

    @Internal
    public String getWebString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "web", hash);
    }

    @Internal
    public String getHashMsgString(int hash) {
        return this.getHashMsgString(NO_DATE, hash);
    }

    @Internal
    public String getHashMsgString(String yyyymmdd, int hash) {
        return TextRD.getString(yyyymmdd, "hmsg", hash);
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object invokeMethod(Object o, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object[] objs = new Object[]{};
        return this.invokeMethod(o, methodName, objs);
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object invokeMethod(Object o, String methodName, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        int argsSize = args.length;
        StringBuilder signature = new StringBuilder(o.getClass().getName()).append(":").append(methodName).append("():");
        Class[] argClazzes = new Class[argsSize];
        for (int i = 0; i < argsSize; ++i) {
            argClazzes[i] = args[i].getClass();
        }
        return this.invokeMethod(o, methodName, argClazzes, args);
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object invokeMethod(Object o, String methodName, Class[] argTypes, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        int argsSize = args.length;
        StringBuilder signature = new StringBuilder(o.getClass().getName()).append(":").append(methodName).append("():");
        for (int i = 0; i < argsSize; ++i) {
            signature.append(argTypes[i].getName()).append("+");
        }
        Method m = (Method)reflCache.get(signature.toString());
        if (m == null) {
            m = o.getClass().getMethod(methodName, argTypes);
            reflCache.put(signature.toString(), m);
        }
        return m.invoke(o, args);
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object newInstance(String className) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.newInstance(className, Thread.currentThread().getContextClassLoader());
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object newInstance(String className, ClassLoader loader) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objs = new Object[]{};
        return this.newInstance(className, loader, objs);
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object newInstance(String className, Object[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.newInstance(className, Thread.currentThread().getContextClassLoader(), args);
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object newInstance(String className, ClassLoader loader, Object[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        int argsSize = args.length;
        Class[] argClazzes = new Class[argsSize];
        for (int i = 0; i < argsSize; ++i) {
            argClazzes[i] = args[i].getClass();
        }
        return this.newInstance(className, loader, argClazzes, args);
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object newInstance(String className, ClassLoader loader, Class[] argTypes, Object[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        int argsSize = args.length;
        StringBuilder signature = new StringBuilder(className).append(":<init>:");
        for (int i = 0; i < argsSize; ++i) {
            signature.append(argTypes[i].getName()).append("+");
        }
        Class<?> clazz = Class.forName(className, true, loader);
        Constructor<?> constructor = (Constructor<?>)reflCache.get(signature.toString());
        if (constructor == null) {
            constructor = clazz.getConstructor(argTypes);
            reflCache.put(signature.toString(), constructor);
        }
        return constructor.newInstance(args);
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object getFieldValue(Object o, String fieldName) throws InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        StringBuilder signature = new StringBuilder(o.getClass().getName()).append(":").append(fieldName).append(":");
        Field f = (Field)reflCache.get(signature.toString());
        if (f == null) {
            f = o.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            reflCache.put(signature.toString(), f);
        }
        return f.get(o);
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Class[] makeArgTypes(Class class0) {
        Class[] classes = new Class[]{class0};
        return classes;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Class[] makeArgTypes(Class class0, Class class1) {
        Class[] classes = new Class[]{class0, class1};
        return classes;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Class[] makeArgTypes(Class class0, Class class1, Class class2) {
        Class[] classes = new Class[]{class0, class1, class2};
        return classes;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Class[] makeArgTypes(Class class0, Class class1, Class class2, Class class3) {
        Class[] classes = new Class[]{class0, class1, class2, class3};
        return classes;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Class[] makeArgTypes(Class class0, Class class1, Class class2, Class class3, Class class4) {
        Class[] classes = new Class[]{class0, class1, class2, class3, class4};
        return classes;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Class[] makeArgTypes(Class class0, Class class1, Class class2, Class class3, Class class4, Class class5) {
        Class[] classes = new Class[]{class0, class1, class2, class3, class4, class5};
        return classes;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Class[] makeArgTypes(Class class0, Class class1, Class class2, Class class3, Class class4, Class class5, Class class6) {
        Class[] classes = new Class[]{class0, class1, class2, class3, class4, class5, class6};
        return classes;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Class[] makeArgTypes(Class class0, Class class1, Class class2, Class class3, Class class4, Class class5, Class class6, Class class7) {
        Class[] classes = new Class[]{class0, class1, class2, class3, class4, class5, class6, class7};
        return classes;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object[] makeArgs(Object object0) {
        Object[] objects = new Object[]{object0};
        return objects;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object[] makeArgs(Object object0, Object object1) {
        Object[] objects = new Object[]{object0, object1};
        return objects;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object[] makeArgs(Object object0, Object object1, Object object2) {
        Object[] objects = new Object[]{object0, object1, object2};
        return objects;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object[] makeArgs(Object object0, Object object1, Object object2, Object object3) {
        Object[] objects = new Object[]{object0, object1, object2, object3};
        return objects;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object[] makeArgs(Object object0, Object object1, Object object2, Object object3, Object object4) {
        Object[] objects = new Object[]{object0, object1, object2, object3, object4};
        return objects;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object[] makeArgs(Object object0, Object object1, Object object2, Object object3, Object object4, Object object5) {
        Object[] objects = new Object[]{object0, object1, object2, object3, object4, object5};
        return objects;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object[] makeArgs(Object object0, Object object1, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Object[] objects = new Object[]{object0, object1, object2, object3, object4, object5, object6};
        return objects;
    }

    @Internal
    @ConfigDesc(value="reflection util")
    public Object[] makeArgs(Object object0, Object object1, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        Object[] objects = new Object[]{object0, object1, object2, object3, object4, object5, object6, object7};
        return objects;
    }

    public static synchronized List<Desc> getPluginHelperDesc() {
        Method[] methods;
        if (pluginHelperDesc != null) {
            return pluginHelperDesc;
        }
        ArrayList<Desc> descList = new ArrayList<Desc>();
        for (Method method : methods = PluginHelper.class.getDeclaredMethods()) {
            int mod = method.getModifiers();
            if (Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            Deprecated deprecated = method.getAnnotation(Deprecated.class);
            Internal internal = method.getAnnotation(Internal.class);
            if (deprecated != null || internal != null) continue;
            ArrayList<String> typeClassNameList = new ArrayList<String>();
            Class<?>[] clazzes = method.getParameterTypes();
            ParamDesc paramDesc = method.getAnnotation(ParamDesc.class);
            if (paramDesc != null) {
                typeClassNameList.add(paramDesc.value());
            } else {
                for (Class<?> clazz : clazzes) {
                    typeClassNameList.add(clazz.getName());
                }
            }
            ConfigDesc configDesc = method.getAnnotation(ConfigDesc.class);
            Desc desc = new Desc();
            desc.methodName = method.getName();
            desc.returnTypeName = method.getReturnType().getName();
            if (configDesc != null) {
                desc.desc = configDesc.value();
            }
            desc.parameterTypeNames = typeClassNameList;
            descList.add(desc);
        }
        pluginHelperDesc = descList;
        return pluginHelperDesc;
    }

    public static class Desc {
        public String desc;
        public String methodName;
        public List<String> parameterTypeNames;
        public String returnTypeName;
    }
}

