/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;

public class CipherData {
    private Cipher enc;
    private Cipher dec;

    public CipherData(String k) {
        try {
            Key key = this.genKey(k);
            this.enc = Cipher.getInstance("DES/ECB/NoPadding");
            this.enc.init(1, key);
            this.dec = Cipher.getInstance("DES/ECB/NoPadding");
            this.dec.init(2, key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Key genKey(String k) throws GeneralSecurityException {
        byte[] host2 = (k + "012345678").getBytes();
        byte[] key = new byte[8];
        System.arraycopy(host2, 0, key, 0, 8);
        return SecretKeyFactory.getInstance("DES").generateSecret(new DESKeySpec(key));
    }

    public byte[] decode(byte[] data) {
        try {
            data = this.dec.doFinal(data);
            data = new DataInputX(data).readBlob();
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] encode(byte[] data) {
        try {
            data = new DataOutputX().writeBlob(data).toByteArray();
            byte[] plainBytes = CipherData.padding(data);
            return this.enc.doFinal(plainBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] padding(byte[] src) {
        if (src.length % 8 == 0) {
            return src;
        }
        int destlen = (src.length / 8 + 1) * 8;
        byte[] dest = new byte[destlen];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static void main(String[] args) throws Exception {
        CipherData cb = new CipherData("admin");
        String pwd = "www1234";
        for (int i = 0; i < 100; ++i) {
            byte[] org = pwd.getBytes();
            byte[] cnd = cb.encode(org);
            String rtn = new String(cb.decode(cnd));
            System.out.println("'" + pwd + "'");
            System.out.println("'" + org.length + "'");
            System.out.println("'" + cnd.length + "'");
            System.out.println("'" + rtn + "'");
        }
    }
}

