/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.task;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.ObjTypeDetector;
import scouter.agent.counter.CounterBasket;
import scouter.agent.counter.anotation.Counter;
import scouter.agent.counter.meter.MeterResource;
import scouter.agent.counter.task.AgentHeartBeat;
import scouter.lang.conf.ConfObserver;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.FloatValue;
import scouter.util.CastUtil;
import scouter.util.HashUtil;
import scouter.util.StringUtil;

public class TomcatJMXPerf {
    HashMap<MeterKey, MeterResource> meters = new HashMap();
    HashMap<MeterKey, Long> lastValues = new HashMap();
    private static HashSet<String> deltas = new HashSet();
    private MBeanServer server;
    List<MBeanObj> beanList = new ArrayList<MBeanObj>();
    public long collectCnt = 0L;
    private HashSet<String> errors = new HashSet();
    Configure conf = Configure.getInstance();

    private long getDelta(MeterKey key, Long newValue) {
        Long oldValue = this.lastValues.put(key, newValue);
        return oldValue == null ? 0L : newValue - oldValue;
    }

    private MeterResource getMeter(MeterKey key) {
        MeterResource meter = this.meters.get(key);
        if (meter == null) {
            meter = new MeterResource();
            this.meters.put(key, meter);
        }
        return meter;
    }

    @Counter
    public void process(CounterBasket pw) {
        if (!this.conf.jmx_counter_enabled || !"tomcat".equals(ObjTypeDetector.objType) && !"tomcat".equals(ObjTypeDetector.drivedType)) {
            return;
        }
        this.getMBeanServer();
        if (this.collectCnt <= 40L && this.collectCnt % 5L == 0L || ObjTypeDetector.dirtyConfig) {
            if (ObjTypeDetector.dirtyConfig) {
                AgentHeartBeat.clearSubObjects();
                ObjTypeDetector.dirtyConfig = false;
            }
            this.getMBeanList();
        }
        ++this.collectCnt;
        for (MBeanObj beanObj : this.beanList) {
            if (this.errors.contains(beanObj.attrName) || beanObj.valueType != 20) continue;
            try {
                MeterResource meter;
                MeterKey key = new MeterKey(beanObj.mbeanHash, beanObj.counter);
                long v = CastUtil.clong(this.server.getAttribute(beanObj.mbean, beanObj.attrName));
                if (deltas.contains(beanObj.counter)) {
                    v = this.getDelta(key, v);
                    meter = this.getMeter(key);
                    meter.add(v);
                    v = (long)meter.getSum(60);
                    long sum = (long)meter.getSum(300) / 5L;
                    pw.getPack(beanObj.objName, (byte)1).add(beanObj.counter, new DecimalValue(v));
                    pw.getPack(beanObj.objName, (byte)3).add(beanObj.counter, new DecimalValue(sum));
                    continue;
                }
                meter = this.getMeter(key);
                meter.add(v);
                double avg = meter.getAvg(300);
                FloatValue avgValue = new FloatValue((float)avg);
                pw.getPack(beanObj.objName, (byte)1).add(beanObj.counter, new DecimalValue(v));
                pw.getPack(beanObj.objName, (byte)3).add(beanObj.counter, avgValue);
            }
            catch (Exception e) {
                this.errors.add(beanObj.attrName);
                this.collectCnt = 0L;
                Logger.println("A902", e);
            }
        }
    }

    private void getMBeanServer() {
        if (this.server == null) {
            this.server = ManagementFactory.getPlatformMBeanServer();
        }
    }

    private void getMBeanList() {
        this.beanList.clear();
        Set<ObjectName> mbeans = this.server.queryNames(null, null);
        for (ObjectName mbean : mbeans) {
            String name;
            String type = mbean.getKeyProperty("type");
            String connectionpool = mbean.getKeyProperty("connectionpool");
            if (type == null) continue;
            if ("GlobalRequestProcessor".equals(type)) {
                String port = mbean.getKeyProperty("name");
                try {
                    String objName = this.conf.getObjName() + "/" + TomcatJMXPerf.checkObjName(port);
                    String objType = this.getReqProcType();
                    AgentHeartBeat.addObject(objType, HashUtil.hash(objName), objName);
                    this.add(objName, mbean, objType, (byte)20, "bytesReceived", "BytesReceived");
                    this.add(objName, mbean, objType, (byte)20, "bytesSent", "BytesSent");
                    this.add(objName, mbean, objType, (byte)20, "errorCount", "ErrorCount");
                    this.add(objName, mbean, objType, (byte)20, "processingTime", "ProcessingTime");
                    this.add(objName, mbean, objType, (byte)20, "requestCount", "RequestCount");
                }
                catch (Exception objName) {}
                continue;
            }
            if (!"DataSource".equals(type) || connectionpool != null || !StringUtil.isNotEmpty(name = mbean.getKeyProperty("name"))) continue;
            try {
                String context = mbean.getKeyProperty("context");
                if (context != null && context.length() > 0) {
                    context = context.substring(1);
                }
                if (StringUtil.isNotEmpty(context)) {
                    name = context + "_" + name;
                }
                String objName = this.conf.getObjName() + "/" + TomcatJMXPerf.checkObjName(name);
                String objType = this.getDataSourceType();
                AgentHeartBeat.addObject(objType, HashUtil.hash(objName), objName);
                this.add(objName, mbean, objType, (byte)20, "numActive", "ConnActive");
                this.add(objName, mbean, objType, (byte)20, "numIdle", "ConnIdle");
                this.add(objName, mbean, objType, (byte)20, "maxActive", "ConnMax");
                this.add(objName, mbean, objType, (byte)20, "maxTotal", "ConnMax");
            }
            catch (Exception exception) {}
        }
    }

    private String getReqProcType() {
        if (Configure.getInstance().obj_type_inherit_to_child_enabled) {
            return Configure.getInstance().obj_type + "_req";
        }
        return "reqproc";
    }

    private String getDataSourceType() {
        if (Configure.getInstance().obj_type_inherit_to_child_enabled) {
            return Configure.getInstance().obj_type + "_ds";
        }
        return "datasource";
    }

    private void add(String objName, ObjectName mbean, String type, byte decimal, String attrName, String counterName) {
        if (this.errors.contains(attrName)) {
            return;
        }
        MBeanObj cObj = new MBeanObj(objName, mbean, type, 20, attrName, counterName);
        this.beanList.add(cObj);
    }

    private static String checkObjName(String name) {
        StringBuffer sb = new StringBuffer();
        char[] charArray = name.toCharArray();
        block4: for (int i = 0; i < charArray.length; ++i) {
            switch (charArray[i]) {
                case '-': 
                case '_': {
                    sb.append(charArray[i]);
                    continue block4;
                }
                case '/': {
                    sb.append('_');
                    continue block4;
                }
                default: {
                    if (!Character.isLetterOrDigit(charArray[i])) continue block4;
                    sb.append(charArray[i]);
                }
            }
        }
        return sb.toString();
    }

    static {
        deltas.add("BytesReceived");
        deltas.add("BytesSent");
        deltas.add("ErrorCount");
        deltas.add("ProcessingTime");
        deltas.add("RequestCount");
        ConfObserver.add("TomcatJMXPerf", new Runnable(){

            @Override
            public void run() {
                ObjTypeDetector.dirtyConfig = true;
            }
        });
    }

    class MBeanObj {
        public int mbeanHash;
        public String objName;
        public ObjectName mbean;
        public String objType;
        public byte valueType;
        public String attrName;
        public String counter;

        public MBeanObj(String objName, ObjectName mbean, String objType, byte valueType, String attrName, String counter) {
            this.objName = objName;
            this.mbean = mbean;
            this.mbeanHash = HashUtil.hash(mbean.toString());
            this.objType = objType;
            this.valueType = valueType;
            this.attrName = attrName;
            this.counter = counter;
        }

        public String toString() {
            return "MBeanObj [objName=" + this.objName + ", mbean=" + this.mbean + ", objType=" + this.objType + ", valueType=" + this.valueType + ", attrName=" + this.attrName + ", counter=" + this.counter + "]";
        }
    }

    static class MeterKey {
        int mbeanHash;
        String counter;

        public MeterKey(int mbeanHash, String counter) {
            this.mbeanHash = mbeanHash;
            this.counter = counter;
        }

        public int hashCode() {
            return this.mbeanHash ^ this.counter.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MeterKey) {
                MeterKey key = (MeterKey)obj;
                return this.mbeanHash == key.mbeanHash && this.counter.equals(key.counter);
            }
            return false;
        }
    }
}

