/*
 * Decompiled with CFR 0.152.
 */
package scouter.repack.net.bytebuddy.matcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import scouter.repack.net.bytebuddy.matcher.ElementMatcher;

public class CachingMatcher<T>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ElementMatcher<? super T> matcher;
    protected final ConcurrentMap<? super T, Boolean> map;

    public CachingMatcher(ElementMatcher<? super T> matcher, ConcurrentMap<? super T, Boolean> map) {
        this.matcher = matcher;
        this.map = map;
    }

    @Override
    public boolean matches(T target) {
        Boolean cached = (Boolean)this.map.get(target);
        if (cached == null) {
            cached = this.onCacheMiss(target);
        }
        return cached;
    }

    protected boolean onCacheMiss(T target) {
        boolean cached = this.matcher.matches(target);
        this.map.put(target, cached);
        return cached;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CachingMatcher)) {
            return false;
        }
        CachingMatcher that = (CachingMatcher)object;
        return this.matcher.equals(that.matcher);
    }

    public int hashCode() {
        return this.matcher.hashCode();
    }

    public String toString() {
        return "cached(" + this.matcher + ")";
    }

    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="Caching mechanism is not supposed to decide on equality")
    public static class WithInlineEviction<S>
    extends CachingMatcher<S> {
        private final int evictionSize;

        public WithInlineEviction(ElementMatcher<? super S> matcher, ConcurrentMap<? super S, Boolean> map, int evictionSize) {
            super(matcher, map);
            this.evictionSize = evictionSize;
        }

        @Override
        protected boolean onCacheMiss(S target) {
            if (this.map.size() >= this.evictionSize) {
                Iterator iterator = this.map.entrySet().iterator();
                iterator.next();
                iterator.remove();
            }
            return super.onCacheMiss(target);
        }
    }
}

