/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.client.thread;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.util.ThreadUtil;
import scouterx.webapp.framework.cache.XLogLoopCache;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.layer.consumer.XLogConsumer;
import scouterx.webapp.request.RealTimeXLogRequest;

public class XLogRetrieveThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(XLogRetrieveThread.class);
    private static AtomicInteger threadNumber = new AtomicInteger();
    private static final long CHECK_INTERVAL = 1000L;
    private final Server server;
    private String lastError = "";
    private long lastTime = 0L;
    private static final long EXEPTION_IGNORE_TIME = 60000L;
    private long loop = 0L;
    private int index = 0;
    private final XLogConsumer xLogConsumer;
    private XLogLoopCache xLogLoopCache;

    public XLogRetrieveThread(Server server) {
        this.server = server;
        this.xLogLoopCache = new XLogLoopCache(server, 40000);
        this.xLogConsumer = new XLogConsumer();
        this.setDaemon(true);
        this.setName("XLogThread-" + server.getName() + "-" + threadNumber.getAndIncrement());
    }

    @Override
    public void run() {
        while (true) {
            ThreadUtil.sleep((long)1000L);
            this.process();
        }
    }

    private void process() {
        if (!this.server.isOpen() || this.server.getSession() == 0L) {
            return;
        }
        try {
            RealTimeXLogRequest realTimeXLogRequest = new RealTimeXLogRequest(this.loop, this.index, this.server.getId(), Collections.emptySet());
            this.xLogConsumer.handleRealTimeXLog(realTimeXLogRequest, in -> {
                Pack p = in.readPack();
                if (p.getPackType() == 10) {
                    MapPack metaPack = (MapPack)p;
                    this.index = metaPack.getInt("index");
                    this.loop = metaPack.getInt("loop");
                } else {
                    this.xLogLoopCache.add((XLogPack)p);
                }
            });
        }
        catch (Throwable t) {
            if (t.getMessage() == null || !t.getMessage().equals(this.lastError) || System.currentTimeMillis() >= this.lastTime + 60000L) {
                this.lastError = t.getMessage();
                this.lastTime = System.currentTimeMillis();
                log.error("[XLogThread] at {}, error:{}", (Object)this.server, (Object)t.getMessage());
            }
            return;
        }
    }
}

