/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.session;

import org.apache.commons.lang3.StringUtils;
import scouter.util.Hexa32;

public class UserToken {
    String userId;
    String token;
    long footprintSec;
    int serverId;
    boolean fromSession;

    private UserToken(String id, String token, int serverId) {
        this.userId = id;
        this.token = token;
        this.footprintSec = 0L;
        this.serverId = serverId;
    }

    public String getStoreKey() {
        return this.userId;
    }

    public String toStoreValue() {
        return "V1." + this.footprintSec + "." + this.token + "." + this.userId;
    }

    public String toBearerToken() {
        return "V1." + this.token + "." + Hexa32.toString32((long)this.serverId) + "." + this.userId;
    }

    public boolean isExpired(int timeoutSec) {
        return this.footprintSec + (long)timeoutSec < System.currentTimeMillis() / 1000L;
    }

    public boolean isNotExpired(int timeoutSec) {
        return !this.isExpired(timeoutSec);
    }

    public boolean needToBeRenewed(int touchThresholdSec) {
        return this.footprintSec + (long)touchThresholdSec < System.currentTimeMillis() / 1000L;
    }

    public UserToken renew() {
        return UserToken.newToken(this.userId, this.token, this.serverId);
    }

    public static UserToken fromBearerToken(String token) {
        String[] arr = StringUtils.split((String)token, (String)".", (int)4);
        return new UserToken(arr[3], arr[1], (int)Hexa32.toLong32((String)arr[2]));
    }

    public static UserToken fromStoreValue(String token, int serverId) {
        String[] arr = StringUtils.split((String)token, (String)".", (int)4);
        UserToken stored = new UserToken(arr[3], arr[2], serverId);
        stored.setFootprintSec(Long.parseLong(arr[1]));
        return stored;
    }

    public static UserToken newToken(String id, String token, int serverId) {
        UserToken newToken = new UserToken(id, token, serverId);
        newToken.setFootprintSec(System.currentTimeMillis() / 1000L);
        return newToken;
    }

    public static UserToken fromSessionId(String sessionId) {
        UserToken newToken = new UserToken(sessionId, null, 0);
        newToken.fromSession = true;
        newToken.setFootprintSec(System.currentTimeMillis() / 1000L);
        return newToken;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getToken() {
        return this.token;
    }

    public long getFootprintSec() {
        return this.footprintSec;
    }

    public int getServerId() {
        return this.serverId;
    }

    public boolean isFromSession() {
        return this.fromSession;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setFootprintSec(long footprintSec) {
        this.footprintSec = footprintSec;
    }

    public void setServerId(int serverId) {
        this.serverId = serverId;
    }

    public void setFromSession(boolean fromSession) {
        this.fromSession = fromSession;
    }
}

