/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import scouter.lang.constants.ParamConstant;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.model.KeyValueData;

public class CustomKvStoreConsumer {
    public boolean set(String keySpace, String key, String value, Server server) {
        return this.set(keySpace, key, value, ParamConstant.TTL_PERMANENT, server);
    }

    public boolean set(String keySpace, String key, String value, long ttl, Server server) {
        Value returnValue = null;
        MapPack mapPack = new MapPack();
        mapPack.put("keySpace", keySpace);
        mapPack.put("key", key);
        mapPack.put("value", value);
        mapPack.put("ttl", ttl);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            returnValue = tcpProxy.getSingleValue("SET_CUSTOM_KV", (Pack)mapPack);
        }
        return returnValue != null ? (Boolean)returnValue.toJavaObject() : false;
    }

    public boolean setTTL(String keySpace, String key, long ttl, Server server) {
        Value returnValue = null;
        MapPack mapPack = new MapPack();
        mapPack.put("keySpace", keySpace);
        mapPack.put("key", key);
        mapPack.put("ttl", ttl);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            returnValue = tcpProxy.getSingleValue("SET_CUSTOM_TTL", (Pack)mapPack);
        }
        return returnValue != null ? (Boolean)returnValue.toJavaObject() : false;
    }

    public String get(String keySpace, String key, Server server) {
        MapPack mapPack = new MapPack();
        mapPack.put("keySpace", keySpace);
        mapPack.put("key", key);
        Value value = null;
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            value = tcpProxy.getSingleValue("GET_CUSTOM_KV", (Pack)mapPack);
        }
        return value != null ? value.toString() : null;
    }

    public List<KeyValueData> setBulk(String keySpace, Map<String, String> paramMap, Server server) {
        return this.setBulk(keySpace, paramMap, ParamConstant.TTL_PERMANENT, server);
    }

    public List<KeyValueData> setBulk(String keySpace, Map<String, String> paramMap, long ttl, Server server) {
        MapPack resultPack;
        MapPack mapPack = new MapPack();
        mapPack.put("keySpace", keySpace);
        mapPack.put("kv", (Value)MapValue.ofStringValueMap(paramMap));
        mapPack.put("ttl", ttl);
        TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);
        Object object = null;
        try {
            resultPack = (MapPack)tcpProxy.getSingle("SET_CUSTOM_KV_BULK", (Pack)mapPack);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tcpProxy != null) {
                if (object != null) {
                    try {
                        tcpProxy.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tcpProxy.close();
                }
            }
        }
        ArrayList<KeyValueData> resultList = new ArrayList<KeyValueData>();
        for (String key : resultPack.keySet()) {
            resultList.add(new KeyValueData(key, resultPack.getBoolean(key)));
        }
        return resultList;
    }

    public List<KeyValueData> getBulk(String keySpace, List<String> paramList, Server server) {
        MapPack resultPack;
        MapPack paramPack = new MapPack();
        paramPack.put("keySpace", keySpace);
        paramPack.put("key", (Value)ListValue.ofStringValueList(paramList));
        TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);
        Object object = null;
        try {
            resultPack = (MapPack)tcpProxy.getSingle("GET_CUSTOM_KV_BULK", (Pack)paramPack);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tcpProxy != null) {
                if (object != null) {
                    try {
                        tcpProxy.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tcpProxy.close();
                }
            }
        }
        ArrayList<KeyValueData> resultList = new ArrayList<KeyValueData>();
        for (String key : resultPack.keySet()) {
            resultList.add(new KeyValueData(key, resultPack.getText(key)));
        }
        return resultList;
    }
}

