/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import scouter.lang.pack.InteractionPerfCounterPack;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.model.InteractionCounterData;

public class InteractionCounterConsumer {
    public List<InteractionCounterData> retrieveRealTimeByObjType(String objType, Server server) {
        return this.retrieveRealTimeByObjTypeOrObjHashes(objType, null, server);
    }

    public List<InteractionCounterData> retrieveRealTimeByObjHashes(Set<Integer> objHashSet, Server server) {
        return this.retrieveRealTimeByObjTypeOrObjHashes(null, objHashSet, server);
    }

    private List<InteractionCounterData> retrieveRealTimeByObjTypeOrObjHashes(String objType, Set<Integer> objHashSet, Server server) {
        MapPack paramPack = new MapPack();
        paramPack.put("objType", objType);
        ListValue objHashLv = paramPack.newList("objHash");
        if (objHashSet != null) {
            for (Integer objHash : objHashSet) {
                objHashLv.add((long)objHash.intValue());
            }
        }
        ArrayList<InteractionCounterData> resultList = new ArrayList<InteractionCounterData>();
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            tcpProxy.process("INTR_COUNTER_REAL_TIME_BY_OBJ", paramPack, in -> resultList.add(InteractionCounterData.of((InteractionPerfCounterPack)in.readPack(), server.getId())));
        }
        return resultList;
    }
}

