/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import scouter.lang.pack.TextPack;
import scouterx.webapp.layer.service.DictionaryService;
import scouterx.webapp.request.DictionaryRequest;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/dictionary")
@Api(value="Dictionary")
@Singleton
@Produces(value={"application/json"})
public class DictionaryController {
    private final DictionaryService dictionaryService = new DictionaryService();

    @GET
    @Path(value="/{yyyymmdd}")
    @Consumes(value={"application/json"})
    public Response retrieveTextFromDictionary(@Valid @BeanParam DictionaryRequest dictionaryRequest) {
        StreamingOutput stream = os -> CommonResultView.jsonArrayStream(os, jsonGenerator -> this.dictionaryService.retrieveTextFromDictionary(dictionaryRequest, in -> {
            TextPack textPack = (TextPack)in.readPack();
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("textType", textPack.xtype);
            jsonGenerator.writeNumberField("dictKey", textPack.hash);
            jsonGenerator.writeStringField("text", textPack.text);
            jsonGenerator.writeEndObject();
        }));
        return Response.ok().entity((Object)stream).type("application/json").build();
    }
}

