/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model;

import java.beans.ConstructorProperties;
import scouter.lang.pack.InteractionPerfCounterPack;
import scouterx.webapp.framework.client.model.TextLoader;
import scouterx.webapp.framework.client.model.TextProxy;
import scouterx.webapp.framework.client.model.TextTypeEnum;

public class InteractionCounterData {
    public String objName;
    public String interactionType;
    public int fromObjHash;
    public String fromObjName;
    public int toObjHash;
    public String toObjName;
    public int period;
    public int count;
    public int errorCount;
    public long totalElapsed;

    public static InteractionCounterData of(InteractionPerfCounterPack p, int serverId) {
        InteractionCounterData.preLoadDictionary(p, serverId);
        return InteractionCounterData.builder().interactionType(p.interactionType).objName(p.objName).fromObjHash(p.fromHash).fromObjName(TextProxy.object.getCachedTextIfNullDefault(p.fromHash)).toObjHash(p.toHash).toObjName(TextProxy.object.getCachedTextIfNullDefault(p.toHash)).period(p.period).count(p.count).errorCount(p.errorCount).totalElapsed(p.totalElapsed).build();
    }

    private static void preLoadDictionary(InteractionPerfCounterPack pack, int serverId) {
        TextLoader loader = new TextLoader(serverId);
        loader.addTextHash(TextTypeEnum.OBJECT, pack.fromHash);
        loader.addTextHash(TextTypeEnum.OBJECT, pack.toHash);
        loader.loadAll();
    }

    @ConstructorProperties(value={"objName", "interactionType", "fromObjHash", "fromObjName", "toObjHash", "toObjName", "period", "count", "errorCount", "totalElapsed"})
    InteractionCounterData(String objName, String interactionType, int fromObjHash, String fromObjName, int toObjHash, String toObjName, int period, int count, int errorCount, long totalElapsed) {
        this.objName = objName;
        this.interactionType = interactionType;
        this.fromObjHash = fromObjHash;
        this.fromObjName = fromObjName;
        this.toObjHash = toObjHash;
        this.toObjName = toObjName;
        this.period = period;
        this.count = count;
        this.errorCount = errorCount;
        this.totalElapsed = totalElapsed;
    }

    public static InteractionCounterDataBuilder builder() {
        return new InteractionCounterDataBuilder();
    }

    public String getObjName() {
        return this.objName;
    }

    public String getInteractionType() {
        return this.interactionType;
    }

    public int getFromObjHash() {
        return this.fromObjHash;
    }

    public String getFromObjName() {
        return this.fromObjName;
    }

    public int getToObjHash() {
        return this.toObjHash;
    }

    public String getToObjName() {
        return this.toObjName;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getCount() {
        return this.count;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public long getTotalElapsed() {
        return this.totalElapsed;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public void setInteractionType(String interactionType) {
        this.interactionType = interactionType;
    }

    public void setFromObjHash(int fromObjHash) {
        this.fromObjHash = fromObjHash;
    }

    public void setFromObjName(String fromObjName) {
        this.fromObjName = fromObjName;
    }

    public void setToObjHash(int toObjHash) {
        this.toObjHash = toObjHash;
    }

    public void setToObjName(String toObjName) {
        this.toObjName = toObjName;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public void setTotalElapsed(long totalElapsed) {
        this.totalElapsed = totalElapsed;
    }

    public static class InteractionCounterDataBuilder {
        private String objName;
        private String interactionType;
        private int fromObjHash;
        private String fromObjName;
        private int toObjHash;
        private String toObjName;
        private int period;
        private int count;
        private int errorCount;
        private long totalElapsed;

        InteractionCounterDataBuilder() {
        }

        public InteractionCounterDataBuilder objName(String objName) {
            this.objName = objName;
            return this;
        }

        public InteractionCounterDataBuilder interactionType(String interactionType) {
            this.interactionType = interactionType;
            return this;
        }

        public InteractionCounterDataBuilder fromObjHash(int fromObjHash) {
            this.fromObjHash = fromObjHash;
            return this;
        }

        public InteractionCounterDataBuilder fromObjName(String fromObjName) {
            this.fromObjName = fromObjName;
            return this;
        }

        public InteractionCounterDataBuilder toObjHash(int toObjHash) {
            this.toObjHash = toObjHash;
            return this;
        }

        public InteractionCounterDataBuilder toObjName(String toObjName) {
            this.toObjName = toObjName;
            return this;
        }

        public InteractionCounterDataBuilder period(int period) {
            this.period = period;
            return this;
        }

        public InteractionCounterDataBuilder count(int count) {
            this.count = count;
            return this;
        }

        public InteractionCounterDataBuilder errorCount(int errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public InteractionCounterDataBuilder totalElapsed(long totalElapsed) {
            this.totalElapsed = totalElapsed;
            return this;
        }

        public InteractionCounterData build() {
            return new InteractionCounterData(this.objName, this.interactionType, this.fromObjHash, this.fromObjName, this.toObjHash, this.toObjName, this.period, this.count, this.errorCount, this.totalElapsed);
        }

        public String toString() {
            return "InteractionCounterData.InteractionCounterDataBuilder(objName=" + this.objName + ", interactionType=" + this.interactionType + ", fromObjHash=" + this.fromObjHash + ", fromObjName=" + this.fromObjName + ", toObjHash=" + this.toObjHash + ", toObjName=" + this.toObjName + ", period=" + this.period + ", count=" + this.count + ", errorCount=" + this.errorCount + ", totalElapsed=" + this.totalElapsed + ")";
        }
    }
}

