/*
 * Decompiled with CFR 0.152.
 */
package scouter.repack.net.bytebuddy.matcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import scouter.repack.net.bytebuddy.matcher.ElementMatcher;

public class CollectionSizeMatcher<T extends Iterable<?>>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final int size;

    public CollectionSizeMatcher(int size) {
        this.size = size;
    }

    @Override
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Iteration required to count size of an iterable")
    public boolean matches(T target) {
        if (target instanceof Collection) {
            return ((Collection)target).size() == this.size;
        }
        int size = 0;
        for (Object ignored : target) {
            ++size;
        }
        return size == this.size;
    }

    public String toString() {
        return "ofSize(" + this.size + ')';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionSizeMatcher)) {
            return false;
        }
        CollectionSizeMatcher other = (CollectionSizeMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.size == other.size;
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectionSizeMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.size;
        return result;
    }
}

