/*
 * Decompiled with CFR 0.152.
 */
package scouter.repack.net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import scouter.repack.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import scouter.repack.net.bytebuddy.matcher.ElementMatcher;
import scouter.repack.net.bytebuddy.matcher.ElementMatchers;

public class MultipleParentClassLoader
extends ClassLoader {
    private final List<? extends ClassLoader> parents;

    public MultipleParentClassLoader(List<? extends ClassLoader> parents) {
        this(ClassLoadingStrategy.BOOTSTRAP_LOADER, parents);
    }

    public MultipleParentClassLoader(ClassLoader parent, List<? extends ClassLoader> parents) {
        super(parent);
        this.parents = parents;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.parents) {
            try {
                Class<?> type = classLoader.loadClass(name);
                if (resolve) {
                    this.resolveClass(type);
                }
                return type;
            }
            catch (ClassNotFoundException ignored) {
            }
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.parents) {
            URL url = classLoader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<Enumeration<URL>> enumerations = new ArrayList<Enumeration<URL>>(this.parents.size() + 1);
        for (ClassLoader classLoader : this.parents) {
            enumerations.add(classLoader.getResources(name));
        }
        enumerations.add(super.getResources(name));
        return new CompoundEnumeration(enumerations);
    }

    public static class Builder {
        private static final int ONLY = 0;
        private final List<? extends ClassLoader> classLoaders;

        public Builder() {
            this(Collections.emptyList());
        }

        private Builder(List<? extends ClassLoader> classLoaders) {
            this.classLoaders = classLoaders;
        }

        public Builder append(Class<?> ... type) {
            return this.append((Collection<? extends Class<?>>)Arrays.asList(type));
        }

        public Builder append(Collection<? extends Class<?>> types) {
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(types.size());
            for (Class<?> type : types) {
                classLoaders.add(type.getClassLoader());
            }
            return this.append((List<? extends ClassLoader>)classLoaders);
        }

        public Builder append(ClassLoader ... classLoader) {
            return this.append(Arrays.asList(classLoader));
        }

        public Builder append(List<? extends ClassLoader> classLoaders) {
            ArrayList<? extends ClassLoader> filtered = new ArrayList<ClassLoader>(this.classLoaders.size() + classLoaders.size());
            HashSet<? extends ClassLoader> registered = new HashSet<ClassLoader>(this.classLoaders);
            filtered.addAll(this.classLoaders);
            for (ClassLoader classLoader : classLoaders) {
                if (classLoader == null || !registered.add(classLoader)) continue;
                filtered.add(classLoader);
            }
            return new Builder(filtered);
        }

        public Builder filter(ElementMatcher<? super ClassLoader> matcher) {
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(this.classLoaders.size());
            for (ClassLoader classLoader : this.classLoaders) {
                if (!matcher.matches(classLoader)) continue;
                classLoaders.add(classLoader);
            }
            return new Builder(classLoaders);
        }

        @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit user responsibility")
        public ClassLoader build() {
            return this.classLoaders.size() == 1 ? this.classLoaders.get(0) : new MultipleParentClassLoader(this.classLoaders);
        }

        public ClassLoader build(ClassLoader parent) {
            return this.classLoaders.isEmpty() || this.classLoaders.size() == 1 && this.classLoaders.contains(parent) ? parent : this.filter(ElementMatchers.not(ElementMatchers.is(parent))).doBuild(parent);
        }

        @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit user responsibility")
        private ClassLoader doBuild(ClassLoader parent) {
            return new MultipleParentClassLoader(parent, this.classLoaders);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<? extends ClassLoader> this$classLoaders = this.classLoaders;
            List<? extends ClassLoader> other$classLoaders = other.classLoaders;
            return !(this$classLoaders == null ? other$classLoaders != null : !((Object)this$classLoaders).equals(other$classLoaders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<? extends ClassLoader> $classLoaders = this.classLoaders;
            result = result * 59 + ($classLoaders == null ? 43 : ((Object)$classLoaders).hashCode());
            return result;
        }
    }

    protected static class CompoundEnumeration
    implements Enumeration<URL> {
        private static final int FIRST = 0;
        private final List<Enumeration<URL>> enumerations;
        private Enumeration<URL> currentEnumeration;

        protected CompoundEnumeration(List<Enumeration<URL>> enumerations) {
            this.enumerations = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.currentEnumeration != null && this.currentEnumeration.hasMoreElements()) {
                return true;
            }
            if (!this.enumerations.isEmpty()) {
                this.currentEnumeration = this.enumerations.remove(0);
                return this.hasMoreElements();
            }
            return false;
        }

        @Override
        @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Null reference is impossible due to element check")
        public URL nextElement() {
            if (this.hasMoreElements()) {
                return this.currentEnumeration.nextElement();
            }
            throw new NoSuchElementException();
        }
    }
}

