/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.client.model;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.TextPack;
import scouter.lang.value.ListValue;
import scouterx.webapp.framework.client.model.TextModel;
import scouterx.webapp.framework.client.model.TextTypeEnum;
import scouterx.webapp.framework.client.net.TcpProxy;

public class TextLoader {
    private static final Logger log = LoggerFactory.getLogger(TextLoader.class);
    private EnumMap<TextTypeEnum, Set<Integer>> typedHashes = new EnumMap(TextTypeEnum.class);
    private int serverId;

    public TextLoader(int serverId) {
        this.serverId = serverId;
    }

    public void addTextHash(TextTypeEnum textType, int hash) {
        if (hash == 0) {
            return;
        }
        Set hashSet = this.typedHashes.computeIfAbsent(textType, k -> new HashSet());
        hashSet.add(hash);
    }

    public boolean loadAll() {
        MapPack param = new MapPack();
        ListValue typeList = param.newList("type");
        ListValue hashList = param.newList("hash");
        for (Map.Entry<TextTypeEnum, Set<Integer>> entry : this.typedHashes.entrySet()) {
            String type = entry.getKey().getTypeName();
            for (int hash : entry.getValue()) {
                if (TextTypeEnum.of(type).getTextModel().getCachedText(hash) != null || TextModel.isScopeStarted() && TextModel.isFailedInScope(hash)) continue;
                typeList.add(type);
                hashList.add((long)hash);
            }
        }
        if (hashList.size() > 0) {
            try {
                Throwable throwable = null;
                try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(this.serverId);){
                    List<Pack> valueList = tcpProxy.process("GET_TEXT_ANY_TYPE", (Pack)param);
                    for (Pack pack : valueList) {
                        TextPack textPack = (TextPack)pack;
                        TextTypeEnum.of(textPack.xtype).getTextModel().cache(textPack);
                    }
                }
                catch (Throwable valueList) {
                    Throwable throwable2 = valueList;
                    throw valueList;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                return false;
            }
            if (TextModel.isScopeStarted()) {
                for (int i = 0; i < hashList.size(); ++i) {
                    int n = hashList.getInt(i);
                    TextModel textModel = TextTypeEnum.of(typeList.getString(i)).getTextModel();
                    if (textModel.getCachedText(n) != null) continue;
                    TextModel.addFailedList(hashList.getInt(i));
                }
            }
        }
        return true;
    }
}

