/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.client.server;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ValidationException;
import scouter.lang.pack.MapPack;
import scouter.util.HashUtil;
import scouter.util.LinkedMap;
import scouter.util.ThreadUtil;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;

public class ServerManager
extends Thread {
    private static volatile ServerManager instance;
    private LinkedMap<Integer, Server> serverMap = new LinkedMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerManager getInstance() {
        if (instance != null) return instance;
        Class<ServerManager> clazz = ServerManager.class;
        synchronized (ServerManager.class) {
            if (instance != null) return instance;
            instance = new ServerManager();
            instance.setName(ThreadUtil.getName((Thread)instance));
            instance.setDaemon(true);
            instance.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ServerManager() {
    }

    public Server addServer(Server server) {
        return (Server)this.serverMap.put((Object)server.getId(), (Object)server);
    }

    public Server getDefaultServer() {
        return (Server)this.serverMap.getFirstValue();
    }

    public boolean setDefaultServer(Server server) {
        this.serverMap.putFirst((Object)server.getId(), (Object)server);
        return true;
    }

    @Override
    public void run() {
        while (true) {
            this.syncServerTime();
            ThreadUtil.sleep((long)2000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncServerTime() {
        Enumeration servers = this.serverMap.values();
        while (servers.hasMoreElements()) {
            Server server = (Server)servers.nextElement();
            if (!server.isOpen() || server.getSession() == 0L) continue;
            TcpProxy tcp = TcpProxy.getTcpProxy(server);
            try {
                MapPack p = (MapPack)tcp.getSingle("SERVER_STATUS", null);
                if (p == null) continue;
                long time = p.getLong("time");
                if (time > 0L) {
                    server.setDelta(time);
                }
                long usedMemory = p.getLong("used");
                long totalMemory = p.getLong("total");
                server.setUsedMemory(usedMemory);
                server.setTotalMemory(totalMemory);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
            finally {
                TcpProxy.close(tcp);
            }
        }
    }

    public Server getServer(int id) {
        return (Server)this.serverMap.get((Object)id);
    }

    public Server getServer(String addr) {
        String[] iport = addr.split(":");
        if (iport == null || iport.length < 2) {
            return null;
        }
        return this.getServer(HashUtil.hash((String)(iport[0] + iport[1])));
    }

    public void removeServer(int serverId) {
        Server remove = (Server)this.serverMap.remove((Object)serverId);
        if (remove != null) {
            remove.close();
            System.out.println("Remove server : " + remove.getName());
        }
    }

    public Set<Integer> getOpenServerIdList() {
        HashSet<Integer> serverSet = new HashSet<Integer>();
        Enumeration servers = this.serverMap.values();
        while (servers.hasMoreElements()) {
            Server server = (Server)servers.nextElement();
            if (!server.isOpen()) continue;
            serverSet.add(server.getId());
        }
        return serverSet;
    }

    public List<Server> getAllServerList() {
        ArrayList<Server> serverSet = new ArrayList<Server>();
        Enumeration servers = this.serverMap.values();
        while (servers.hasMoreElements()) {
            Server server = (Server)servers.nextElement();
            serverSet.add(server);
        }
        return serverSet;
    }

    public Set<Integer> getClosedServerIdList() {
        HashSet<Integer> serverSet = new HashSet<Integer>();
        Enumeration servers = this.serverMap.values();
        while (servers.hasMoreElements()) {
            Server server = (Server)servers.nextElement();
            if (server.isOpen()) continue;
            serverSet.add(server.getId());
        }
        return serverSet;
    }

    public int getServerCount() {
        return this.serverMap.size();
    }

    public boolean isRunningServer(String ip, String port) {
        int hash = HashUtil.hash((String)(ip + port));
        Server server = (Server)this.serverMap.get((Object)hash);
        if (server == null) {
            return false;
        }
        return server.isOpen();
    }

    public void printAll() {
        System.out.println("******************************");
        System.out.println("SERVER LIST");
        System.out.println("******************************");
        Enumeration itr = this.serverMap.keys();
        while (itr.hasMoreElements()) {
            Integer key = (Integer)itr.nextElement();
            Server server = (Server)this.serverMap.get((Object)key);
            System.out.println("ID : " + key);
            System.out.println("IP : " + server.getIp());
            System.out.println("Port : " + server.getPort());
            System.out.println("Session : " + server.getSession());
            System.out.println("------------------------------------------");
        }
    }

    public void shutdown() {
        Enumeration servers = this.serverMap.values();
        while (servers.hasMoreElements()) {
            Server server = (Server)servers.nextElement();
            server.close();
        }
        this.serverMap.clear();
    }

    public Server getServerIfNullDefault(Server server) {
        if (server == null) {
            if (this.getServerCount() != 1) {
                throw new ValidationException("Multiple server connected web-app requires the server to request for.");
            }
            return this.getDefaultServer();
        }
        return server;
    }

    public Server getServerIfNullDefault(int serverId) {
        return this.getServerIfNullDefault(this.getServer(serverId));
    }
}

