/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.exception.ErrorState;
import scouterx.webapp.framework.util.ZZ;
import scouterx.webapp.model.VisitorGroup;
import scouterx.webapp.request.VisitorGroupRequest;

public class VisitorConsumer {
    public long retrieveVisitorRealTimeByObj(int objType, Server server) {
        Value value;
        MapPack param = new MapPack();
        param.put("objHash", (long)objType);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            value = tcpProxy.getSingleValue("VISITOR_REALTIME", (Pack)param);
        }
        return ((DecimalValue)value).value;
    }

    public long retrieveVisitorRealTimeByObjType(String objType, Server server) {
        Value value;
        MapPack param = new MapPack();
        param.put("objType", objType);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            value = tcpProxy.getSingleValue("VISITOR_REALTIME_TOTAL", (Pack)param);
        }
        return ((DecimalValue)value).value;
    }

    public long retrieveVisitorRealTimeByObjHashes(List<Integer> objHashes, Server server) {
        Value value;
        MapPack param = new MapPack();
        ListValue listValue = new ListValue();
        for (Integer obj : objHashes) {
            listValue.add((long)obj.intValue());
        }
        param.put("objHash", (Value)listValue);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            value = tcpProxy.getSingleValue("VISITOR_REALTIME_GROUP", (Pack)param);
        }
        return ((DecimalValue)value).value;
    }

    public long retrieveVisitorByObj(int objHash, String date, Server server) {
        Value value;
        MapPack param = new MapPack();
        param.put("objHash", (long)objHash);
        param.put("date", date);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            value = tcpProxy.getSingleValue("VISITOR_LOADDATE", (Pack)param);
        }
        return ((DecimalValue)value).value;
    }

    public long retrieveVisitorTotalByObj(String objType, String date, Server server) {
        Value value;
        MapPack param = new MapPack();
        param.put("objType", objType);
        param.put("date", date);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            value = tcpProxy.getSingleValue("VISITOR_LOADDATE_TOTAL", (Pack)param);
        }
        return ((DecimalValue)value).value;
    }

    public VisitorGroup retrieveVisitorGroupByObjHashes(VisitorGroupRequest visitorGroupRequest) {
        Pack pack;
        MapPack param = this.getVisitorGroupPack(visitorGroupRequest);
        Server server = ServerManager.getInstance().getServerIfNullDefault(visitorGroupRequest.getServerId());
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            pack = tcpProxy.getSingle("VISITOR_LOADDATE_GROUP", (Pack)param);
        }
        return VisitorGroup.of((MapPack)pack);
    }

    public List<VisitorGroup> retrieveVisitorHourlyGroupByObjHashes(VisitorGroupRequest visitorGroupRequest) {
        List<Pack> results;
        MapPack param = this.getVisitorHourlyGroupPack(visitorGroupRequest);
        Server server = ServerManager.getInstance().getServerIfNullDefault(visitorGroupRequest.getServerId());
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            results = tcpProxy.process("VISITOR_LOADHOUR_GROUP", (Pack)param);
        }
        return results.stream().map(pack -> (MapPack)pack).map(VisitorGroup::of).collect(Collectors.toList());
    }

    private MapPack getVisitorGroupPack(VisitorGroupRequest visitorGroupRequest) {
        MapPack param = new MapPack();
        ListValue listValue = new ListValue();
        String objHashes = visitorGroupRequest.getObjHashes();
        String sdate = visitorGroupRequest.getStartYmd();
        String edate = visitorGroupRequest.getEndYmd();
        List<Integer> objList = ZZ.splitParamAsInteger(objHashes);
        if (CollectionUtils.isEmpty(objList)) {
            throw ErrorState.VALIDATE_ERROR.newBizException("Query parameter 'objHashes' is required!");
        }
        for (Integer obj : objList) {
            listValue.add((long)obj.intValue());
        }
        param.put("objHash", (Value)listValue);
        param.put("sDate", sdate);
        param.put("eDate", edate);
        return param;
    }

    private MapPack getVisitorHourlyGroupPack(VisitorGroupRequest visitorGroupRequest) {
        MapPack param = new MapPack();
        ListValue listValue = new ListValue();
        String objHashes = visitorGroupRequest.getObjHashes();
        long stime = visitorGroupRequest.getStartYmdH();
        long etime = visitorGroupRequest.getEndYmdH();
        List<Integer> objList = ZZ.splitParamAsInteger(objHashes);
        if (CollectionUtils.isEmpty(objList)) {
            throw ErrorState.VALIDATE_ERROR.newBizException("Query parameter 'objHashes' is required!");
        }
        for (Integer obj : objList) {
            listValue.add((long)obj.intValue());
        }
        param.put("objHash", (Value)listValue);
        param.put("stime", stime);
        param.put("etime", etime);
        return param;
    }
}

