/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import scouterx.webapp.framework.annotation.NoAuth;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.model.countermodel.CounterModelData;
import scouterx.webapp.view.CommonResultView;
import scouterx.webapp.view.ServerView;

@Path(value="/v1/info")
@Api(value="Info")
@Singleton
@Produces(value={"application/json"})
public class InfoController {
    @NoAuth
    @GET
    @Path(value="/server")
    @Consumes(value={"application/json"})
    public CommonResultView<List<ServerView>> retrieveServers() {
        List serverList = ServerManager.getInstance().getAllServerList().stream().map(s -> new ServerView(s.getId(), s.getName(), s.getSession() != 0L, System.currentTimeMillis() - s.getDelta(), s.getVersion())).collect(Collectors.toList());
        return CommonResultView.success(serverList);
    }

    @GET
    @Path(value="/counter-model")
    @Consumes(value={"application/json"})
    public CommonResultView<CounterModelData> retrieveCounterModel(@QueryParam(value="serverId") int serverId) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        CounterModelData counterModelData = CounterModelData.of(server.getCounterEngine());
        return CommonResultView.success(counterModelData);
    }
}

