/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.request;

import java.beans.ConstructorProperties;
import java.util.Set;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.util.ZZ;

public class RealTimeXLogRequest {
    @Min(value=0L)
    @PathParam(value="xlogLoop")
    long xLogLoop;
    @Min(value=0L)
    @PathParam(value="xlogIndex")
    int xLogIndex;
    int serverId;
    @NotNull
    Set<Integer> objHashes;

    public RealTimeXLogRequest() {
    }

    @QueryParam(value="objHashes")
    public void setObjHashes(String objHashes) {
        this.objHashes = ZZ.splitParamAsIntegerSet(objHashes);
    }

    @QueryParam(value="serverId")
    public void setServerId(int serverId) {
        this.serverId = ServerManager.getInstance().getServerIfNullDefault(serverId).getId();
    }

    public long getXLogLoop() {
        return this.xLogLoop;
    }

    public int getXLogIndex() {
        return this.xLogIndex;
    }

    public int getServerId() {
        return this.serverId;
    }

    public Set<Integer> getObjHashes() {
        return this.objHashes;
    }

    public void setXLogLoop(long xLogLoop) {
        this.xLogLoop = xLogLoop;
    }

    public void setXLogIndex(int xLogIndex) {
        this.xLogIndex = xLogIndex;
    }

    public String toString() {
        return "RealTimeXLogRequest(xLogLoop=" + this.getXLogLoop() + ", xLogIndex=" + this.getXLogIndex() + ", serverId=" + this.getServerId() + ", objHashes=" + this.getObjHashes() + ")";
    }

    @ConstructorProperties(value={"xLogLoop", "xLogIndex", "serverId", "objHashes"})
    public RealTimeXLogRequest(long xLogLoop, int xLogIndex, int serverId, Set<Integer> objHashes) {
        this.xLogLoop = xLogLoop;
        this.xLogIndex = xLogIndex;
        this.serverId = serverId;
        this.objHashes = objHashes;
    }
}

