/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import java.util.List;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.util.ZZ;
import scouterx.webapp.layer.service.InteractionCounterService;
import scouterx.webapp.model.InteractionCounterData;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/interactionCounter")
@Api(value="InteractionCounter")
@Singleton
@Produces(value={"application/json"})
public class InteractionCounterController {
    @Context
    HttpServletRequest servletRequest;
    private final InteractionCounterService service = new InteractionCounterService();

    @GET
    @Path(value="/realTime/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<InteractionCounterData>> retrieveRealTimeCountersByObjType(@PathParam(value="objType") @Valid @NotNull String objType, @QueryParam(value="serverId") int serverId) {
        List<InteractionCounterData> counterList = this.service.retrieveRealTimeByObjType(objType, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(counterList);
    }

    @GET
    @Path(value="/realTime")
    @Consumes(value={"application/json"})
    public CommonResultView<List<InteractionCounterData>> retrieveRealTimeCountersByObjHashes(@QueryParam(value="objHashes") @Valid @NotNull String objHashes, @QueryParam(value="serverId") int serverId) {
        List<InteractionCounterData> counterList = this.service.retrieveRealTimeByObjHashes(ZZ.splitParamAsIntegerSet(objHashes), ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(counterList);
    }
}

