/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.request;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.exception.ErrorState;

public class SummaryRequest {
    private Server server;
    @QueryParam(value="startTimeMillis")
    private long startTimeMillis;
    @QueryParam(value="endTimeMillis")
    private long endTimeMillis;
    @QueryParam(value="startYmdHm")
    private String startYmdHm;
    @QueryParam(value="endYmdHm")
    private String endYmdHm;
    private String objType;
    private int objHash;

    @QueryParam(value="serverId")
    public void setServerId(int serverId) {
        this.server = ServerManager.getInstance().getServerIfNullDefault(serverId);
    }

    public void validate() {
        if (StringUtils.isNotBlank((CharSequence)this.startYmdHm) || StringUtils.isNotBlank((CharSequence)this.endYmdHm)) {
            if (StringUtils.isBlank((CharSequence)this.startYmdHm) || StringUtils.isBlank((CharSequence)this.endYmdHm)) {
                throw ErrorState.VALIDATE_ERROR.newBizException("startYmdHms and endYmdHms should be not null !");
            }
            if (this.startTimeMillis > 0L || this.endTimeMillis > 0L) {
                throw ErrorState.VALIDATE_ERROR.newBizException("startYmdHms, endYmdHms and startTimeMillis, endTimeMills must not coexist!");
            }
            this.setTimeAsYmd();
        } else if (this.startTimeMillis <= 0L || this.endTimeMillis <= 0L) {
            throw ErrorState.VALIDATE_ERROR.newBizException("startTimeMillis and endTimeMillis must have value!");
        }
    }

    private void setTimeAsYmd() {
        ZoneId zoneId = ZoneId.systemDefault();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
        LocalDateTime startDateTime = LocalDateTime.parse(this.startYmdHm, formatter);
        LocalDateTime endDateTime = LocalDateTime.parse(this.endYmdHm, formatter);
        this.startTimeMillis = startDateTime.atZone(zoneId).toEpochSecond() * 1000L;
        this.endTimeMillis = endDateTime.atZone(zoneId).toEpochSecond() * 1000L;
    }

    public Server getServer() {
        return this.server;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public String getStartYmdHm() {
        return this.startYmdHm;
    }

    public String getEndYmdHm() {
        return this.endYmdHm;
    }

    public String getObjType() {
        return this.objType;
    }

    public int getObjHash() {
        return this.objHash;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void setStartTimeMillis(long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
    }

    public void setEndTimeMillis(long endTimeMillis) {
        this.endTimeMillis = endTimeMillis;
    }

    public void setStartYmdHm(String startYmdHm) {
        this.startYmdHm = startYmdHm;
    }

    public void setEndYmdHm(String endYmdHm) {
        this.endYmdHm = endYmdHm;
    }

    public void setObjType(String objType) {
        this.objType = objType;
    }

    public void setObjHash(int objHash) {
        this.objHash = objHash;
    }

    public String toString() {
        return "SummaryRequest(server=" + this.getServer() + ", startTimeMillis=" + this.getStartTimeMillis() + ", endTimeMillis=" + this.getEndTimeMillis() + ", startYmdHm=" + this.getStartYmdHm() + ", endYmdHm=" + this.getEndYmdHm() + ", objType=" + this.getObjType() + ", objHash=" + this.getObjHash() + ")";
    }
}

