/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.step;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.SpanPack;
import scouter.lang.step.CommonSpanStep;
import scouter.lang.step.Step;

public class SpanCallStep
extends CommonSpanStep {
    public long txid;
    public transient byte opt;
    public String address;
    public byte async;

    @Override
    public byte getStepType() {
        return 52;
    }

    @Override
    public void write(DataOutputX out) throws IOException {
        super.write(out);
        out.writeDecimal(this.txid);
        out.writeByte(this.opt);
        switch (this.opt) {
            case 1: {
                out.writeText(this.address);
            }
        }
        out.writeByte(this.async);
    }

    @Override
    public Step read(DataInputX in) throws IOException {
        super.read(in);
        this.txid = in.readDecimal();
        this.opt = in.readByte();
        switch (this.opt) {
            case 1: {
                this.address = in.readText();
                break;
            }
        }
        this.async = in.readByte();
        return this;
    }

    public static SpanCallStep fromPack(SpanPack pack, int index, long initialTime) {
        SpanCallStep step = new SpanCallStep();
        step.spanPack = pack;
        step.index = index;
        step.start_time = (int)(pack.timestamp - initialTime);
        step.tags = pack.tags;
        step.elapsed = pack.elapsed;
        step.error = pack.error;
        step.hash = pack.name;
        step.timestamp = pack.timestamp;
        step.spanType = pack.spanType;
        step.localEndpointServiceName = pack.localEndpointServiceName;
        step.localEndpointIp = pack.localEndpointIp;
        step.localEndpointPort = pack.localEndpointPort;
        step.remoteEndpointServiceName = pack.remoteEndpointServiceName;
        step.remoteEndpointIp = pack.remoteEndpointIp;
        step.remoteEndpointPort = pack.remoteEndpointPort;
        step.debug = pack.debug;
        step.shared = pack.shared;
        step.annotationTimestamps = pack.annotationTimestamps;
        step.annotationValues = pack.annotationValues;
        step.txid = pack.txid;
        if (pack.tags != null && pack.tags.containsKey("http.url")) {
            step.opt = 1;
            step.address = pack.tags.getText("http.url");
        }
        return step;
    }
}

