/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.task;

import java.io.File;
import java.util.Enumeration;
import scouter.Version;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.counter.CounterBasket;
import scouter.agent.counter.anotation.Counter;
import scouter.agent.netio.data.DataProxy;
import scouter.agent.netio.data.net.TcpWorker;
import scouter.agent.proxy.ToolsMainFactory;
import scouter.lang.pack.ObjectPack;
import scouter.lang.value.BooleanValue;
import scouter.util.FileUtil;
import scouter.util.StringKeyLinkedMap;
import scouter.util.StringUtil;
import scouter.util.SysJMX;

public class AgentHeartBeat {
    private static StringKeyLinkedMap<ObjectPack> objects;

    public static void addObject(String objType, int objHash, String objName) {
        if (objName == null) {
            return;
        }
        if (objName.equals(Configure.getInstance().getObjName())) {
            return;
        }
        ObjectPack old = objects.get(objName);
        if (old != null && objType.equals(old.objType)) {
            return;
        }
        ObjectPack p = new ObjectPack();
        p.objType = objType;
        p.objHash = objHash;
        p.objName = objName;
        objects.put(objName, p);
    }

    @Counter
    public void alive(CounterBasket pw) {
        DataProxy.sendHeartBeat(this.getMainObject());
        Enumeration<ObjectPack> en = objects.values();
        while (en.hasMoreElements()) {
            DataProxy.sendHeartBeat(en.nextElement());
        }
    }

    private ObjectPack getMainObject() {
        Configure conf = Configure.getInstance();
        ObjectPack p = new ObjectPack();
        p.objType = conf.obj_type;
        p.objHash = conf.getObjHash();
        p.objName = conf.getObjName();
        p.version = Version.getAgentFullVersion();
        p.address = TcpWorker.localAddr;
        if (StringUtil.isNotEmpty(conf.getObjExtType())) {
            p.tags.put("objExtType", conf.getObjExtType());
        }
        if (StringUtil.isNotEmpty(conf.getObjDetectedType())) {
            p.tags.put("detected", conf.getObjDetectedType());
        }
        if (ToolsMainFactory.activeStack) {
            p.tags.put("ActiveStack", new BooleanValue(true));
        }
        p.tags.put("ADC", new BooleanValue(conf.autodump_cpu_exceeded_enabled));
        if (conf.autodump_cpu_exceeded_enabled) {
            p.tags.put("ADC_TH", conf.autodump_cpu_exceeded_threshold_pct);
            p.tags.put("ADC_D", conf.autodump_cpu_exceeded_duration_ms);
        }
        return p;
    }

    public static void clearSubObjects() {
        objects.clear();
    }

    @Counter
    public void regist(CounterBasket pw) {
        Configure conf = Configure.getInstance();
        try {
            int pid = SysJMX.getProcessPID();
            File dir = new File(conf.counter_object_registry_path);
            File file = new File(dir, pid + ".scouter");
            if (dir.canWrite()) {
                FileUtil.save(file, conf.getObjName().getBytes());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        Logger.println("objType:" + Configure.getInstance().obj_type);
        Logger.println("objName:" + Configure.getInstance().getObjName());
        objects = new StringKeyLinkedMap();
    }
}

