/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.netio.request.handle;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import scouter.agent.Configure;
import scouter.agent.JavaAgent;
import scouter.agent.Logger;
import scouter.agent.netio.data.DataProxy;
import scouter.agent.netio.request.anotation.RequestHandler;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.TextValue;
import scouter.util.StringUtil;

public class AgentEnv {
    Configure conf = Configure.getInstance();

    @RequestHandler(value="OBJECT_SYSTEM_GC")
    public Pack systemGc(Pack param) {
        MapPack m = new MapPack();
        System.gc();
        Logger.println("A127", "OBJECT_SYSTEM_GC");
        return m;
    }

    @RequestHandler(value="OBJECT_ENV")
    public Pack getAgentEnv(Pack param) {
        MapPack m = new MapPack();
        Properties p = System.getProperties();
        Enumeration<Object> en = p.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = p.getProperty(key);
            m.put(key, new TextValue(value));
        }
        return m;
    }

    @RequestHandler(value="OBJECT_INFO")
    public Pack getAgentInfo(Pack param) {
        MapPack p = new MapPack();
        p.put("objHash", this.conf.getObjHash());
        p.put("objName", this.conf.getObjName());
        p.put("java.version", System.getProperty("java.version"));
        p.put("os.name", System.getProperty("os.name"));
        p.put("user.home", System.getProperty("user.home"));
        p.put("work.dir", new File(".").getAbsolutePath());
        return p;
    }

    @RequestHandler(value="OBJECT_RESET_CACHE")
    public Pack getAgentCacheReseto(Pack param) {
        DataProxy.reset();
        return param;
    }

    @RequestHandler(value="OBJECT_DUMP_FILE_LIST")
    public Pack getDumpFileList(Pack param) {
        MapPack result = new MapPack();
        ListValue nameLv = result.newList("name");
        ListValue sizeLv = result.newList("size");
        ListValue lastModifedLv = result.newList("last_modified");
        File dumpDir = Configure.getInstance().dump_dir;
        if (dumpDir.canRead()) {
            for (File file : dumpDir.listFiles()) {
                if (!file.isFile()) continue;
                nameLv.add(file.getName());
                sizeLv.add(file.length());
                lastModifedLv.add(file.lastModified());
            }
        }
        return result;
    }

    @RequestHandler(value="OBJECT_DUMP_FILE_DETAIL")
    public Pack getDumpFileDetail(Pack param, DataInputX in, DataOutputX out) {
        File dumpDir = Configure.getInstance().dump_dir;
        MapPack p = (MapPack)param;
        String name = p.getText("name");
        File dumpFile = new File(dumpDir, name);
        if (dumpFile.canRead()) {
            try {
                int n;
                int buff = 4096;
                FileInputStream stream = new FileInputStream(dumpFile);
                byte[] buffer = new byte[buff];
                while ((n = ((InputStream)stream).read(buffer, 0, buffer.length)) != -1) {
                    out.writeByte(3);
                    out.writeBlob(buffer, 0, n);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @RequestHandler(value="OBJECT_CLASS_LIST")
    public Pack getLoadedClassList(Pack param) {
        int COUNT_PER_PAGE = 100;
        MapPack mPack = (MapPack)param;
        int page = mPack.getInt("page");
        if (page < 1) {
            page = 1;
        }
        String filter = mPack.getText("filter");
        MapPack p = new MapPack();
        ListValue indexLv = p.newList("index");
        ListValue typeLv = p.newList("type");
        ListValue nameLv = p.newList("name");
        ListValue superClassLv = p.newList("superClass");
        ListValue interfacesLv = p.newList("interfaces");
        ListValue resourceLv = p.newList("resource");
        p.put("page", page);
        p.put("totalPage", 0L);
        Class[] loadedClasses = JavaAgent.getInstrumentation().getAllLoadedClasses();
        if (loadedClasses != null) {
            int start;
            ArrayList<Class> classList = new ArrayList<Class>();
            for (int i = 0; i < loadedClasses.length; ++i) {
                String lowerName;
                Class clazz = loadedClasses[i];
                if (StringUtil.isNotEmpty(filter) && !(lowerName = clazz.getName().toLowerCase()).contains(filter.toLowerCase())) continue;
                classList.add(clazz);
            }
            int totalCount = classList.size();
            p.put("totalPage", totalCount / 100 + 1);
            for (int i = start = (page - 1) * 100; i < start + 100 && i <= totalCount - 1; ++i) {
                try {
                    indexLv.add(i + 1);
                    Class clazz = (Class)classList.get(i);
                    typeLv.add(clazz.isInterface() ? "I" : (clazz.isPrimitive() ? "P" : "C"));
                    nameLv.add(clazz.getName());
                    String superClassName = "";
                    Class superClass = clazz.getSuperclass();
                    if (superClass != null) {
                        superClassName = superClass.getName();
                    }
                    superClassLv.add(superClassName);
                    StringBuffer sb = new StringBuffer();
                    Class<?>[] interfaces = clazz.getInterfaces();
                    if (interfaces != null) {
                        for (int j = 0; j < interfaces.length; ++j) {
                            sb.append(interfaces[j].getName());
                            if (j >= interfaces.length - 1) continue;
                            sb.append(",");
                        }
                    }
                    interfacesLv.add(sb.toString());
                    ClassLoader classLoader = clazz.getClassLoader();
                    if (classLoader == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    String resource = "";
                    try {
                        URL url = classLoader.getResource(clazz.getName().replace('.', '/') + ".class");
                        if (url != null) {
                            resource = url.toString();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    resourceLv.add(resource);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        return p;
    }
}

