/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.task;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import scouter.agent.batch.Configure;
import scouter.agent.batch.Logger;
import scouter.agent.batch.Main;
import scouter.agent.batch.dump.ThreadDumpHandler;
import scouter.agent.batch.netio.data.net.UdpLocalAgent;
import scouter.agent.batch.task.ResultSender;
import scouter.agent.batch.trace.TraceContext;
import scouter.util.ThreadUtil;

public class BatchMonitor
extends Thread {
    private static BatchMonitor instance = null;
    public Configure config = null;

    public static BatchMonitor getInstance() {
        if (instance == null) {
            instance = new BatchMonitor();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            TraceContext.getInstance();
            Runtime.getRuntime().addShutdownHook(new ResultSender());
            instance.start();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStreamWriter stackWriter = null;
        OutputStreamWriter indexWriter = null;
        try {
            File stackFile = null;
            this.config = Configure.getInstance();
            TraceContext traceContext = TraceContext.getInstance();
            if (!this.config.scouter_standalone) {
                UdpLocalAgent.sendUdpPackToServer(Main.getObjectPack());
            }
            if (this.config.sfa_dump_enabled) {
                stackFile = new File(traceContext.getLogFullFilename() + ".log");
                if (stackFile.exists()) {
                    stackFile = null;
                } else {
                    traceContext.isStackLogFile = true;
                    stackWriter = new FileWriter(stackFile);
                    indexWriter = new FileWriter(new File(traceContext.getLogFullFilename() + ".inx"));
                }
            }
            long lastStackDumpTime = 0L;
            long lastCheckThreadTime = 0L;
            long lastCheckGCTime = 0L;
            while (!this.config.scouter_stop) {
                long currentTime = System.currentTimeMillis();
                if (stackWriter != null && currentTime - lastStackDumpTime >= (long)this.config.sfa_dump_interval_ms) {
                    lastStackDumpTime = currentTime;
                    ThreadDumpHandler.processDump(stackFile, (FileWriter)stackWriter, (FileWriter)indexWriter, this.config.sfa_dump_filter, this.config.sfa_dump_header_exists);
                    UdpLocalAgent.sendRunningInfo(traceContext);
                }
                if (currentTime - lastCheckGCTime >= 5000L) {
                    lastCheckGCTime = currentTime;
                    traceContext.caculateResource();
                }
                if (currentTime - lastCheckThreadTime >= this.config.thread_check_interval_ms) {
                    lastCheckThreadTime = currentTime;
                    traceContext.checkThread();
                }
                Thread.sleep(100L);
            }
        }
        catch (Throwable ex) {
            Logger.println("ERROR: " + ex.getMessage());
        }
        finally {
            if (stackWriter != null) {
                try {
                    stackWriter.close();
                }
                catch (Exception stackFile) {}
            }
            if (indexWriter != null) {
                try {
                    indexWriter.close();
                }
                catch (Exception stackFile) {}
            }
        }
    }
}

