/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.trace;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import scouter.agent.batch.Configure;
import scouter.agent.batch.Logger;
import scouter.agent.batch.trace.LocalSQL;
import scouter.agent.batch.trace.TraceSQL;
import scouter.lang.pack.BatchPack;
import scouter.lang.pack.MapPack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.MapValue;
import scouter.util.SysJMX;

public class TraceContext {
    private static final String SQL_OTHERS = "Others";
    private static final int SQL_OTHERS_HASH = "Others".hashCode();
    private static TraceContext instance = null;
    public String batchJobId;
    public String args;
    public Integer pID;
    public long startTime;
    public long endTime;
    public int threadCnt = 0;
    public long startCpu;
    public long endCpu;
    public long gcTime = 0L;
    public long gcCount = 0L;
    public int sqlTotalCnt = 0;
    public long sqlTotalTime = 0L;
    public long sqlTotalRows = 0L;
    public long sqlTotalRuns = 0L;
    public boolean isStackLogFile = false;
    public String standAloneFile = null;
    private HashMap<Integer, String> uniqueSqls = new HashMap(100);
    private HashMap<Integer, TraceSQL> sqlMap = new HashMap(100);
    private List<LocalSQL> localSQLList = new ArrayList<LocalSQL>();
    private int sqlMaxCount;
    public String lastStack = null;

    public static final TraceContext getInstance() {
        return instance;
    }

    private TraceContext() {
        this.startTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        this.readBatchId();
        this.sqlMaxCount = Configure.getInstance().sql_max_count;
        this.pID = SysJMX.getProcessPID();
        this.startCpu = SysJMX.getProcessCPU();
    }

    private void readBatchId() {
        Configure config = Configure.getInstance();
        if ("props".equals(config.batch_id_type)) {
            this.batchJobId = config.getValue(config.batch_id);
        } else {
            this.args = System.getProperty("sun.java.command");
            StringTokenizer token = new StringTokenizer(this.args, " ");
            if ("args".equals(config.batch_id_type)) {
                int index = Integer.parseInt(config.batch_id);
                int currentIndex = -1;
                while (token.hasMoreTokens()) {
                    if (currentIndex == index) {
                        this.batchJobId = token.nextToken();
                        break;
                    }
                    token.nextToken();
                    ++currentIndex;
                }
            } else if ("class".equals(config.batch_id_type) && token.hasMoreTokens()) {
                this.batchJobId = token.nextToken();
            }
        }
        if (this.batchJobId == null || this.batchJobId.length() == 0) {
            this.batchJobId = "NoId[Scouter]";
        }
        Logger.println("Batch ID=" + this.batchJobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSQLHash(String sqltext, int hashValue) {
        HashMap<Integer, String> hashMap = this.uniqueSqls;
        synchronized (hashMap) {
            if (this.uniqueSqls.get(hashValue) != null) {
                return hashValue;
            }
            if (this.uniqueSqls.size() < this.sqlMaxCount) {
                this.uniqueSqls.put(hashValue, sqltext);
                return hashValue;
            }
            if (this.uniqueSqls.size() == this.sqlMaxCount) {
                this.uniqueSqls.put(SQL_OTHERS_HASH, SQL_OTHERS);
            }
            return SQL_OTHERS_HASH;
        }
    }

    public HashMap<Integer, String> getUniqueSQLs() {
        return this.uniqueSqls;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(100);
        String lineSeparator = System.getProperty("line.separator");
        buffer.append("-[").append(this.batchJobId).append("]----------------------------------------------").append(lineSeparator);
        buffer.append("Run  Command: ").append(this.args).append(lineSeparator);
        if (this.isStackLogFile) {
            buffer.append("Stack   Dump: ").append(this.getLogFullFilename()).append(lineSeparator);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        buffer.append("Start   Time: ").append(sdf.format(new Date(this.startTime))).append(lineSeparator);
        buffer.append("Stop    Time: ").append(sdf.format(new Date(this.endTime))).append(lineSeparator);
        buffer.append("Elapsed Time: ").append(this.endTime - this.startTime).append("ms").append(lineSeparator);
        if (this.getCPUTimeByMillis() > 0L) {
            buffer.append("CPU     Time: ").append(this.getCPUTimeByMillis()).append("ms").append(lineSeparator);
        }
        if (this.gcCount > 0L) {
            buffer.append("GC     Count: ").append(this.gcCount).append(lineSeparator);
            buffer.append("GC      Time: ").append(this.gcTime).append("ms").append(lineSeparator);
        }
        if (this.sqlMap.size() > 0) {
            buffer.append("SQL     Time: ").append(this.sqlTotalTime / 1000000L).append("ms").append(lineSeparator);
            buffer.append("SQL     Type: ").append(this.sqlMap.size()).append(lineSeparator);
            buffer.append("SQL     Runs: ").append(this.sqlTotalRuns).append(lineSeparator);
        }
        if (this.threadCnt > 0) {
            buffer.append("Thread Count: ").append(this.threadCnt).append(lineSeparator);
        }
        if (this.sqlMap.size() > 0) {
            buffer.append(lineSeparator).append("<SQLs>").append(lineSeparator);
            int index = 0;
            buffer.append("Index          Runs     TotalTime       MinTime       MaxTime          Rows (Measured) StartTime               EndTime").append(lineSeparator);
            buffer.append("--------------------------------------------------------------------------------------------------------------------------------------");
            List<TraceSQL> list = this.sortTraceSQLList();
            for (TraceSQL traceSql : list) {
                buffer.append(lineSeparator);
                buffer.append(String.format("%5s", ++index)).append(' ');
                buffer.append(String.format("%,13d", traceSql.runs)).append(' ');
                buffer.append(String.format("%,13d", traceSql.getTotalTimeByMillis())).append(' ');
                buffer.append(String.format("%,13d", traceSql.getMinTimeByMillis())).append(' ');
                buffer.append(String.format("%,13d", traceSql.getMaxTimeByMillis())).append(' ');
                buffer.append(String.format("%,13d", traceSql.processedRows)).append(' ').append(String.format("%10s", traceSql.rowed)).append(' ');
                buffer.append(sdf.format(new Date(traceSql.startTime))).append(' ');
                buffer.append(sdf.format(new Date(traceSql.endTime)));
            }
            buffer.append(lineSeparator).append("--------------------------------------------------------------------------------------------------------------------------------------").append(lineSeparator);
            buffer.append(lineSeparator).append("<SQL Texts>").append(lineSeparator);
            index = 0;
            for (TraceSQL traceSql : list) {
                buffer.append("-----------------").append(lineSeparator);
                buffer.append("#SQLINX-").append(++index).append(lineSeparator);
                buffer.append(this.uniqueSqls.get(traceSql.hashValue)).append(lineSeparator);
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSQLStats(LocalSQL localSql) {
        if (localSql == null || localSql.size() == 0) {
            return;
        }
        for (TraceSQL sql : localSql.values()) {
            TraceSQL statsSql;
            Integer hashValue = sql.hashValue;
            Object object = this.sqlMap;
            synchronized (object) {
                statsSql = this.sqlMap.get(hashValue);
                if (statsSql == null) {
                    statsSql = new TraceSQL();
                    statsSql.hashValue = hashValue;
                    this.sqlMap.put(hashValue, statsSql);
                    ++this.sqlTotalCnt;
                }
            }
            object = statsSql;
            synchronized (object) {
                statsSql.runs += sql.runs;
                this.sqlTotalRuns += (long)sql.runs;
                statsSql.totalTime += sql.totalTime;
                this.sqlTotalTime += sql.totalTime;
                statsSql.processedRows += sql.processedRows;
                this.sqlTotalRows += sql.processedRows;
                if (statsSql.startTime > sql.startTime || statsSql.startTime == -1L) {
                    statsSql.startTime = sql.startTime;
                }
                if (statsSql.endTime < sql.endTime) {
                    statsSql.endTime = sql.endTime;
                }
                if (statsSql.minTime > sql.minTime) {
                    statsSql.minTime = sql.minTime;
                }
                if (statsSql.maxTime < sql.maxTime) {
                    statsSql.maxTime = sql.maxTime;
                }
                if (sql.rowed) {
                    statsSql.rowed = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caculateLast() {
        List<LocalSQL> list = this.localSQLList;
        synchronized (list) {
            for (LocalSQL localSql : this.localSQLList) {
                this.addSQLStats(localSql);
            }
            this.localSQLList.clear();
        }
        this.caculateResource();
    }

    public void caculateResource() {
        this.endCpu = SysJMX.getProcessCPU();
        long[] gcInfo = SysJMX.getCurrentProcGcInfo();
        this.gcCount = gcInfo[0];
        this.gcTime = gcInfo[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapPack caculateTemp() {
        MapPack map = new MapPack();
        map.put("batchJobId", this.batchJobId);
        map.put("args", this.args);
        map.put("pID", this.pID.intValue());
        map.put("startTime", this.startTime);
        map.put("elapsedTime", System.currentTimeMillis() - this.startTime);
        map.put("cPUTime", this.endCpu - this.startCpu);
        map.put("gcCount", this.gcCount);
        map.put("gcTime", this.gcTime);
        long tempSqlTotalTime = this.sqlTotalTime;
        long tempSqlTotalRows = this.sqlTotalRows;
        long tempSqlTotalRuns = this.sqlTotalRuns;
        List<LocalSQL> list = this.localSQLList;
        synchronized (list) {
            for (LocalSQL localSql : this.localSQLList) {
                for (TraceSQL sql : localSql.values()) {
                    tempSqlTotalTime += sql.totalTime;
                    tempSqlTotalRows += sql.processedRows;
                    tempSqlTotalRuns += (long)sql.runs;
                }
            }
        }
        map.put("sqlTotalTime", tempSqlTotalTime);
        map.put("sqlTotalRows", tempSqlTotalRows);
        map.put("sqlTotalRuns", tempSqlTotalRuns);
        if (this.lastStack == null) {
            map.put("lastStack", "None");
        } else {
            map.put("lastStack", this.lastStack);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkThread() {
        List<LocalSQL> list = this.localSQLList;
        synchronized (list) {
            for (int inx = this.localSQLList.size() - 1; inx >= 0; --inx) {
                LocalSQL localSql = this.localSQLList.get(inx);
                Thread thread = localSql.getThread();
                if (thread.isAlive()) continue;
                this.addSQLStats(localSql);
                this.localSQLList.remove(inx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalSQL(LocalSQL localSql) {
        List<LocalSQL> list = this.localSQLList;
        synchronized (list) {
            this.localSQLList.add(localSql);
            ++this.threadCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalSQL(LocalSQL localSql) {
        List<LocalSQL> list = this.localSQLList;
        synchronized (list) {
            this.localSQLList.remove(localSql);
        }
        this.addSQLStats(localSql);
    }

    public List<LocalSQL> getLocalSQLList() {
        return this.localSQLList;
    }

    public long getCPUTimeByMicro() {
        return (this.endCpu - this.startCpu) / 1000L;
    }

    public long getCPUTimeByMillis() {
        return (this.endCpu - this.startCpu) / 1000000L;
    }

    public String getLogFullFilename() {
        Date dt = new Date(this.startTime);
        String fileSeparator = System.getProperty("file.separator");
        String date = new SimpleDateFormat("yyyyMMdd").format(dt);
        File dir = new File(new StringBuilder(100).append(Configure.getInstance().sfa_dump_dir.getAbsolutePath()).append(fileSeparator).append(date).toString());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new StringBuilder(100).append(dir.getAbsolutePath()).append(fileSeparator).append(this.batchJobId).append('_').append(date).append('_').append(new SimpleDateFormat("HHmmss.SSS").format(dt)).append('_').append(this.pID).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TraceSQL> sortTraceSQLList() {
        ArrayList<TraceSQL> inList = new ArrayList<TraceSQL>(this.sqlMap.size() + 1);
        HashMap<Integer, TraceSQL> hashMap = this.sqlMap;
        synchronized (hashMap) {
            for (TraceSQL traceSql : this.sqlMap.values()) {
                inList.add(traceSql);
            }
        }
        Collections.sort(inList, new Comparator<TraceSQL>(){

            @Override
            public int compare(TraceSQL o1, TraceSQL o2) {
                if (o1.totalTime < o2.totalTime) {
                    return 1;
                }
                if (o1.totalTime > o2.totalTime) {
                    return -1;
                }
                return 0;
            }
        });
        return inList;
    }

    public BatchPack makePack() {
        BatchPack pack = new BatchPack();
        Configure config = Configure.getInstance();
        pack.objHash = config.getObjHash();
        pack.objName = config.getObjName();
        pack.objType = config.obj_type;
        pack.batchJobId = this.batchJobId;
        pack.batchJobId = this.batchJobId;
        pack.args = this.args;
        pack.pID = this.pID;
        pack.startTime = this.startTime;
        pack.elapsedTime = this.endTime - this.startTime;
        pack.threadCnt = this.threadCnt;
        pack.cpuTime = this.endCpu - this.startCpu;
        pack.sqlTotalCnt = this.sqlTotalCnt;
        pack.sqlTotalTime = this.sqlTotalTime;
        pack.sqlTotalRows = this.sqlTotalRows;
        pack.sqlTotalRuns = this.sqlTotalRuns;
        pack.isStack = this.isStackLogFile;
        if (this.sqlTotalCnt > 0) {
            pack.uniqueSqls = this.uniqueSqls;
            pack.sqlStats = new ArrayList<MapValue>(this.sqlTotalCnt);
            for (TraceSQL traceSql : this.sortTraceSQLList()) {
                MapValue value = new MapValue();
                pack.sqlStats.add(value);
                value.put("hashValue", traceSql.hashValue.intValue());
                value.put("runs", traceSql.runs);
                value.put("startTime", traceSql.startTime);
                value.put("endTime", traceSql.endTime);
                value.put("totalTime", traceSql.totalTime);
                value.put("minTime", traceSql.minTime);
                value.put("maxTime", traceSql.maxTime);
                value.put("processedRows", traceSql.processedRows);
                value.put("rowed", new BooleanValue(traceSql.rowed));
            }
        }
        return pack;
    }

    static {
        instance = new TraceContext();
    }
}

