/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace.api;

import scouter.agent.Configure;
import scouter.agent.plugin.PluginHttpCallTrace;
import scouter.agent.proxy.IHttpClient;
import scouter.agent.proxy.NettyHttpClientFactory;
import scouter.agent.trace.HookArgs;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.api.ApiCallTraceHelper;
import scouter.lang.step.ApiCallStep;
import scouter.util.Hexa32;
import scouter.util.IntKeyLinkedMap;
import scouter.util.KeyGen;

public class ForRibbonLB
implements ApiCallTraceHelper.IHelper {
    private int fail = 0;
    private static IntKeyLinkedMap<IHttpClient> httpclients = new IntKeyLinkedMap().setMax(5);

    @Override
    public ApiCallStep process(TraceContext ctx, HookArgs hookPoint) {
        ApiCallStep step = new ApiCallStep();
        if (this.fail < 100 && hookPoint.args != null && hookPoint.args.length > 2) {
            try {
                IHttpClient httpclient = this.getProxy(hookPoint);
                step.txid = KeyGen.next();
                this.transfer(httpclient, ctx, hookPoint.args[1], step.txid);
                String host = httpclient.getHost(hookPoint.args[0]);
                step.opt = 1;
                step.address = host;
                ctx.apicall_name = httpclient.getURI(hookPoint.args[1]);
                ctx.apicall_name = this.fw_stripes(ctx.apicall_name);
            }
            catch (Throwable e) {
                ctx.apicall_name = e.toString();
                e.printStackTrace();
                ++this.fail;
            }
        }
        if (ctx.apicall_name == null) {
            ctx.apicall_name = hookPoint.class1;
        }
        return step;
    }

    @Override
    public void processEnd(TraceContext ctx, ApiCallStep step, Object rtn, HookArgs hookPoint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHttpClient getProxy(HookArgs hookPoint) {
        int key = System.identityHashCode(hookPoint.this1.getClass());
        IHttpClient httpclient = httpclients.get(key);
        if (httpclient == null) {
            ForRibbonLB forRibbonLB = this;
            synchronized (forRibbonLB) {
                httpclient = NettyHttpClientFactory.create(hookPoint.this1.getClass().getClassLoader());
                httpclients.put(key, httpclient);
            }
        }
        return httpclient;
    }

    private void transfer(IHttpClient httpclient, TraceContext ctx, Object req, long calleeTxid) {
        Configure conf = Configure.getInstance();
        if (conf.trace_interservice_enabled) {
            try {
                if (ctx.gxid == 0L) {
                    ctx.gxid = ctx.txid;
                }
                httpclient.addHeader(req, conf._trace_interservice_gxid_header_key, Hexa32.toString32(ctx.gxid));
                httpclient.addHeader(req, conf._trace_interservice_caller_header_key, Hexa32.toString32(ctx.txid));
                httpclient.addHeader(req, conf._trace_interservice_callee_header_key, Hexa32.toString32(calleeTxid));
                httpclient.addHeader(req, conf._trace_interservice_caller_obj_header_key, String.valueOf(conf.getObjHash()));
                PluginHttpCallTrace.call(ctx, httpclient, req);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String fw_stripes(String url) {
        if (url == null) {
            return null;
        }
        int y = url.indexOf(63);
        if (y > 0) {
            return url.substring(0, y);
        }
        return url;
    }
}

