/*
 * Decompiled with CFR 0.152.
 */
package scouter.repack.net.bytebuddy.implementation.bytecode.member;

import scouter.repack.net.bytebuddy.description.enumeration.EnumerationDescription;
import scouter.repack.net.bytebuddy.description.field.FieldDescription;
import scouter.repack.net.bytebuddy.description.field.FieldList;
import scouter.repack.net.bytebuddy.description.type.TypeDefinition;
import scouter.repack.net.bytebuddy.implementation.Implementation;
import scouter.repack.net.bytebuddy.implementation.bytecode.StackManipulation;
import scouter.repack.net.bytebuddy.implementation.bytecode.StackSize;
import scouter.repack.net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import scouter.repack.net.bytebuddy.jar.asm.MethodVisitor;
import scouter.repack.net.bytebuddy.matcher.ElementMatchers;

public enum FieldAccess {
    STATIC(179, 178, StackSize.ZERO),
    INSTANCE(181, 180, StackSize.SINGLE);

    private final int putterOpcode;
    private final int getterOpcode;
    private final int targetSizeChange;

    private FieldAccess(int putterOpcode, int getterOpcode, StackSize targetSizeChange) {
        this.putterOpcode = putterOpcode;
        this.getterOpcode = getterOpcode;
        this.targetSizeChange = targetSizeChange.getSize();
    }

    public static StackManipulation forEnumeration(EnumerationDescription enumerationDescription) {
        StackManipulation stackManipulation;
        FieldList fieldList = (FieldList)enumerationDescription.getEnumerationType().getDeclaredFields().filter(ElementMatchers.named(enumerationDescription.getValue()));
        if (!(fieldList.size() == 1 && ((FieldDescription.InDefinedShape)fieldList.getOnly()).isStatic() && ((FieldDescription.InDefinedShape)fieldList.getOnly()).isPublic() && ((FieldDescription.InDefinedShape)fieldList.getOnly()).isEnum())) {
            stackManipulation = StackManipulation.Illegal.INSTANCE;
        } else {
            FieldAccess fieldAccess = STATIC;
            ((Object)((Object)fieldAccess)).getClass();
            stackManipulation = fieldAccess.new AccessDispatcher((FieldDescription.InDefinedShape)fieldList.getOnly()).read();
        }
        return stackManipulation;
    }

    public static Defined forField(FieldDescription.InDefinedShape fieldDescription) {
        AccessDispatcher accessDispatcher;
        if (fieldDescription.isStatic()) {
            FieldAccess fieldAccess = STATIC;
            ((Object)((Object)fieldAccess)).getClass();
            accessDispatcher = fieldAccess.new AccessDispatcher(fieldDescription);
        } else {
            FieldAccess fieldAccess = INSTANCE;
            ((Object)((Object)fieldAccess)).getClass();
            accessDispatcher = fieldAccess.new AccessDispatcher(fieldDescription);
        }
        return accessDispatcher;
    }

    public static Defined forField(FieldDescription fieldDescription) {
        FieldDescription.InDefinedShape declaredField = (FieldDescription.InDefinedShape)fieldDescription.asDefined();
        return fieldDescription.getType().asErasure().equals(declaredField.getType().asErasure()) ? FieldAccess.forField(declaredField) : OfGenericField.of(fieldDescription, FieldAccess.forField(declaredField));
    }

    protected class AccessDispatcher
    implements Defined {
        private final FieldDescription.InDefinedShape fieldDescription;

        protected AccessDispatcher(FieldDescription.InDefinedShape fieldDescription) {
            this.fieldDescription = fieldDescription;
        }

        @Override
        public StackManipulation read() {
            return new FieldGetInstruction();
        }

        @Override
        public StackManipulation write() {
            return new FieldPutInstruction();
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && FieldAccess.this.equals((Object)((AccessDispatcher)other).getFieldAccess()) && this.fieldDescription.equals(((AccessDispatcher)other).fieldDescription);
        }

        public int hashCode() {
            return this.fieldDescription.hashCode() + 31 * FieldAccess.this.hashCode();
        }

        private FieldAccess getFieldAccess() {
            return FieldAccess.this;
        }

        protected class FieldPutInstruction
        extends AbstractFieldInstruction {
            protected FieldPutInstruction() {
            }

            @Override
            protected int getOpcode() {
                return FieldAccess.this.putterOpcode;
            }

            @Override
            protected StackManipulation.Size resolveSize(StackSize fieldSize) {
                return new StackManipulation.Size(-1 * (fieldSize.getSize() + FieldAccess.this.targetSizeChange), 0);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.getAccessDispatcher().equals(((FieldPutInstruction)other).getAccessDispatcher());
            }

            public int hashCode() {
                return this.getAccessDispatcher().hashCode() + 14;
            }

            private AccessDispatcher getAccessDispatcher() {
                return AccessDispatcher.this;
            }
        }

        protected class FieldGetInstruction
        extends AbstractFieldInstruction {
            protected FieldGetInstruction() {
            }

            @Override
            protected int getOpcode() {
                return FieldAccess.this.getterOpcode;
            }

            @Override
            protected StackManipulation.Size resolveSize(StackSize fieldSize) {
                int sizeChange = fieldSize.getSize() - FieldAccess.this.targetSizeChange;
                return new StackManipulation.Size(sizeChange, sizeChange);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.getAccessDispatcher().equals(((FieldGetInstruction)other).getAccessDispatcher());
            }

            public int hashCode() {
                return this.getAccessDispatcher().hashCode() + 7;
            }

            private AccessDispatcher getAccessDispatcher() {
                return AccessDispatcher.this;
            }
        }

        private abstract class AbstractFieldInstruction
        implements StackManipulation {
            private AbstractFieldInstruction() {
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitFieldInsn(this.getOpcode(), AccessDispatcher.this.fieldDescription.getDeclaringType().getInternalName(), AccessDispatcher.this.fieldDescription.getInternalName(), AccessDispatcher.this.fieldDescription.getDescriptor());
                return this.resolveSize(AccessDispatcher.this.fieldDescription.getType().getStackSize());
            }

            protected abstract int getOpcode();

            protected abstract StackManipulation.Size resolveSize(StackSize var1);
        }
    }

    protected static class OfGenericField
    implements Defined {
        private final TypeDefinition targetType;
        private final Defined defined;

        protected OfGenericField(TypeDefinition targetType, Defined defined) {
            this.targetType = targetType;
            this.defined = defined;
        }

        protected static Defined of(FieldDescription fieldDescription, Defined fieldAccess) {
            return new OfGenericField(fieldDescription.getType(), fieldAccess);
        }

        @Override
        public StackManipulation read() {
            return new StackManipulation.Compound(this.defined.read(), TypeCasting.to(this.targetType));
        }

        @Override
        public StackManipulation write() {
            return this.defined.write();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OfGenericField)) {
                return false;
            }
            OfGenericField other = (OfGenericField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TypeDefinition this$targetType = this.targetType;
            TypeDefinition other$targetType = other.targetType;
            if (this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType)) {
                return false;
            }
            Defined this$defined = this.defined;
            Defined other$defined = other.defined;
            return !(this$defined == null ? other$defined != null : !this$defined.equals(other$defined));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OfGenericField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypeDefinition $targetType = this.targetType;
            result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
            Defined $defined = this.defined;
            result = result * 59 + ($defined == null ? 43 : $defined.hashCode());
            return result;
        }
    }

    public static interface Defined {
        public StackManipulation read();

        public StackManipulation write();
    }
}

