/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.main;

import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.util.SysJMX;
import scouter.util.ThreadUtil;
import scouter.util.logo.Logo;
import scouterx.webapp.framework.client.model.AgentModelThread;
import scouterx.webapp.framework.client.net.LoginMgr;
import scouterx.webapp.framework.client.net.LoginRequest;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.client.thread.ServerSessionObserver;
import scouterx.webapp.framework.configure.ConfigureAdaptor;
import scouterx.webapp.framework.configure.ConfigureManager;
import scouterx.webapp.framework.configure.ServerConfig;
import scouterx.webapp.framework.filter.CorsFilter;
import scouterx.webapp.framework.filter.LoggingInitServletFilter;
import scouterx.webapp.framework.filter.NoCacheFilter;
import scouterx.webapp.framework.filter.ReleaseResourceFilter;
import scouterx.webapp.layer.websock.BasicSocket;
import scouterx.webapp.swagger.Bootstrap;

public class WebAppMain
extends Application {
    private static boolean standAloneMode = false;

    public static boolean isStandAloneMode() {
        return standAloneMode;
    }

    public static void main(String[] args) throws Exception {
        standAloneMode = true;
        Logo.print((boolean)true);
        WebAppMain.initializeLogDir();
        ConfigureAdaptor conf = ConfigureManager.getConfigure();
        WebAppMain.connectScouterCollector();
        org.eclipse.jetty.server.Server server = new org.eclipse.jetty.server.Server(conf.getNetHttpPort());
        HandlerCollection handlers = new HandlerCollection();
        RequestLogHandler requestLogHandler = WebAppMain.setRequestLogHandler();
        handlers.addHandler((Handler)requestLogHandler);
        ServletContextHandler servletContextHandler = WebAppMain.setWebAppContext();
        if (conf.isNetHttpApiGzipEnabled()) {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT", "DELETE"});
            gzipHandler.setMinGzipSize(1024);
            gzipHandler.setHandler((Handler)servletContextHandler);
            handlers.addHandler((Handler)gzipHandler);
        } else {
            handlers.addHandler((Handler)servletContextHandler);
        }
        server.setHandler((Handler)handlers);
        WebAppMain.setWebSocketServer(servletContextHandler);
        try {
            server.start();
            WebAppMain.waitOnExit(server);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setWebSocketServer(ServletContextHandler servletContextHandler) throws ServletException, DeploymentException {
        ServerContainer container = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)servletContextHandler);
        container.setDefaultMaxSessionIdleTimeout(604800000L);
        container.addEndpoint(BasicSocket.class);
    }

    private static ServletContextHandler setWebHttpApiHandler() {
        ConfigureAdaptor conf = ConfigureManager.getConfigure();
        String providerPackages = "scouterx.webapp";
        if (conf.isNetHttpApiSwaggerEnabled()) {
            providerPackages = providerPackages + ",io.swagger.jaxrs.listing";
        }
        ServletHolder jerseyHolder = new ServletHolder(ServletContainer.class);
        jerseyHolder.setInitParameter("javax.ws.rs.Application", "scouterx.webapp.main.WebAppMain");
        jerseyHolder.setInitParameter("jersey.config.server.provider.packages", providerPackages);
        jerseyHolder.setInitOrder(1);
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.setSessionHandler(new SessionHandler());
        servletContextHandler.getSessionHandler().setMaxInactiveInterval(conf.getNetHttpApiSessionTimeout());
        servletContextHandler.setContextPath("/");
        servletContextHandler.addServlet(jerseyHolder, "/scouter/*");
        servletContextHandler.addServlet(WebAppMain.setStaticContentHandler(), "/*");
        servletContextHandler.addServlet(WebAppMain.setExtWebStaticContentHandler(), "/extweb/*");
        servletContextHandler.addServlet(WebAppMain.setSwaggerBootstrapHandler(), "/swagger");
        WebAppMain.addFilter(servletContextHandler);
        return servletContextHandler;
    }

    private static void addFilter(ServletContextHandler servletContextHandler) {
        servletContextHandler.addFilter(LoggingInitServletFilter.class, "/scouter/*", EnumSet.of(DispatcherType.REQUEST));
        servletContextHandler.addFilter(CorsFilter.class, "/scouter/*", EnumSet.of(DispatcherType.REQUEST));
        servletContextHandler.addFilter(NoCacheFilter.class, "/scouter/*", EnumSet.of(DispatcherType.REQUEST));
        servletContextHandler.addFilter(ReleaseResourceFilter.class, "/scouter/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private static ServletHolder setSwaggerBootstrapHandler() {
        ServletHolder swaggerBootstrap = new ServletHolder(Bootstrap.class);
        swaggerBootstrap.setInitOrder(2);
        return swaggerBootstrap;
    }

    private static ServletHolder setStaticContentHandler() {
        String resourceBase = WebAppMain.class.getClassLoader().getResource("webroot/").toExternalForm();
        ServletHolder holderHome = new ServletHolder(DefaultServlet.class);
        holderHome.setInitParameter("resourceBase", resourceBase);
        holderHome.setInitParameter("dirAllowed", "false");
        holderHome.setInitParameter("pathInfoOnly", "true");
        return holderHome;
    }

    private static ServletHolder setExtWebStaticContentHandler() {
        String resourceBase = ConfigureManager.getConfigure().getNetHttpExtWebDir();
        ServletHolder holderHome = new ServletHolder(DefaultServlet.class);
        holderHome.setInitParameter("resourceBase", resourceBase);
        holderHome.setInitParameter("dirAllowed", "true");
        holderHome.setInitParameter("pathInfoOnly", "true");
        return holderHome;
    }

    private static RequestLogHandler setRequestLogHandler() {
        ConfigureAdaptor conf = ConfigureManager.getConfigure();
        NCSARequestLog requestLog = new NCSARequestLog();
        requestLog.setFilename("./logs/http-request-yyyy_mm_dd.log");
        requestLog.setFilenameDateFormat("yyyy_MM_dd");
        requestLog.setRetainDays(conf.getLogKeepDays());
        requestLog.setAppend(true);
        requestLog.setExtended(true);
        requestLog.setLogCookies(false);
        requestLog.setLogTimeZone(TimeZone.getDefault().getID());
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        return requestLogHandler;
    }

    private static void connectScouterCollector() {
        Logger log = LoggerFactory.getLogger(WebAppMain.class);
        List<ServerConfig> serverConfigList = ConfigureManager.getConfigure().getServerConfigs();
        ServerManager srvMgr = ServerManager.getInstance();
        for (ServerConfig serverConfig : serverConfigList) {
            Server server = new Server(serverConfig.getIp(), serverConfig.getPort());
            if (srvMgr.getServer(server.getId()) == null) {
                srvMgr.addServer(server);
            } else {
                server = srvMgr.getServer(server.getId());
            }
            server.setUserId(serverConfig.getId());
            server.setPassword(serverConfig.getPassword());
            LoginRequest result = LoginMgr.login(server);
            if (result.success) {
                log.info("Successfully log in to {}:{}", (Object)server.getIp(), (Object)server.getPort());
                AgentModelThread.getInstance();
                continue;
            }
            server.setUserId(serverConfig.getId());
            server.setPassword(serverConfig.getPassword());
            log.error("Fail to log in to {}:{}", (Object)server.getIp(), (Object)server.getPort());
        }
        ServerSessionObserver.load();
    }

    private static void waitOnExit(org.eclipse.jetty.server.Server server) throws Exception {
        File exit = new File(SysJMX.getProcessPID() + ".scouter");
        try {
            exit.createNewFile();
        }
        catch (Exception e) {
            String tmp = System.getProperty("user.home", "/tmp");
            exit = new File(tmp, SysJMX.getProcessPID() + ".scouter.run");
            try {
                exit.createNewFile();
            }
            catch (Exception k) {
                System.exit(1);
            }
        }
        exit.deleteOnExit();
        System.out.println("System JRE version : " + System.getProperty("java.version"));
        while (true) {
            if (!exit.exists()) {
                server.setStopTimeout(3000L);
                server.stop();
                System.exit(0);
            }
            ThreadUtil.sleep((long)1000L);
        }
    }

    private static void initializeLogDir() {
        ConfigureAdaptor conf = ConfigureManager.getConfigure();
        File logDir = new File(conf.getLogDir());
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        System.setProperty("scouter_webapp_log_dir", conf.getLogDir());
        Logger firstLogger = LoggerFactory.getLogger(WebAppMain.class);
        firstLogger.info("scouter webapp starting! Run-Mode:" + (standAloneMode ? "StandAlone" : "Embedded"));
    }

    public static ServletContextHandler setWebAppContext() throws ServletException, DeploymentException {
        if (!standAloneMode) {
            WebAppMain.initializeLogDir();
            WebAppMain.connectScouterCollector();
        }
        ServletContextHandler handler = WebAppMain.setWebHttpApiHandler();
        return handler;
    }
}

