/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.request;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import scouter.lang.constants.ParamConstant;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.model.KeyValueData;

public class SetKvBulkRequest {
    private int serverId;
    @NotNull
    private List<KeyValueData> kvList;
    private long ttl = ParamConstant.TTL_PERMANENT;

    public void setServerId(int serverId) {
        this.serverId = ServerManager.getInstance().getServerIfNullDefault(serverId).getId();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (KeyValueData data : this.kvList) {
            map.put(data.getKey(), data.getValue().toString());
        }
        return map;
    }

    public Map<String, String> toMapPadKeyPrefix(String keyPrefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (KeyValueData data : this.kvList) {
            map.put(keyPrefix + data.getKey(), data.getValue().toString());
        }
        return map;
    }

    public int getServerId() {
        return this.serverId;
    }

    public List<KeyValueData> getKvList() {
        return this.kvList;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setKvList(List<KeyValueData> kvList) {
        this.kvList = kvList;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public String toString() {
        return "SetKvBulkRequest(serverId=" + this.getServerId() + ", kvList=" + this.getKvList() + ", ttl=" + this.getTtl() + ")";
    }
}

