/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.task;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import scouter.agent.Logger;
import scouter.agent.counter.CounterBasket;
import scouter.agent.counter.anotation.Counter;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.value.ListValue;

public class FDInfo {
    public static boolean availableFdInfo = true;

    @Counter
    public void process(CounterBasket pw) {
        if (!availableFdInfo) {
            return;
        }
        try {
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            if (os instanceof UnixOperatingSystemMXBean) {
                UnixOperatingSystemMXBean unixOs = (UnixOperatingSystemMXBean)os;
                long max = unixOs.getMaxFileDescriptorCount();
                long open = unixOs.getOpenFileDescriptorCount();
                ListValue fdUsage = new ListValue();
                fdUsage.add(max);
                fdUsage.add(open);
                PerfCounterPack p = pw.getPack((byte)1);
                p.put("FdUsage", fdUsage);
            } else {
                availableFdInfo = false;
            }
        }
        catch (Throwable th) {
            Logger.println(th.getMessage());
            availableFdInfo = false;
        }
    }
}

