/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import java.util.List;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.util.ZZ;
import scouterx.webapp.layer.service.CounterService;
import scouterx.webapp.model.scouter.SCounter;
import scouterx.webapp.request.CounterAvgRequestByObjHashes;
import scouterx.webapp.request.CounterAvgRequestByType;
import scouterx.webapp.request.CounterRequestByObjHashes;
import scouterx.webapp.request.CounterRequestByType;
import scouterx.webapp.request.LatestCounterRequestByObjHashes;
import scouterx.webapp.request.LatestCounterRequestByType;
import scouterx.webapp.view.AvgCounterView;
import scouterx.webapp.view.CommonResultView;
import scouterx.webapp.view.CounterView;

@Path(value="/v1/counter")
@Api(value="Counter")
@Singleton
@Produces(value={"application/json"})
public class CounterController {
    @Context
    HttpServletRequest servletRequest;
    private final CounterService counterService = new CounterService();

    @GET
    @Path(value="/realTime/{counters}/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<SCounter>> retrieveRealTimeCountersByObjType(@PathParam(value="objType") @Valid @NotNull String objType, @PathParam(value="counters") @Valid @NotNull String counterNameByCommaSeparator, @QueryParam(value="serverId") int serverId) {
        List<SCounter> counterList = this.counterService.retrieveRealTimeCountersByObjType(objType, ZZ.splitParamStringSet(counterNameByCommaSeparator), ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(counterList);
    }

    @GET
    @Path(value="/realTime/{counters}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<SCounter>> retrieveRealTimeCountersByObjHashes(@QueryParam(value="objHashes") @Valid @NotNull String objHashes, @PathParam(value="counters") @Valid @NotNull String counterNameByCommaSeparator, @QueryParam(value="serverId") int serverId) {
        List<SCounter> counterList = this.counterService.retrieveRealTimeCountersByObjHashes(ZZ.splitParamAsIntegerSet(objHashes), ZZ.splitParamStringSet(counterNameByCommaSeparator), ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(counterList);
    }

    @GET
    @Path(value="/{counter}/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<CounterView>> retrieveCounterByObjType(@BeanParam @Valid CounterRequestByType request) {
        request.validate();
        List<CounterView> counterView = this.counterService.retrieveCounterByObjType(request);
        return CommonResultView.success(counterView);
    }

    @GET
    @Path(value="/{counter}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<CounterView>> retrieveCounterByObjHashes(@BeanParam @Valid CounterRequestByObjHashes request) {
        request.validate();
        List<CounterView> counterView = this.counterService.retrieveCounterByObjHashes(request);
        return CommonResultView.success(counterView);
    }

    @GET
    @Path(value="/stat/{counter}/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<AvgCounterView>> retrieveAvgCounterByObjType(@BeanParam @Valid CounterAvgRequestByType request) {
        List<AvgCounterView> counterViewList = this.counterService.retrieveAvgCounterByObjType(request);
        return CommonResultView.success(counterViewList);
    }

    @GET
    @Path(value="/stat/{counter}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<AvgCounterView>> retrieveAvgCounterByObjHash(@BeanParam @Valid CounterAvgRequestByObjHashes request) {
        List<AvgCounterView> counterViewList = this.counterService.retrieveAvgCounterByObjHashes(request);
        return CommonResultView.success(counterViewList);
    }

    @GET
    @Path(value="/{counter}/latest/{latestSec}/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<CounterView>> retrieveLatestCounterByObjType(@BeanParam @Valid LatestCounterRequestByType request) {
        request.validate();
        List<CounterView> counterView = this.counterService.retrieveCounterByObjType(request.toCounterRequestByType());
        return CommonResultView.success(counterView);
    }

    @GET
    @Path(value="/{counter}/latest/{latestSec}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<CounterView>> retrieveLatestCounterByObjHash(@BeanParam @Valid LatestCounterRequestByObjHashes request) {
        request.validate();
        List<CounterView> counterView = this.counterService.retrieveCounterByObjHashes(request.toCounterRequestByObjHashes());
        return CommonResultView.success(counterView);
    }
}

