/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.summary;

import java.util.List;
import scouter.lang.pack.AlertLevelEnum;
import scouter.lang.value.ListValue;
import scouter.util.DateTimeHelper;
import scouterx.webapp.framework.dto.DateAndMapPack;
import scouterx.webapp.model.summary.Summary;
import scouterx.webapp.model.summary.SummaryItem;

public class AlertSummaryItem
extends SummaryItem<AlertSummaryItem> {
    private AlertLevelEnum level;

    public AlertSummaryItem(int summaryKey, String summaryKeyName, int count, AlertLevelEnum level) {
        this.summaryKey = summaryKey;
        this.summaryKeyName = summaryKeyName;
        this.count = count;
        this.level = level;
    }

    @Override
    public void merge(AlertSummaryItem newItem) {
        this.setCount(this.getCount() + newItem.getCount());
    }

    @Override
    public Summary<AlertSummaryItem> toSummary(List<DateAndMapPack> dnmPackList, int serverId) {
        Summary<AlertSummaryItem> summary = new Summary<AlertSummaryItem>();
        for (DateAndMapPack dnmPack : dnmPackList) {
            long date = DateTimeHelper.getDefault().yyyymmdd(dnmPack.getYyyymmdd());
            ListValue idList = dnmPack.getMapPack().getList("id");
            ListValue titleList = dnmPack.getMapPack().getList("title");
            ListValue countList = dnmPack.getMapPack().getList("count");
            ListValue levelList = dnmPack.getMapPack().getList("level");
            for (int i = 0; i < idList.size(); ++i) {
                AlertSummaryItem item = AlertSummaryItem.builder().summaryKey(idList.getInt(i)).summaryKeyName(titleList.getString(i)).count(countList.getInt(i)).level(AlertLevelEnum.of((int)levelList.getInt(i))).build();
                summary.merge(item);
            }
        }
        return summary;
    }

    public static AlertSummaryItemBuilder builder() {
        return new AlertSummaryItemBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertSummaryItem)) {
            return false;
        }
        AlertSummaryItem other = (AlertSummaryItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertLevelEnum this$level = this.getLevel();
        AlertLevelEnum other$level = other.getLevel();
        return !(this$level == null ? other$level != null : !this$level.equals(other$level));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AlertSummaryItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        AlertLevelEnum $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        return result;
    }

    public AlertLevelEnum getLevel() {
        return this.level;
    }

    public void setLevel(AlertLevelEnum level) {
        this.level = level;
    }

    @Override
    public String toString() {
        return "AlertSummaryItem(level=" + this.getLevel() + ")";
    }

    public AlertSummaryItem() {
    }

    public static class AlertSummaryItemBuilder {
        private int summaryKey;
        private String summaryKeyName;
        private int count;
        private AlertLevelEnum level;

        AlertSummaryItemBuilder() {
        }

        public AlertSummaryItemBuilder summaryKey(int summaryKey) {
            this.summaryKey = summaryKey;
            return this;
        }

        public AlertSummaryItemBuilder summaryKeyName(String summaryKeyName) {
            this.summaryKeyName = summaryKeyName;
            return this;
        }

        public AlertSummaryItemBuilder count(int count) {
            this.count = count;
            return this;
        }

        public AlertSummaryItemBuilder level(AlertLevelEnum level) {
            this.level = level;
            return this;
        }

        public AlertSummaryItem build() {
            return new AlertSummaryItem(this.summaryKey, this.summaryKeyName, this.count, this.level);
        }

        public String toString() {
            return "AlertSummaryItem.AlertSummaryItemBuilder(summaryKey=" + this.summaryKey + ", summaryKeyName=" + this.summaryKeyName + ", count=" + this.count + ", level=" + this.level + ")";
        }
    }
}

