/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.request;

import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.ws.rs.QueryParam;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.util.ZZ;
import scouterx.webapp.request.CounterRequestByObjHashes;
import scouterx.webapp.request.LatestCounterRequest;

public class LatestCounterRequestByObjHashes
extends LatestCounterRequest {
    @NotNull
    Set<Integer> objHashes;

    @QueryParam(value="objHashes")
    public void setObjHashes(String objHashes) {
        this.objHashes = ZZ.splitParamAsIntegerSet(objHashes);
    }

    public CounterRequestByObjHashes toCounterRequestByObjHashes() {
        CounterRequestByObjHashes toType = new CounterRequestByObjHashes();
        toType.setObjHashes(this.objHashes);
        toType.setServerId(this.getServerId());
        toType.setCounter(this.getCounter());
        Server server = ServerManager.getInstance().getServerIfNullDefault(this.getServerId());
        long end = server.getCurrentTime();
        long start = end - (long)(this.getLatestSec() * 1000);
        toType.setStartTimeMillis(start);
        toType.setEndTimeMillis(end);
        return toType;
    }

    public Set<Integer> getObjHashes() {
        return this.objHashes;
    }

    @Override
    public String toString() {
        return "LatestCounterRequestByObjHashes(objHashes=" + this.getObjHashes() + ")";
    }
}

