/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import scouter.server.ConfObserver;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.core.CoreRun;
import scouter.server.db.DBCtr;
import scouter.server.db.XLogWR;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.SystemUtil;
import scouter.util.ThreadUtil;

public class AutoDeleteScheduler
extends Thread {
    private static AutoDeleteScheduler instance = null;
    private static final long CHECK_INTERVAL = 60000L;
    Configure conf = Configure.getInstance();
    boolean canRun;
    int maxPercent;
    int retainDays;
    int retainXlogDays;
    int retainCounterDays;
    String lastCheckDate;
    Set<String> deletedProfileDays = new HashSet<String>();
    Set<String> deletedXLogDays = new HashSet<String>();
    Set<String> deletedDays = new HashSet<String>();
    File dbDir;

    public static final synchronized AutoDeleteScheduler getInstance() {
        if (instance == null) {
            instance = new AutoDeleteScheduler();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    private AutoDeleteScheduler() {
        this.applyConf();
        this.dbDir = new File(DBCtr.getRootPath());
        ConfObserver.put(AutoDeleteScheduler.class.getName(), new Runnable(){

            @Override
            public void run() {
                if (AutoDeleteScheduler.this.conf.mgr_purge_enabled != AutoDeleteScheduler.this.canRun || AutoDeleteScheduler.this.conf.mgr_purge_disk_usage_pct != AutoDeleteScheduler.this.maxPercent || AutoDeleteScheduler.this.conf.mgr_purge_profile_keep_days != AutoDeleteScheduler.this.retainDays || AutoDeleteScheduler.this.conf.mgr_purge_xlog_keep_days != AutoDeleteScheduler.this.retainXlogDays || AutoDeleteScheduler.this.conf.mgr_purge_counter_keep_days != AutoDeleteScheduler.this.retainCounterDays) {
                    AutoDeleteScheduler.this.applyConf();
                    AutoDeleteScheduler.this.lastCheckDate = null;
                    AutoDeleteScheduler.this.deletedProfileDays.clear();
                    AutoDeleteScheduler.this.deletedXLogDays.clear();
                    AutoDeleteScheduler.this.deletedDays.clear();
                }
            }
        });
    }

    private void applyConf() {
        this.canRun = this.conf.mgr_purge_enabled;
        this.maxPercent = this.conf.mgr_purge_disk_usage_pct;
        this.retainDays = this.conf.mgr_purge_profile_keep_days;
        this.retainXlogDays = this.conf.mgr_purge_xlog_keep_days;
        this.retainCounterDays = this.conf.mgr_purge_counter_keep_days;
    }

    @Override
    public void run() {
        while (CoreRun.running()) {
            if (this.conf.mgr_purge_enabled) {
                int retainCounterDays;
                int retainXLogDays;
                int retainProfileDays;
                int maxPercent;
                String today = DateUtil.yyyymmdd();
                if (!SystemUtil.IS_JAVA_1_5 && (maxPercent = this.conf.mgr_purge_disk_usage_pct) > 0) {
                    String yyyymmdd;
                    long totalSpace = this.dbDir.getTotalSpace();
                    long freeSpace = this.dbDir.getUsableSpace();
                    double freePercent = (double)freeSpace * 100.0 / (double)totalSpace;
                    while (100.0 - freePercent > (double)maxPercent - (double)(100 - maxPercent) * 0.4 && (yyyymmdd = this.getLongAgoDate(this.deletedProfileDays)) != null && !today.equals(yyyymmdd)) {
                        this.deleteData(yyyymmdd, Mode.PROFILE);
                        freeSpace = this.dbDir.getUsableSpace();
                        freePercent = (double)freeSpace * 100.0 / (double)totalSpace;
                        this.deletedProfileDays.add(yyyymmdd);
                        Logger.println("S206-1", "[purge profile by][capacity]" + yyyymmdd);
                        Logger.println("S206-1", "* option : conf.mgr_purge_disk_usage_pct : " + this.conf.mgr_purge_disk_usage_pct);
                    }
                    while (100.0 - freePercent > (double)maxPercent - (double)(100 - maxPercent) * 0.2 && (yyyymmdd = this.getLongAgoDate(this.deletedXLogDays)) != null && !today.equals(yyyymmdd)) {
                        this.deleteData(yyyymmdd, Mode.XLOG);
                        freeSpace = this.dbDir.getUsableSpace();
                        freePercent = (double)freeSpace * 100.0 / (double)totalSpace;
                        this.deletedXLogDays.add(yyyymmdd);
                        Logger.println("S206-2", "[purge xlog by][capacity]" + yyyymmdd);
                        Logger.println("S206-2", "* option : conf.mgr_purge_disk_usage_pct : " + this.conf.mgr_purge_disk_usage_pct);
                    }
                    while (100.0 - freePercent > (double)maxPercent && (yyyymmdd = this.getLongAgoDate(this.deletedDays)) != null && !today.equals(yyyymmdd)) {
                        this.deleteData(yyyymmdd, Mode.ALL);
                        freeSpace = this.dbDir.getUsableSpace();
                        freePercent = (double)freeSpace * 100.0 / (double)totalSpace;
                        this.deletedDays.add(yyyymmdd);
                        Logger.println("S206-3", "[purge counters by][capacity]" + yyyymmdd);
                        Logger.println("S206-3", "* option : conf.mgr_purge_disk_usage_pct : " + this.conf.mgr_purge_disk_usage_pct);
                    }
                }
                if ((retainProfileDays = this.conf.mgr_purge_profile_keep_days) > 0) {
                    this.lastCheckDate = "";
                    if (!today.equals(this.lastCheckDate)) {
                        String yyyymmdd;
                        this.lastCheckDate = today;
                        int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainProfileDays));
                        while ((yyyymmdd = this.getLongAgoDate(this.deletedProfileDays)) != null && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                            this.deleteData(yyyymmdd, Mode.PROFILE);
                            this.deletedProfileDays.add(yyyymmdd);
                            Logger.println("S206-4", "[purge profile by][day limit]" + yyyymmdd);
                            Logger.println("S206-4", "* option : conf.mgr_purge_profile_keep_days : " + this.conf.mgr_purge_profile_keep_days);
                        }
                    }
                }
                if ((retainXLogDays = this.conf.mgr_purge_xlog_keep_days) > 0) {
                    this.lastCheckDate = "";
                    if (!today.equals(this.lastCheckDate)) {
                        String yyyymmdd;
                        this.lastCheckDate = today;
                        int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainXLogDays));
                        while ((yyyymmdd = this.getLongAgoDate(this.deletedXLogDays)) != null && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                            this.deleteData(yyyymmdd, Mode.XLOG);
                            this.deletedXLogDays.add(yyyymmdd);
                            Logger.println("S206-5", "[purge xlog by][day limit]" + yyyymmdd);
                            Logger.println("S206-5", "* option : conf.mgr_purge_xlog_keep_days : " + this.conf.mgr_purge_xlog_keep_days);
                        }
                    }
                }
                if ((retainCounterDays = this.conf.mgr_purge_counter_keep_days) > 0) {
                    this.lastCheckDate = "";
                    if (!today.equals(this.lastCheckDate)) {
                        String yyyymmdd;
                        this.lastCheckDate = today;
                        int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainCounterDays));
                        while ((yyyymmdd = this.getLongAgoDate(this.deletedDays)) != null && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                            this.deleteData(yyyymmdd, Mode.ALL);
                            this.deletedDays.add(yyyymmdd);
                            Logger.println("S206-6", "[purge counters by][day limit]" + yyyymmdd);
                            Logger.println("S206-6", "* option : conf.mgr_purge_counter_keep_days : " + this.conf.mgr_purge_counter_keep_days);
                        }
                    }
                }
            }
            ThreadUtil.sleep(60000L);
        }
    }

    private void deleteData(String yyyymmdd, Mode mode) {
        try {
            File f = null;
            if (mode == Mode.ALL) {
                f = new File(this.dbDir, yyyymmdd);
                this.deleteFiles(f);
            } else if (mode == Mode.XLOG) {
                f = new File(this.dbDir, yyyymmdd + XLogWR.dir());
                this.deleteFiles(f);
            } else if (mode == Mode.PROFILE) {
                f = new File(this.dbDir, yyyymmdd + XLogWR.dir() + "/xlog.profile");
                this.deleteFiles(f);
                f = new File(this.dbDir, yyyymmdd + XLogWR.dir() + "/xlog_profile.hfile");
                this.deleteFiles(f);
                f = new File(this.dbDir, yyyymmdd + XLogWR.dir() + "/xlog_profile.kfile");
                this.deleteFiles(f);
            } else {
                throw new IllegalArgumentException("Not expected Mode : " + (Object)((Object)mode));
            }
            Logger.println("S206", "* Auto deletion... " + yyyymmdd + " mode : " + mode.name());
        }
        catch (Throwable th) {
            Logger.println("S207", "Failed auto deletion... " + yyyymmdd + " mode : " + mode.name() + "  " + th.toString());
        }
    }

    void deleteFiles(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File c : file.listFiles()) {
                this.deleteFiles(c);
            }
        }
        file.delete();
    }

    private String getLongAgoDate(Set<String> exceptDays) {
        File[] dirs = this.dbDir.listFiles();
        if (dirs == null || dirs.length < 1) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < dirs.length; ++i) {
            File f = dirs[i];
            String name = f.getName();
            if (!f.isDirectory() || name.indexOf("0000") != -1 || exceptDays.contains(name)) continue;
            try {
                list.add(Integer.valueOf(f.getName()));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (list.size() == 0) {
            return null;
        }
        Collections.sort(list);
        return String.valueOf(list.get(0));
    }

    static enum Mode {
        PROFILE,
        XLOG,
        ALL;

    }
}

