/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core.app;

import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scouter.server.core.app.PerfStat;
import scouter.util.MeteringUtil;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u0017\taQ*\u001a;feN+'O^5dK*\u00111\u0001B\u0001\u0004CB\u0004(BA\u0003\u0007\u0003\u0011\u0019wN]3\u000b\u0005\u001dA\u0011AB:feZ,'OC\u0001\n\u0003\u001d\u00198m\\;uKJ\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0007?\u001e\u0014x.\u001e9\u0011\u00055)\u0012B\u0001\f\u000f\u0005\rIe\u000e\u001e\u0005\u00061\u0001!\t!G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005ia\u0002CA\u000e\u0001\u001b\u0005\u0011\u0001\"B\n\u0018\u0001\u0004!\u0002b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0006OJ|W\u000f]\u000b\u0002)!1\u0011\u0005\u0001Q\u0001\nQ\taa\u001a:pkB\u0004c\u0001B\u0012\u0001\u0001\u0011\u0012aAQ;dW\u0016$8C\u0001\u0012\r\u0011\u0015A\"\u0005\"\u0001')\u00059\u0003C\u0001\u0015#\u001b\u0005\u0001\u0001b\u0002\u0016#\u0001\u0004%\taH\u0001\u0006G>,h\u000e\u001e\u0005\bY\t\u0002\r\u0011\"\u0001.\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0002/cA\u0011QbL\u0005\u0003a9\u0011A!\u00168ji\"9!gKA\u0001\u0002\u0004!\u0012a\u0001=%c!1AG\tQ!\nQ\taaY8v]R\u0004\u0003b\u0002\u001c#\u0001\u0004%\taH\u0001\u0006KJ\u0014xN\u001d\u0005\bq\t\u0002\r\u0011\"\u0001:\u0003%)'O]8s?\u0012*\u0017\u000f\u0006\u0002/u!9!gNA\u0001\u0002\u0004!\u0002B\u0002\u001f#A\u0003&A#\u0001\u0004feJ|'\u000f\t\u0005\b}\t\u0002\r\u0011\"\u0001@\u0003\u0011!\u0018.\\3\u0016\u0003\u0001\u0003\"!D!\n\u0005\ts!\u0001\u0002'p]\u001eDq\u0001\u0012\u0012A\u0002\u0013\u0005Q)\u0001\u0005uS6,w\fJ3r)\tqc\tC\u00043\u0007\u0006\u0005\t\u0019\u0001!\t\r!\u0013\u0003\u0015)\u0003A\u0003\u0015!\u0018.\\3!\u0011\u001dQ\u0005A1A\u0005\u0002-\u000bQ!\\3uKJ,\u0012\u0001\u0014\t\u0004\u001bB;S\"\u0001(\u000b\u0005=C\u0011\u0001B;uS2L!!\u0015(\u0003\u00195+G/\u001a:j]\u001e,F/\u001b7\t\rM\u0003\u0001\u0015!\u0003M\u0003\u0019iW\r^3sA!)Q\u000b\u0001C\u0001-\u0006\u0019\u0011\r\u001a3\u0015\u00079:\u0016\fC\u0003Y)\u0002\u0007\u0001)A\u0004fY\u0006\u00048/\u001a3\t\u000bi#\u0006\u0019A.\u0002\u0007\u0015\u0014(\u000f\u0005\u0002\u000e9&\u0011QL\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015y\u0006\u0001\"\u0001a\u0003\u00199W\r\u001e+Q'R\u0011\u0011\r\u001a\t\u0003\u001b\tL!a\u0019\b\u0003\u000b\u0019cw.\u0019;\t\u000b\u0015t\u0006\u0019\u0001\u000b\u0002\rA,'/[8e\u0011\u00159\u0007\u0001\"\u0001i\u000399W\r^#mCB\u001cX\r\u001a+j[\u0016$\"\u0001F5\t\u000b\u00154\u0007\u0019\u0001\u000b\t\u000b-\u0004A\u0011\u00017\u0002\u0011\u001d,G/\u0012:s_J$\"!Y7\t\u000b\u0015T\u0007\u0019\u0001\u000b\t\u000b=\u0004A\u0011\u00019\u0002\u001f\u001d,GoU3sm&\u001cWmQ8v]R$\"\u0001F9\t\u000b\u0015t\u0007\u0019\u0001\u000b\t\u000bM\u0004A\u0011\u0001;\u0002\u001f\u001d,GoU3sm&\u001cW-\u0012:s_J$\"\u0001F;\t\u000b\u0015\u0014\b\u0019\u0001\u000b\t\u000b]\u0004A\u0011\u0001=\u0002\u0017\u001d,G\u000fU3sMN#\u0018\r\u001e\u000b\u0003sr\u0004\"a\u0007>\n\u0005m\u0014!\u0001\u0003)fe\u001a\u001cF/\u0019;\t\u000b\u00154\b\u0019\u0001\u000b")
public class MeterService {
    private final int group;
    private final MeteringUtil<Bucket> meter;

    public int group() {
        return this.group;
    }

    public MeteringUtil<Bucket> meter() {
        return this.meter;
    }

    public synchronized void add(long elapsed, boolean err) {
        Bucket b = this.meter().getCurrentBucket();
        b.count_$eq(b.count() + 1);
        b.time_$eq(b.time() + elapsed);
        if (err) {
            b.error_$eq(b.error() + 1);
        }
    }

    public float getTPS(int period) {
        IntRef sum = IntRef.create((int)0);
        int p = this.meter().search(period, new MeteringUtil.Handler<Bucket>(this, sum){
            private final IntRef sum$1;

            public void process(Bucket b) {
                this.sum$1.elem += b.count();
            }
            {
                this.sum$1 = sum$1;
            }
        });
        return (float)((double)sum.elem / (double)period);
    }

    public int getElapsedTime(int period) {
        LongRef sum = LongRef.create((long)0L);
        IntRef cnt = IntRef.create((int)0);
        this.meter().search(period, new MeteringUtil.Handler<Bucket>(this, sum, cnt){
            private final LongRef sum$2;
            private final IntRef cnt$1;

            public void process(Bucket b) {
                this.sum$2.elem += b.time();
                this.cnt$1.elem += b.count();
            }
            {
                this.sum$2 = sum$2;
                this.cnt$1 = cnt$1;
            }
        });
        return cnt.elem == 0 ? 0 : (int)(sum.elem / (long)cnt.elem);
    }

    public float getError(int period) {
        IntRef cnt = IntRef.create((int)0);
        IntRef err = IntRef.create((int)0);
        this.meter().search(period, new MeteringUtil.Handler<Bucket>(this, cnt, err){
            private final IntRef cnt$2;
            private final IntRef err$1;

            public void process(Bucket b) {
                this.cnt$2.elem += b.count();
                this.err$1.elem += b.error();
            }
            {
                this.cnt$2 = cnt$2;
                this.err$1 = err$1;
            }
        });
        return cnt.elem == 0 ? 0.0f : (float)((double)((float)err.elem / (float)cnt.elem) * 100.0);
    }

    public int getServiceCount(int period) {
        IntRef sum = IntRef.create((int)0);
        this.meter().search(period, new MeteringUtil.Handler<Bucket>(this, sum){
            private final IntRef sum$3;

            public void process(Bucket b) {
                this.sum$3.elem += b.count();
            }
            {
                this.sum$3 = sum$3;
            }
        });
        return sum.elem;
    }

    public int getServiceError(int period) {
        IntRef sum = IntRef.create((int)0);
        this.meter().search(period, new MeteringUtil.Handler<Bucket>(this, sum){
            private final IntRef sum$4;

            public void process(Bucket b) {
                this.sum$4.elem += b.error();
            }
            {
                this.sum$4 = sum$4;
            }
        });
        return sum.elem;
    }

    public PerfStat getPerfStat(int period) {
        PerfStat stat = new PerfStat();
        this.meter().search(period, new MeteringUtil.Handler<Bucket>(this, stat){
            private final PerfStat stat$1;

            public void process(Bucket b) {
                this.stat$1.count_$eq(this.stat$1.count() + b.count());
                this.stat$1.elapsed_$eq(this.stat$1.elapsed() + b.time());
                this.stat$1.error_$eq(this.stat$1.error() + b.error());
            }
            {
                this.stat$1 = stat$1;
            }
        });
        return stat;
    }

    public MeterService(int _group) {
        this.group = _group;
        this.meter = new MeteringUtil<Bucket>(this){
            private final /* synthetic */ MeterService $outer;

            public Bucket create() {
                return this.$outer.new Bucket();
            }

            public void clear(Bucket o) {
                o.count_$eq(0);
                o.error_$eq(0);
                o.time_$eq(0L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public class Bucket {
        private int count;
        private int error;
        private long time;

        public int count() {
            return this.count;
        }

        public void count_$eq(int x$1) {
            this.count = x$1;
        }

        public int error() {
            return this.error;
        }

        public void error_$eq(int x$1) {
            this.error = x$1;
        }

        public long time() {
            return this.time;
        }

        public void time_$eq(long x$1) {
            this.time = x$1;
        }

        public /* synthetic */ MeterService scouter$server$core$app$MeterService$Bucket$$$outer() {
            return MeterService.this;
        }

        public Bucket() {
            if (MeterService.this == null) {
                throw null;
            }
            this.count = 0;
            this.error = 0;
            this.time = 0L;
        }
    }
}

