/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core.app;

import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scouter.lang.Family;
import scouter.lang.ObjectType;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.PerfCounterPack;
import scouter.server.CounterManager;
import scouter.server.core.AgentManager$;
import scouter.server.core.CoreRun$;
import scouter.server.core.app.ObjectCpuChecker;
import scouter.server.netio.AgentCall$;
import scouter.server.util.ThreadScala$;
import scouter.util.RequestQueue;

public final class ObjectCpuChecker$ {
    public static final ObjectCpuChecker$ MODULE$;
    private final RequestQueue<ObjectPack> queue;
    private final CounterManager counterManager;
    private final HashMap<String, ObjectCpuChecker.ObjectCpuStatus> objectCpuMap;

    static {
        new ObjectCpuChecker$();
    }

    public RequestQueue<ObjectPack> queue() {
        return this.queue;
    }

    public CounterManager counterManager() {
        return this.counterManager;
    }

    public HashMap<String, ObjectCpuChecker.ObjectCpuStatus> objectCpuMap() {
        return this.objectCpuMap;
    }

    public void checkCpu(PerfCounterPack pack) {
        if (pack.timetype != 1) {
            return;
        }
        ObjectPack agent = AgentManager$.MODULE$.getAgent(pack.objName);
        if (agent == null) {
            return;
        }
        String objType2 = agent.objType;
        if (objType2 == null) {
            return;
        }
        ObjectType _objectType = this.counterManager().getCounterEngine().getObjectType(objType2);
        if (_objectType == null) {
            return;
        }
        Family _objFamily = _objectType.getFamily();
        if (_objFamily == null) {
            return;
        }
        String objFamily = _objFamily.getName();
        if ("javaee".equals(objFamily)) {
            ObjectCpuChecker.ObjectCpuStatus cpuStatus = (ObjectCpuChecker.ObjectCpuStatus)this.objectCpuMap().getOrElse((Object)pack.objName, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ObjectCpuChecker.ObjectCpuStatus apply() {
                    return new ObjectCpuChecker.ObjectCpuStatus();
                }
            });
            Object object = cpuStatus.firstOccurenceTime() < 0L ? this.objectCpuMap().put((Object)pack.objName, (Object)cpuStatus) : BoxedUnit.UNIT;
            if (!agent.tags.getBoolean("ADC")) {
                cpuStatus.clear();
                return;
            }
            int duration = agent.tags.getInt("ADC_D");
            int threshold = agent.tags.getInt("ADC_TH");
            if (cpuStatus.firstOccurenceTime() > 0L && cpuStatus.firstOccurenceTime() < pack.time - (long)(duration * 2)) {
                cpuStatus.clear();
                return;
            }
            if (pack.data.containsKey("ProcCpu")) {
                if ((float)threshold < pack.data.getFloat("ProcCpu")) {
                    cpuStatus.overCount_$eq(cpuStatus.overCount() + 1);
                    if (cpuStatus.firstOccurenceTime() <= 0L) {
                        cpuStatus.firstOccurenceTime_$eq(pack.time);
                    }
                    if (cpuStatus.firstOccurenceTime() < pack.time - (long)duration) {
                        cpuStatus.clear();
                        this.queue().put(agent);
                    }
                } else {
                    cpuStatus.clear();
                }
            } else {
                return;
            }
        }
    }

    private ObjectCpuChecker$() {
        MODULE$ = this;
        this.queue = new RequestQueue(100);
        ThreadScala$.MODULE$.startDaemon("scouter.server.app.ObjectCpuChecker.invokeDumpOnAgent", (Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return CoreRun$.MODULE$.running();
            }
        }, (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ObjectPack objectPack = ObjectCpuChecker$.MODULE$.queue().get();
                MapPack mapPack = new MapPack();
                mapPack.put("objHash", objectPack.objHash);
                mapPack.put("TRIGGER_DUMP_REASON", "TRIGGER_DUMP_REASON_TYPE_CPU_EXCEEDED");
                AgentCall$.MODULE$.call(objectPack, "TRIGGER_THREAD_DUMPS_FROM_CONDITIONS", mapPack);
            }
        });
        this.counterManager = CounterManager.getInstance();
        this.objectCpuMap = new HashMap();
    }
}

