/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core.app;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.lang.CounterKey;
import scouter.lang.pack.XLogPack;
import scouter.lang.value.DecimalValue;
import scouter.server.Logger$;
import scouter.server.core.CoreRun$;
import scouter.server.core.app.MeterService;
import scouter.server.core.app.PerfStat;
import scouter.server.core.app.XLogGroupPerf;
import scouter.server.db.DailyCounterWR$;
import scouter.server.util.EnumerScala$;
import scouter.server.util.ThreadScala$;
import scouter.util.DateUtil;
import scouter.util.IntKeyMap;
import scouter.util.IntSet;
import scouter.util.LinkedMap;
import scouter.util.RequestQueue;

public final class XLogGroupPerf$ {
    public static final XLogGroupPerf$ MODULE$;
    private final Timer timer;
    private final long stime;
    private final RequestQueue<XLogPack> queue;
    private ArrayList<XLogGroupPerf.Key> scouter$server$core$app$XLogGroupPerf$$emptySet;
    private final LinkedMap<XLogGroupPerf.Key, MeterService> scouter$server$core$app$XLogGroupPerf$$perfGroupTable;
    private Hashtable<XLogGroupPerf.Key, PerfStat> cachedPerfMap;
    private long lastBuildCacheTime;

    static {
        new XLogGroupPerf$();
    }

    public Timer timer() {
        return this.timer;
    }

    public long stime() {
        return this.stime;
    }

    public RequestQueue<XLogPack> queue() {
        return this.queue;
    }

    public void add(XLogPack p) {
        boolean ok = this.queue().put(p);
        if (!ok) {
            Logger$.MODULE$.println("S107", 10, "queue exceeded!!");
        }
    }

    public ArrayList<XLogGroupPerf.Key> scouter$server$core$app$XLogGroupPerf$$emptySet() {
        return this.scouter$server$core$app$XLogGroupPerf$$emptySet;
    }

    private void scouter$server$core$app$XLogGroupPerf$$emptySet_$eq(ArrayList<XLogGroupPerf.Key> x$1) {
        this.scouter$server$core$app$XLogGroupPerf$$emptySet = x$1;
    }

    public void scouter$server$core$app$XLogGroupPerf$$clearEmpty() {
        if (this.scouter$server$core$app$XLogGroupPerf$$emptySet().size() == 0) {
            return;
        }
        ArrayList<XLogGroupPerf.Key> list = this.scouter$server$core$app$XLogGroupPerf$$emptySet();
        this.scouter$server$core$app$XLogGroupPerf$$emptySet_$eq(new ArrayList<XLogGroupPerf.Key>());
        EnumerScala$.MODULE$.forward(list, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final MeterService apply(XLogGroupPerf.Key k) {
                return XLogGroupPerf$.MODULE$.scouter$server$core$app$XLogGroupPerf$$perfGroupTable().remove(k);
            }
        });
    }

    public LinkedMap<XLogGroupPerf.Key, MeterService> scouter$server$core$app$XLogGroupPerf$$perfGroupTable() {
        return this.scouter$server$core$app$XLogGroupPerf$$perfGroupTable;
    }

    public void scouter$server$core$app$XLogGroupPerf$$process(XLogPack p) {
        if (p.group == 0) {
            return;
        }
        this.calcGroup(new XLogGroupPerf.Key(p.objHash, p.group), p.elapsed, p.error != 0);
    }

    public void scouter$server$core$app$XLogGroupPerf$$save5m() {
        long now = System.currentTimeMillis() - 10000L;
        int date = Integer.parseInt(DateUtil.yyyymmdd(now));
        int hhmm = Integer.parseInt(DateUtil.hhmm(now));
        EnumerScala$.MODULE$.foreach(this.scouter$server$core$app$XLogGroupPerf$$perfGroupTable().keys(), new Serializable(date, hhmm){
            public static final long serialVersionUID = 0L;
            private final int date$1;
            private final int hhmm$1;

            public final void apply(XLogGroupPerf.Key key) {
                MeterService m = XLogGroupPerf$.MODULE$.scouter$server$core$app$XLogGroupPerf$$perfGroupTable().get(key);
                if (m != null) {
                    PerfStat p = m.getPerfStat(300);
                    Object object = p.count() == 0 ? BoxesRunTime.boxToBoolean((boolean)XLogGroupPerf$.MODULE$.scouter$server$core$app$XLogGroupPerf$$emptySet().add(key)) : BoxedUnit.UNIT;
                    CounterKey k = new CounterKey(key.objHash(), new StringBuilder().append((Object)"cnt:").append((Object)BoxesRunTime.boxToInteger((int)key.group())).toString(), 3);
                    DailyCounterWR$.MODULE$.add(this.date$1, k, this.hhmm$1, new DecimalValue(p.count()));
                    k = new CounterKey(key.objHash(), new StringBuilder().append((Object)"tm:").append((Object)BoxesRunTime.boxToInteger((int)key.group())).toString(), 3);
                    DailyCounterWR$.MODULE$.add(this.date$1, k, this.hhmm$1, new DecimalValue(p.elapsed()));
                    k = new CounterKey(key.objHash(), new StringBuilder().append((Object)"err:").append((Object)BoxesRunTime.boxToInteger((int)key.group())).toString(), 3);
                    DailyCounterWR$.MODULE$.add(this.date$1, k, this.hhmm$1, new DecimalValue(p.error()));
                }
            }
            {
                this.date$1 = date$1;
                this.hhmm$1 = hhmm$1;
            }
        });
    }

    private Hashtable<XLogGroupPerf.Key, PerfStat> cachedPerfMap() {
        return this.cachedPerfMap;
    }

    private void cachedPerfMap_$eq(Hashtable<XLogGroupPerf.Key, PerfStat> x$1) {
        this.cachedPerfMap = x$1;
    }

    private long lastBuildCacheTime() {
        return this.lastBuildCacheTime;
    }

    private void lastBuildCacheTime_$eq(long x$1) {
        this.lastBuildCacheTime = x$1;
    }

    private synchronized Hashtable<XLogGroupPerf.Key, PerfStat> build() {
        if (System.currentTimeMillis() < this.lastBuildCacheTime() + 1000L) {
            return this.cachedPerfMap();
        }
        Hashtable<XLogGroupPerf.Key, PerfStat> p = new Hashtable<XLogGroupPerf.Key, PerfStat>();
        Enumeration<XLogGroupPerf.Key> en = this.scouter$server$core$app$XLogGroupPerf$$perfGroupTable().keys();
        while (en.hasMoreElements()) {
            XLogGroupPerf.Key key = en.nextElement();
            MeterService m = this.scouter$server$core$app$XLogGroupPerf$$perfGroupTable().get(key);
            Object object = m == null ? BoxedUnit.UNIT : p.put(key, m.getPerfStat(30));
        }
        this.cachedPerfMap_$eq(p);
        this.lastBuildCacheTime_$eq(System.currentTimeMillis());
        return p;
    }

    public IntKeyMap<PerfStat> getGroupPerfStat(IntSet objSet) {
        Hashtable<XLogGroupPerf.Key, PerfStat> buildPerfMap = this.build();
        IntKeyMap<PerfStat> p = new IntKeyMap<PerfStat>();
        Enumeration<XLogGroupPerf.Key> en = buildPerfMap.keys();
        while (en.hasMoreElements()) {
            Object object;
            XLogGroupPerf.Key key = en.nextElement();
            if (objSet != null && !objSet.contains(key.objHash())) continue;
            PerfStat m = buildPerfMap.get(key);
            PerfStat outPerf = p.get(key.group());
            if (outPerf == null) {
                outPerf = new PerfStat();
                object = p.put(key.group(), outPerf);
            } else {
                object = BoxedUnit.UNIT;
            }
            outPerf.add(m);
        }
        return p;
    }

    private MeterService calcGroup(XLogGroupPerf.Key key, long elapsed, boolean error) {
        Object object;
        MeterService meter = this.scouter$server$core$app$XLogGroupPerf$$perfGroupTable().get(key);
        if (meter == null) {
            meter = new MeterService(key.group());
            object = this.scouter$server$core$app$XLogGroupPerf$$perfGroupTable().put(key, meter);
        } else {
            object = BoxedUnit.UNIT;
        }
        meter.add(elapsed, error);
        return meter;
    }

    private XLogGroupPerf$() {
        MODULE$ = this;
        this.timer = new Timer(true);
        this.stime = (System.currentTimeMillis() / 60000L + 1L) * 60000L;
        this.timer().scheduleAtFixedRate(new TimerTask(){

            public void run() {
                XLogGroupPerf$.MODULE$.scouter$server$core$app$XLogGroupPerf$$save5m();
            }
        }, new Date(this.stime()), 60000L);
        this.queue = new RequestQueue(CoreRun$.MODULE$.MAX_QUE_SIZE());
        ThreadScala$.MODULE$.startDaemon("scouter.server.core.app.XLogGroupPerf", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                while (CoreRun$.MODULE$.running()) {
                    XLogGroupPerf$.MODULE$.scouter$server$core$app$XLogGroupPerf$$clearEmpty();
                    XLogPack p = XLogGroupPerf$.MODULE$.queue().get();
                    try {
                        XLogGroupPerf$.MODULE$.scouter$server$core$app$XLogGroupPerf$$process(p);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                    break;
                }
                return;
            }
        });
        this.scouter$server$core$app$XLogGroupPerf$$emptySet = new ArrayList();
        this.scouter$server$core$app$XLogGroupPerf$$perfGroupTable = new LinkedMap().setMax(2000);
        this.cachedPerfMap = new Hashtable();
        this.lastBuildCacheTime = System.currentTimeMillis();
    }
}

