/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core.app;

import java.util.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.lang.pack.XLogPack;
import scouter.server.db.TextPermWR$;
import scouter.server.db.TextRD$;
import scouter.util.DateUtil;
import scouter.util.HashUtil;
import scouter.util.IntIntLinkedMap;
import scouter.util.IntLinkedSet;

public final class XLogGroupUtil$ {
    public static final XLogGroupUtil$ MODULE$;
    private final IntIntLinkedMap groupMap;
    private final HashSet<String> images;
    private final HashSet<String> statics;
    private final IntLinkedSet saved;
    private final int h2;
    private final int h3;
    private final int h4;
    private final int h5;

    static {
        new XLogGroupUtil$();
    }

    public IntIntLinkedMap groupMap() {
        return this.groupMap;
    }

    public void process(XLogPack p) {
        if (p.group != 0) {
            return;
        }
        p.group = this.makeGroupHash(p.service, p.endTime);
    }

    private int makeGroupHash(int service, long endtime) {
        String url;
        int groupHash = this.groupMap().get(service);
        Object object = groupHash == 0 || groupHash == 0 ? ((groupHash = this.getGroupHash(url = TextRD$.MODULE$.getString(DateUtil.yyyymmdd(endtime), "service", service))) != 0 ? BoxesRunTime.boxToInteger((int)this.groupMap().put(service, groupHash)) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        return groupHash;
    }

    private HashSet<String> images() {
        return this.images;
    }

    private HashSet<String> statics() {
        return this.statics;
    }

    private void add(int hash, String name) {
        TextPermWR$.MODULE$.add("group", hash, name);
    }

    private IntLinkedSet saved() {
        return this.saved;
    }

    private int h2() {
        return this.h2;
    }

    private int h3() {
        return this.h3;
    }

    private int h4() {
        return this.h4;
    }

    private int h5() {
        return this.h5;
    }

    public int getGroupHash(String url) {
        if (url == null) {
            return 0;
        }
        int x = url.lastIndexOf(46);
        if (x > 0) {
            String postfix = url.substring(x + 1).toLowerCase();
            if ("jsp".equals(postfix)) {
                return this.h2();
            }
            if (this.images().contains(postfix)) {
                return this.h3();
            }
            if (this.statics().contains(postfix)) {
                return this.h4();
            }
        }
        if (url.length() == 0 || url.equals("/")) {
            return this.h5();
        }
        int x1 = url.indexOf(47, 1);
        if (x1 < 0) {
            return this.h5();
        }
        String groupName = url.substring(0, x1);
        int grpHash = HashUtil.hash(groupName);
        if (!this.saved().contains(grpHash)) {
            this.add(grpHash, groupName);
        }
        return grpHash;
    }

    private XLogGroupUtil$() {
        MODULE$ = this;
        this.groupMap = new IntIntLinkedMap().setMax(50000);
        this.images = new HashSet();
        this.statics = new HashSet();
        this.images().add("gif");
        this.images().add("jpg");
        this.images().add("png");
        this.images().add("bmp");
        this.images().add("ico");
        this.statics().add("html");
        this.statics().add("htm");
        this.statics().add("css");
        this.statics().add("xml");
        this.statics().add("js");
        this.add(HashUtil.hash("*.jsp"), "*.jsp");
        this.add(HashUtil.hash("**"), "**");
        this.add(HashUtil.hash("images"), "images");
        this.add(HashUtil.hash("statics"), "statics");
        this.add(HashUtil.hash("/**"), "/**");
        this.saved = new IntLinkedSet().setMax(1000);
        this.h2 = HashUtil.hash("*.jsp");
        this.h3 = HashUtil.hash("images");
        this.h4 = HashUtil.hash("statics");
        this.h5 = HashUtil.hash("/**");
    }
}

