/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scouter.io.DataOutputX;
import scouter.lang.pack.AlertPack;
import scouter.server.Logger$;
import scouter.server.db.DBCtr$;
import scouter.server.db.alert.AlertIndex;
import scouter.server.db.alert.AlertIndex$;
import scouter.server.db.alert.AlertWriter;
import scouter.server.db.alert.AlertWriter$;
import scouter.server.util.OftenAction$;
import scouter.server.util.ThreadScala$;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.RequestQueue;

public final class AlertWR$ {
    public static final AlertWR$ MODULE$;
    private final RequestQueue<AlertPack> queue;
    private final String alert;
    private AlertIndex index;
    private AlertWriter writer;

    static {
        new AlertWR$();
    }

    public RequestQueue<AlertPack> queue() {
        return this.queue;
    }

    public String alert() {
        return this.alert;
    }

    public void add(AlertPack p) {
        boolean ok = this.queue().put(p);
        if (!ok) {
            Logger$.MODULE$.println("S121", 10, "queue exceeded!!");
        }
    }

    public AlertIndex index() {
        return this.index;
    }

    public void index_$eq(AlertIndex x$1) {
        this.index = x$1;
    }

    public AlertWriter writer() {
        return this.writer;
    }

    public void writer_$eq(AlertWriter x$1) {
        this.writer = x$1;
    }

    public void close() {
        FileUtil.close(this.index());
        FileUtil.close(this.writer());
        this.index_$eq(null);
        this.writer_$eq(null);
    }

    public void open(String date) {
        try {
            String path = this.getDBPath(date);
            File f = new File(path);
            Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
            String file = new StringBuilder().append((Object)path).append((Object)"/").append((Object)this.alert()).toString();
            this.index_$eq(AlertIndex$.MODULE$.open(file));
            this.writer_$eq(AlertWriter$.MODULE$.open(file));
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.close();
            return;
        }
    }

    public String getDBPath(String date) {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append("/").append(date).append("/alert");
        return sb.toString();
    }

    private AlertWR$() {
        MODULE$ = this;
        this.queue = new RequestQueue(DBCtr$.MODULE$.MAX_QUE_SIZE());
        this.alert = "alert";
        ThreadScala$.MODULE$.start("scouter.server.db.AlertWR", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                LongRef currentDateUnit = LongRef.create((long)0L);
                while (true) {
                    if (!DBCtr$.MODULE$.running()) {
                        AlertWR$.MODULE$.close();
                        return;
                    }
                    AlertPack p = AlertWR$.MODULE$.queue().get();
                    {
                        Object object;
                        if (currentDateUnit.elem != DateUtil.getDateUnit(p.time)) {
                            currentDateUnit.elem = DateUtil.getDateUnit(p.time);
                            AlertWR$.MODULE$.close();
                            AlertWR$.MODULE$.open(DateUtil.yyyymmdd(p.time));
                        }
                        if (AlertWR$.MODULE$.index() == null) {
                            AlertWR$.MODULE$.queue().clear();
                            Logger$.MODULE$.println("S120", 10, "can't open db");
                            object = BoxesRunTime.boxToBoolean((boolean)OftenAction$.MODULE$.act("AlertWR", 10, (Function0<BoxedUnit>)new Serializable(this, currentDateUnit){
                                public static final long serialVersionUID = 0L;
                                private final LongRef currentDateUnit$1;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    this.currentDateUnit$1.elem = 0L;
                                }
                                {
                                    this.currentDateUnit$1 = currentDateUnit$1;
                                }
                            }));
                            continue;
                        }
                        byte[] b = new DataOutputX().writePack(p).toByteArray();
                        long location = AlertWR$.MODULE$.writer().write(b);
                        AlertWR$.MODULE$.index().add(p.time, location);
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    break;
                }
            }
        });
        this.index = null;
        this.writer = null;
    }
}

