/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import java.util.HashMap;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.io.DataOutputX;
import scouter.lang.pack.ObjectPack;
import scouter.server.Logger$;
import scouter.server.db.DBCtr$;
import scouter.server.db.ObjectWR;
import scouter.server.db.obj.ObjectData$;
import scouter.server.db.obj.ObjectIndex$;
import scouter.server.util.ThreadScala$;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.RequestQueue;

public final class ObjectWR$ {
    public static final ObjectWR$ MODULE$;
    private final int BLOCK_SIZE;
    private final RequestQueue<ObjectWR.Order> queue;
    private ObjectWR.DBW curDbw;
    private HashMap<String, ObjectWR.DBW> dbs;

    static {
        new ObjectWR$();
    }

    public int BLOCK_SIZE() {
        return this.BLOCK_SIZE;
    }

    public RequestQueue<ObjectWR.Order> queue() {
        return this.queue;
    }

    public ObjectWR.Order createAdd(ObjectPack pack) {
        ObjectWR.Order o = new ObjectWR.Order();
        o.add_$eq(true);
        o.pack_$eq(pack);
        return o;
    }

    public ObjectWR.Order createRm(int hash) {
        ObjectWR.Order o = new ObjectWR.Order();
        o.delete_$eq(true);
        o.hash_$eq(hash);
        return o;
    }

    public void add(ObjectPack obj) {
        boolean ok = this.queue().put(this.createAdd(obj));
        if (!ok) {
            Logger$.MODULE$.println("S131", 10, "queue exceeded!!");
        }
    }

    public void remove(int objHash) {
        boolean ok = this.queue().put(this.createRm(objHash));
        if (!ok) {
            Logger$.MODULE$.println("S132", 10, "queue exceeded!!");
        }
    }

    public byte[] toBytes(ObjectPack m) {
        byte[] b = new DataOutputX().writePack(m).toByteArray();
        byte[] buff = new byte[this.BLOCK_SIZE()];
        System.arraycopy(b, 0, buff, 0, b.length);
        return buff;
    }

    public ObjectWR.DBW curDbw() {
        return this.curDbw;
    }

    public void curDbw_$eq(ObjectWR.DBW x$1) {
        this.curDbw = x$1;
    }

    public HashMap<String, ObjectWR.DBW> dbs() {
        return this.dbs;
    }

    public void dbs_$eq(HashMap<String, ObjectWR.DBW> x$1) {
        this.dbs = x$1;
    }

    public void close() {
        HashMap<String, ObjectWR.DBW> _dbs = this.dbs();
        this.dbs_$eq(new HashMap<String, ObjectWR.DBW>());
        for (String key : _dbs.keySet()) {
            FileUtil.close(_dbs.get(key));
        }
    }

    public ObjectWR.DBW open(String date) {
        try {
            String path = this.getDBPath(date);
            File f = new File(path);
            Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
            String file = new StringBuilder().append((Object)path).append((Object)"/obj").toString();
            ObjectWR.DBW dbw = new ObjectWR.DBW();
            dbw.index_$eq(ObjectIndex$.MODULE$.open(file));
            dbw.writer_$eq(ObjectData$.MODULE$.open(file));
            return dbw;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.close();
            return null;
        }
    }

    public String getDBPath(String date) {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append(new StringBuilder().append((Object)"/").append((Object)date).append((Object)"/object").toString());
        return sb.toString();
    }

    private ObjectWR$() {
        MODULE$ = this;
        this.BLOCK_SIZE = 4096;
        this.queue = new RequestQueue(DBCtr$.MODULE$.MAX_QUE_SIZE());
        ThreadScala$.MODULE$.start("scouter.server.db.ObjectWR", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                while (true) {
                    long location;
                    long dateunit;
                    ObjectWR.Order ord;
                    block9: {
                        block8: {
                            if (!DBCtr$.MODULE$.running()) {
                                ObjectWR$.MODULE$.close();
                                return;
                            }
                            ord = ObjectWR$.MODULE$.queue().get();
                            try {
                                dateunit = DateUtil.getDateUnit(System.currentTimeMillis());
                                if (ObjectWR$.MODULE$.curDbw() != null) break block8;
                                ObjectWR$.MODULE$.curDbw_$eq(ObjectWR$.MODULE$.open(DateUtil.yyyymmdd()));
                                break block9;
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                        if (ObjectWR$.MODULE$.curDbw().dateunit() != dateunit) {
                            ObjectWR$.MODULE$.curDbw().close();
                            ObjectWR$.MODULE$.curDbw_$eq(ObjectWR$.MODULE$.open(DateUtil.yyyymmdd()));
                        }
                    }
                    ObjectWR$.MODULE$.curDbw().dateunit_$eq(dateunit);
                    if (ord.add()) {
                        ObjectPack p = ord.pack();
                        long location2 = ObjectWR$.MODULE$.curDbw().index().get(p.objHash);
                        if (location2 < 0L) {
                            location2 = ObjectWR$.MODULE$.curDbw().writer().write(ObjectWR$.MODULE$.toBytes(p));
                            ObjectWR$.MODULE$.curDbw().index().set(p.objHash, location2);
                        } else {
                            ObjectWR$.MODULE$.curDbw().writer().update(location2, ObjectWR$.MODULE$.toBytes(p));
                        }
                    }
                    if (!ord.delete() || (location = ObjectWR$.MODULE$.curDbw().index().get(ord.hash())) < 0L) continue;
                    ObjectWR$.MODULE$.curDbw().index().delete(ord.hash());
                }
            }
        });
        this.curDbw = null;
        this.dbs = new HashMap();
    }
}

